/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.cli.Commands;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.MavenModelControllerClientConfiguration;
import org.wildfly.plugin.core.Deployment;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.core.DeploymentResult;
import org.wildfly.plugin.core.ServerHelper;
import org.wildfly.plugin.deployment.MojoDeploymentException;
import org.wildfly.plugin.deployment.domain.Domain;

abstract class AbstractDeployment
extends AbstractServerConnection {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Deprecated
    @Parameter
    private Domain domain;
    @Parameter(alias="server-groups", property="wildfly.serverGroups")
    private List<String> serverGroups;
    @Parameter(property="wildfly.deployment.name")
    private String name;
    @Parameter(alias="runtime-name", property="wildfly.deployment.runtime.name")
    private String runtimeName;
    @Deprecated
    @Parameter(alias="before-deployment")
    private Commands beforeDeployment;
    @Deprecated
    @Parameter(alias="after-deployment")
    private Commands afterDeployment;
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;
    @Inject
    private CommandExecutor commandExecutor;

    AbstractDeployment() {
    }

    protected abstract File file();

    @Override
    public abstract String goal();

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipExecution()) {
            this.getLog().debug((CharSequence)String.format("Skipping deployment of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        try (ModelControllerClient client = this.createClient();
             MavenModelControllerClientConfiguration configuration = this.getClientConfiguration();){
            boolean isDomain = ServerHelper.isDomainServer((ModelControllerClient)client);
            this.validate(isDomain);
            this.beforeDeployment(configuration);
            this.getLog().debug((CharSequence)"Executing deployment");
            Deployment deployment = this.configureDeployment(this.createDeployment());
            DeploymentResult result = this.executeDeployment(DeploymentManager.Factory.create((ModelControllerClient)client), deployment);
            if (!result.successful()) {
                throw new MojoExecutionException(String.format("Failed to execute goal %s: %s", this.goal(), result.getFailureMessage()));
            }
            this.afterDeployment(configuration);
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Failed to execute goal %s.", this.goal()), (Throwable)e);
        }
    }

    protected boolean skipExecution() {
        return this.skip;
    }

    protected void beforeDeployment(MavenModelControllerClientConfiguration configuration) throws MojoExecutionException, MojoFailureException, IOException {
        if (this.beforeDeployment != null) {
            this.commandExecutor.execute(configuration, this.beforeDeployment);
        }
    }

    protected abstract DeploymentResult executeDeployment(DeploymentManager var1, Deployment var2) throws IOException, MojoDeploymentException;

    protected void afterDeployment(MavenModelControllerClientConfiguration configuration) throws MojoExecutionException, MojoFailureException, IOException {
        if (this.afterDeployment != null) {
            this.commandExecutor.execute(configuration, this.afterDeployment);
        }
    }

    protected Deployment createDeployment() {
        return Deployment.of((File)this.file());
    }

    protected void validate(boolean isDomain) throws MojoDeploymentException {
        boolean hasServerGroups = this.hasServerGroups();
        if (isDomain) {
            if (!hasServerGroups) {
                throw new MojoDeploymentException("Server is running in domain mode, but no server groups have been defined.");
            }
        } else if (hasServerGroups) {
            throw new MojoDeploymentException("Server is running in standalone mode, but server groups have been defined.");
        }
    }

    private Deployment configureDeployment(Deployment deployment) {
        return deployment.setName(this.name).setRuntimeName(this.runtimeName).addServerGroups(this.getServerGroups());
    }

    private Collection<String> getServerGroups() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.domain != null) {
            result.addAll(this.domain.getServerGroups());
        }
        if (this.serverGroups != null) {
            result.addAll(this.serverGroups);
        }
        return result;
    }

    private boolean hasServerGroups() {
        int count = 0;
        if (this.domain != null) {
            count += this.domain.getServerGroups().size();
        }
        if (this.serverGroups != null) {
            count += this.serverGroups.size();
        }
        return count > 0;
    }
}

