/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.plugin.cli.CommandConfiguration;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.Archives;
import org.wildfly.plugin.repository.ArtifactNameBuilder;
import org.wildfly.plugin.repository.ArtifactResolver;

@Mojo(name="execute-commands", threadSafe=true)
public class ExecuteCommandsMojo
extends AbstractServerConnection {
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="wildfly.batch")
    private boolean batch;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Parameter(alias="system-properties")
    private Map<String, String> systemProperties;
    @Parameter
    private List<File> propertiesFiles = new ArrayList<File>();
    @Parameter(property="wildfly.commands")
    private List<String> commands = new ArrayList<String>();
    @Parameter(property="wildfly.scripts")
    private List<File> scripts = new ArrayList<File>();
    @Parameter(alias="fail-on-error", defaultValue="true", property="wildfly.failOnError")
    private boolean failOnError = true;
    @Parameter(defaultValue="false", property="wildfly.fork")
    private boolean fork;
    @Parameter(name="offline", defaultValue="false", property="wildfly.offline")
    private boolean offline = false;
    @Parameter(name="stdout", defaultValue="System.out", property="wildfly.stdout")
    private String stdout;
    @Parameter(alias="java-opts", property="wildfly.javaOpts")
    private String[] javaOpts;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File buildDir;
    @Inject
    private ArtifactResolver artifactResolver;
    @Inject
    private CommandExecutor commandExecutor;

    @Override
    public String goal() {
        return "execute-commands";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping commands execution");
            return;
        }
        CommandConfiguration cmdConfig = CommandConfiguration.of(this::createClient, this::getClientConfiguration).addCommands(this.commands).addJvmOptions(this.javaOpts).addPropertiesFiles(this.propertiesFiles).addScripts(this.scripts).addSystemProperties(this.systemProperties).setBatch(this.batch).setFailOnError(this.failOnError).setFork(this.fork).setJBossHome(this.jbossHome).setOffline(this.offline).setStdout(this.stdout).setTimeout(this.timeout);
        if (this.fork) {
            cmdConfig.setJBossHome(this.extractIfRequired());
        }
        this.commandExecutor.execute(cmdConfig);
    }

    public void setJavaOpts(String value) {
        if (value != null) {
            this.javaOpts = value.split("\\s+");
        }
    }

    private Path extractIfRequired() throws MojoFailureException {
        if (this.jbossHome != null) {
            return Paths.get(this.jbossHome, new String[0]);
        }
        this.getLog().warn((CharSequence)"The jboss-home parameter was not set. In 3.0.0 this parameter will be required. Downloading a server via Maven artifact will not longer be supported.");
        Path result = this.artifactResolver.resolve(this.session, this.repositories, ArtifactNameBuilder.forRuntime(null).build());
        try {
            return Archives.uncompress(result, this.buildDir.toPath());
        }
        catch (IOException e) {
            throw new MojoFailureException("Artifact was not successfully extracted: " + result, (Throwable)e);
        }
    }
}

