/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class BaseCommandConfiguration {
    private final Collection<String> jvmOptions;
    private final Collection<String> cliArguments;
    private final Collection<String> commands;
    private final Map<String, String> systemProperties;
    private final Collection<Path> propertiesFiles;
    private final Collection<Path> scripts;
    private final boolean batch;
    private final boolean failOnError;
    private final Path jbossHome;
    private final String stdout;
    private final int timeout;
    private final boolean append;
    private final boolean resolveExpression;

    protected BaseCommandConfiguration(AbstractBuilder<?> builder) {
        this.jvmOptions = ((AbstractBuilder)builder).jvmOptions;
        this.commands = ((AbstractBuilder)builder).commands;
        this.systemProperties = ((AbstractBuilder)builder).systemProperties;
        this.propertiesFiles = ((AbstractBuilder)builder).propertiesFiles;
        this.scripts = ((AbstractBuilder)builder).scripts;
        this.cliArguments = ((AbstractBuilder)builder).cliArguments;
        this.batch = ((AbstractBuilder)builder).batch;
        this.failOnError = ((AbstractBuilder)builder).failOnError;
        this.jbossHome = ((AbstractBuilder)builder).jbossHome;
        this.stdout = ((AbstractBuilder)builder).stdout;
        this.timeout = ((AbstractBuilder)builder).timeout;
        this.append = ((AbstractBuilder)builder).append;
        this.resolveExpression = ((AbstractBuilder)builder).resolveExpression;
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public Path getJBossHome() {
        return this.jbossHome;
    }

    public Collection<String> getJvmOptions() {
        return Collections.unmodifiableCollection(this.jvmOptions);
    }

    public Collection<String> getCLIArguments() {
        return Collections.unmodifiableCollection(this.cliArguments);
    }

    public Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(this.systemProperties);
    }

    public Collection<Path> getPropertiesFiles() {
        return Collections.unmodifiableCollection(this.propertiesFiles);
    }

    public Collection<String> getCommands() {
        return Collections.unmodifiableCollection(this.commands);
    }

    public Collection<Path> getScripts() {
        return Collections.unmodifiableCollection(this.scripts);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public String getStdout() {
        return this.stdout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isExpressionResolved() {
        return this.resolveExpression;
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        @Override
        protected Builder builderInstance() {
            return this;
        }
    }

    protected static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        private final Collection<String> jvmOptions = new ArrayList<String>();
        private final Collection<String> cliArguments = new ArrayList<String>();
        private final Collection<String> commands = new ArrayList<String>();
        private final Map<String, String> systemProperties = new LinkedHashMap<String, String>();
        private final Collection<Path> propertiesFiles = new ArrayList<Path>();
        private final Collection<Path> scripts = new ArrayList<Path>();
        private boolean batch;
        private boolean failOnError = true;
        private Path jbossHome;
        private String stdout;
        private int timeout;
        private boolean append;
        private boolean resolveExpression;

        protected AbstractBuilder() {
        }

        protected abstract T builderInstance();

        public T setAppend(boolean append) {
            this.append = append;
            return this.builderInstance();
        }

        public T setBatch(boolean batch) {
            this.batch = batch;
            return this.builderInstance();
        }

        public T setJBossHome(String jbossHome) {
            this.jbossHome = jbossHome == null ? null : Paths.get(jbossHome, new String[0]);
            return this.builderInstance();
        }

        public T setJBossHome(Path jbossHome) {
            this.jbossHome = jbossHome;
            return this.builderInstance();
        }

        public T addJvmOptions(String ... jvmOptions) {
            if (jvmOptions != null) {
                Collections.addAll(this.jvmOptions, jvmOptions);
            }
            return this.builderInstance();
        }

        public T addCLIArguments(String ... arguments) {
            if (arguments != null) {
                Collections.addAll(this.cliArguments, arguments);
            }
            return this.builderInstance();
        }

        public T addSystemProperties(Map<String, String> systemProperties) {
            if (systemProperties != null) {
                this.systemProperties.putAll(systemProperties);
            }
            return this.builderInstance();
        }

        public T addPropertiesFiles(Collection<File> propertiesFiles) {
            propertiesFiles.forEach(f -> this.propertiesFiles.add(f.toPath()));
            return this.builderInstance();
        }

        public T addCommands(Collection<String> commands) {
            if (commands != null) {
                this.commands.addAll(commands);
            }
            return this.builderInstance();
        }

        public T addScripts(Collection<File> scripts) {
            scripts.forEach(f -> this.scripts.add(f.toPath()));
            return this.builderInstance();
        }

        public T setFailOnError(boolean failOnError) {
            this.failOnError = failOnError;
            return this.builderInstance();
        }

        public T setStdout(String stdout) {
            this.stdout = stdout;
            return this.builderInstance();
        }

        public T setTimeout(int timeout) {
            this.timeout = timeout;
            return this.builderInstance();
        }

        public T setResolveExpression(boolean resolveExpression) {
            this.resolveExpression = resolveExpression;
            return this.builderInstance();
        }

        public BaseCommandConfiguration build() {
            return new BaseCommandConfiguration(this);
        }
    }
}

