/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.provision;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.InvalidChannelMetadataException;
import org.wildfly.channel.Repository;

public class ChannelConfiguration {
    private URL url;
    private ChannelManifestCoordinate manifestCoordinate;

    public URL getUrl() {
        return this.url;
    }

    public ChannelManifestCoordinate getManifestCoordinate() {
        return this.manifestCoordinate;
    }

    private void validate() throws MojoExecutionException {
        if (this.getUrl() != null) {
            if (this.getManifestCoordinate() != null) {
                throw new MojoExecutionException("Invalid Channel. A manifest-coordinate is specified although an URL is provided.");
            }
        } else {
            if (this.getManifestCoordinate() == null) {
                throw new MojoExecutionException("Invalid Channel. No manifest-coordinate or URL specified.");
            }
            ChannelManifestCoordinate coordinates = this.getManifestCoordinate();
            if (coordinates.getUrl() == null) {
                if (coordinates.getGroupId() == null) {
                    throw new MojoExecutionException("Invalid Channel. Manifest groupId is null.");
                }
                if (coordinates.getArtifactId() == null) {
                    throw new MojoExecutionException("Invalid Channel. Manifest artifactId is null.");
                }
            } else {
                if (coordinates.getGroupId() != null) {
                    throw new MojoExecutionException("Invalid Channel. Manifest groupId is set although an URL is provided.");
                }
                if (coordinates.getArtifactId() != null) {
                    throw new MojoExecutionException("Invalid Channel. Manifest artifactId is set although an URL is provided.");
                }
            }
        }
    }

    public Channel toChannel(Set<String> remoteRepositories, List<RemoteRepository> repositories, Log log) throws MojoExecutionException {
        Channel channel;
        this.validate();
        if (this.getUrl() == null) {
            ArrayList<Repository> repos = new ArrayList<Repository>();
            for (RemoteRepository r : repositories) {
                repos.add(new Repository(r.getId(), r.getUrl()));
            }
            channel = new Channel(null, null, null, repos, this.getManifestCoordinate(), null, null);
        } else {
            try {
                channel = ChannelMapper.from((URL)this.getUrl());
                for (Repository r : channel.getRepositories()) {
                    if (remoteRepositories.contains(r.getId())) continue;
                    log.warn((CharSequence)("Repository id " + r.getId() + " defined in channel " + this.getUrl() + " is not found in the configured Maven repositories. Will create a new repository."));
                }
            }
            catch (InvalidChannelMetadataException ex) {
                throw new MojoExecutionException("Invalid Channel: " + (ex.getValidationMessages() == null ? "" : ex.getValidationMessages()), (Exception)((Object)ex));
            }
        }
        return channel;
    }
}

