/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools;

import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.logging.Logger;

public class PluginProgressTracker<T>
implements ProgressCallback<T> {
    private static final String DELAYED_EXECUTION_MSG = "Delayed generation, waiting...";
    private final Logger log;
    private final String msgStart;
    private long lastTime;
    private final boolean delayed;

    private PluginProgressTracker(Logger log, String msgStart, boolean delayed) {
        this.log = log;
        this.msgStart = msgStart;
        this.delayed = delayed;
    }

    public void starting(ProgressTracker<T> tracker) {
        this.log.info((Object)this.msgStart);
        this.lastTime = System.currentTimeMillis();
    }

    public void processing(ProgressTracker<T> tracker) {
        if (this.delayed && tracker.getItem() == null) {
            this.log.info((Object)DELAYED_EXECUTION_MSG);
            return;
        }
        if (System.currentTimeMillis() - this.lastTime > 5000L) {
            if (tracker.getTotalVolume() > 0L) {
                this.log.info((Object)String.format("%s of %s (%s%%)", tracker.getProcessedVolume(), tracker.getTotalVolume(), (double)Math.round(tracker.getProgress() * 10.0) / 10.0));
            } else {
                this.log.info((Object)"In progress...");
            }
            this.lastTime = System.currentTimeMillis();
        }
    }

    public void processed(ProgressTracker<T> tracker) {
    }

    public void pulse(ProgressTracker<T> tracker) {
    }

    public void complete(ProgressTracker<T> tracker) {
    }

    public static void initTrackers(Provisioning pm, Logger log) {
        pm.setProgressCallback("PACKAGES", new PluginProgressTracker(log, "Installing packages", false));
        pm.setProgressCallback("CONFIGS", new PluginProgressTracker(log, "Generating configurations", true));
        pm.setProgressCallback("LAYOUT_BUILD", new PluginProgressTracker(log, "Resolving feature-packs", false));
        pm.setProgressCallback("JBMODULES", new PluginProgressTracker(log, "Resolving artifacts", false));
        pm.setProgressCallback("JBEXTRACONFIGS", new PluginProgressTracker(log, "Generating extra configurations", true));
    }
}

