/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.server;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.plugin.tools.ContainerDescription;
import org.wildfly.plugin.tools.DeploymentManager;
import org.wildfly.plugin.tools.server.ServerManager;

abstract class AbstractServerManager
implements ServerManager {
    private static final Logger LOGGER = Logger.getLogger(AbstractServerManager.class);
    protected final ProcessHandle process;
    private final DeploymentManager deploymentManager;

    protected AbstractServerManager(ProcessHandle process, ModelControllerClient client) {
        this.process = process;
        this.deploymentManager = DeploymentManager.Factory.create(client);
    }

    @Override
    public ContainerDescription containerDescription() throws IOException {
        return ContainerDescription.lookup(this.client());
    }

    @Override
    public DeploymentManager deploymentManager() {
        return this.deploymentManager;
    }

    @Override
    public String launchType() {
        return ServerManager.launchType(this.client()).orElse("unknown");
    }

    @Override
    public boolean waitFor(long startupTimeout, TimeUnit unit) throws InterruptedException {
        long timeout;
        long sleep = 100L;
        for (timeout = unit.toMillis(startupTimeout); timeout > 0L; timeout -= 100L) {
            long before = System.currentTimeMillis();
            if (this.isRunning()) break;
            timeout -= System.currentTimeMillis() - before;
            if (this.process != null && !this.process.isAlive()) {
                throw new RuntimeException(String.format("The process %d is no longer active.", this.process.pid()));
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        if (timeout <= 0L) {
            if (this.process != null) {
                this.process.destroy();
            }
            return false;
        }
        return true;
    }

    @Override
    public String takeSnapshot() throws IOException {
        ModelNode op = Operations.createOperation((String)"take-snapshot");
        ModelNode result = this.client().execute(op);
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new RuntimeException("The take-snapshot operation did not complete successfully: " + Operations.getFailureDescription((ModelNode)result).asString());
        }
        String snapshot = Operations.readResult((ModelNode)result).asString();
        return snapshot.contains(File.separator) ? snapshot.substring(snapshot.lastIndexOf(File.separator) + 1) : snapshot;
    }

    @Override
    public void executeReload(ModelNode reloadOp) {
        block3: {
            try {
                ModelNode result = this.client().execute(reloadOp);
                if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
                    throw new RuntimeException(String.format("Failed to reload the server with %s: %s", reloadOp, Operations.getFailureDescription((ModelNode)result)));
                }
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ExecutionException || cause instanceof CancellationException) break block3;
                throw new RuntimeException(e);
            }
        }
    }
}

