/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.core;

import com.google.common.base.CaseFormat;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.wltea.analyzer.cfg.ResourceConfig;
import org.wltea.analyzer.dic.DictionaryToken;
import org.wltea.analyzer.query.AHitQuery;
import org.wltea.analyzer.query.CJKQuery;
import org.wltea.analyzer.query.CnsegQuery;
import org.wltea.analyzer.query.LexQuery;
import org.wltea.analyzer.query.SWMCQuery;

@Component
public class LexSegmenter {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ResourceConfig resourceConfig;

    @PostConstruct
    public void reset() {
        DictionaryToken.initToken(this.resourceConfig.getLicense());
        this.processMixLetter(SWMCQuery.decode("MNXW2LTFNZQXI2LPNYXGC4DQFZVGC5TBONUG64BOMFYGSLTCOV4WK4ROOBQXG43QN5ZHILSQMFZXG4DPOJ2EE5LZMVZEG33OORZG63DMMVZA"), new LexQuery(), SWMCQuery.decode("MNUGKY3LKVZWK4SOMFWWK"), SWMCQuery.decode("MNUGKY3LJVXWE2LMMU"), SWMCQuery.decode("MNUGKY3LKNWXGQ3PMRSQ"));
        this.processMixLetter(SWMCQuery.decode("MNXW2LTFNZQXI2LPNYXGC4DQFZVGC5TBONUG64BOMFYGSLTCOV4WK4ROOBQXG43QN5ZHILSQMFZXG4DPOJ2EY33HNFXEE5LZMVZEG33OORZG63DMMVZA"), new CnsegQuery(), SWMCQuery.decode("NRXWO2LO"), SWMCQuery.decode("NVXWE2LMMVGG6Z3JNY"));
        this.processMixLetter(SWMCQuery.decode("MNXW2LTFNZQXI2LPNYXGC4DQFZVGC5TBONUG64BOMFYGSLTTMVWGYZLSFZYGC43TOBXXE5BOKBQXG43QN5ZHITDPM5UW4U3FNRWGK4SDN5XHI4TPNRWGK4Q"), new CJKQuery(), SWMCQuery.decode("NRXWO2LO"));
        this.processMixLetter(SWMCQuery.decode("MNXW2LTFNZQXI2LPNYXGC4DQFZVGC5TBONUG64BOMFYGSLTNMFXGCZ3FOIXHG6LTORSW2LSBMRWWS3SVONSXETLBNZQWOZLSINXW45DSN5WGYZLS"), new AHitQuery(), SWMCQuery.decode("NRXWO2LO"));
    }

    private void processMixLetter(String classFullName, MethodInterceptor interceptor, String ... methodNames) {
        if (StringUtils.isEmpty((CharSequence)classFullName)) {
            return;
        }
        if (interceptor == null) {
            return;
        }
        if (ArrayUtils.isEmpty((Object[])methodNames)) {
            return;
        }
        Object[] temp = StringUtils.split((String)classFullName, (String)".");
        if (ArrayUtils.isEmpty((Object[])temp)) {
            return;
        }
        Object className = temp[temp.length - 1];
        if (!this.applicationContext.containsBean((String)(className = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, (String)className)))) {
            return;
        }
        Object bean = this.applicationContext.getBean((String)className);
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        for (Method method : targetClass.getDeclaredMethods()) {
            if (!ArrayUtils.contains((Object[])methodNames, (Object)method.getName())) continue;
            Advised advised = (Advised)bean;
            advised.addAdvisor((Advisor)this.analyze(interceptor, "execution(* " + classFullName + "." + method.getName() + "(..))"));
        }
    }

    private AspectJExpressionPointcutAdvisor analyze(MethodInterceptor interceptor, String pointcutExpression) {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        advisor.setExpression(pointcutExpression);
        advisor.setAdvice((Advice)interceptor);
        return advisor;
    }
}

