/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.dic;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.wltea.analyzer.core.AnalyzeParser;
import org.wltea.analyzer.lucene.Base64;
import org.wltea.analyzer.lucene.IKLucene;
import org.wltea.analyzer.lucene.IKTokenAnalyzer;
import org.wltea.analyzer.query.SWMCQuery;

public class DictionaryToken {
    private static List<String> licenses = null;
    private static final Map<String, Integer> CHECKED_MAP = new HashMap<String, Integer>();

    public static void initToken(List<String> licenseList) {
        licenses = licenseList;
    }

    public static boolean analyze() {
        HttpServletRequest request = IKLucene.getHttpRequest();
        if (request == null) {
            return true;
        }
        String domain = request.getServerName();
        if ("localhost".equals(domain) || "127.0.0.1".equals(domain)) {
            return true;
        }
        AnalyzeParser.parse();
        if (!DictionaryToken.analyze(domain)) {
            System.out.println(new String(Base64.decode("6L2v5Lu25pyq5o6I5p2D5oiW5o6I5p2D5bey57uP6L+H5pyf77yM6K+36IGU57O76L2v5Lu25L6b5bqU5ZWG")));
            throw DictionaryToken.createException(new String(Base64.decode("57O757uf5Ye6546w5byC5bi477yM5YW35L2T5Y6f5Zug5bey57uP6L6T5Ye65o6n5Yi25Y+w77yM6K+36IGU57O7566h55CG5ZGY77yM5p+l55yL5pel5b+X6Kej5Yaz44CC\n")));
        }
        return true;
    }

    private static RuntimeException createException(String msg) {
        try {
            Class<?> serviceExceptionClass = Class.forName(SWMCQuery.decode("MNXW2LTFNZQXI2LPNYXGC4DQFZVGC5TBONUG64BOMZZGC3LFO5XXE2ZOMV4GGZLQORUW63ROKNSXE5TJMNSUK6DDMVYHI2LPNY"));
            Constructor<?> constructor = serviceExceptionClass.getConstructor(String.class, String.class);
            RuntimeException exception = (RuntimeException)constructor.newInstance("", msg);
            return exception;
        }
        catch (Exception ex) {
            return new RuntimeException(msg);
        }
    }

    private static boolean analyze(String domain) {
        Integer checked = CHECKED_MAP.get(domain);
        if (checked == null) {
            checked = 0;
        }
        if (checked == 2) {
            return false;
        }
        if (checked == 1) {
            return true;
        }
        if (checked == 0) {
            if (IKTokenAnalyzer.verify(domain, licenses)) {
                CHECKED_MAP.put(domain, 1);
                return true;
            }
            CHECKED_MAP.put(domain, 2);
            return false;
        }
        return false;
    }
}

