/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.lucene;

import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.wltea.analyzer.dic.HitUtils;
import org.wltea.analyzer.query.SWMCQuery;

public class IKTokenAnalyzer {
    private static final String PUBLIC_KEY = SWMCQuery.decode("GMYDQMJZMYZTAMDEGA3DAOJSME4DMNBYHA3GMNZQMQYDCMBRGAYTANJQGAYDGOBRHBSDAMBTGA4DCOBZGAZDQMJYGEYDAOJZGZRDKNTDMNRTGNZQGNSTMZTBHE3TSZLFGQ3TIYLCHE2WGOJRMMZDKYJYMM4GKNZUGU2GIMTGMQ4TKMRQG5QTKN3CHEZGCMLGMUYDEYJXGFSDGYLGMY2DAYRTMQ2TMZRWMY2TOMJVGI2DKZJUGYZDSNZWG44DSODFME4DAMRTGU2TGZRRHBSTINBSMUYTAZRSGNSGKZBRGNQTON3DMEZTGMBVGZQTIYTCGA3TENRWGRSTMZDDGU3TKN3EGMYDIZRZMM3GCYZYMYZDANDFMQ3DKYZXGI3WGMTBG4YWGNBZMI2DSNZYMRQTSZDBMI4TEMRUMJTDOZJTGBSTGM3FGNQTMYRUMM4GMNBTGE2WCNJSGNSTINRYMRSTIYZYMVQWEMLFGFSGMZJXHA2WINDGGM4TCOJQGIYDGMBRGAYDAMI");

    public static boolean verify(String domain, List<String> licenseList) {
        try {
            if (CollectionUtils.isEmpty(licenseList)) {
                return false;
            }
            for (String license : licenseList) {
                if (!IKTokenAnalyzer.verifyDomainLicense(license, domain)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean verifySign(String hexPublicKey, String signedStr, String str) {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(SWMCQuery.hexStrToBytes(hexPublicKey));
            KeyFactory keyFactory = KeyFactory.getInstance(SWMCQuery.decode("KJJUC"));
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            byte[] signed = SWMCQuery.hexStrToBytes(signedStr);
            Signature signature = Signature.getInstance(SWMCQuery.decode("JVCDK53JORUFEU2B"));
            signature.initVerify(publicKey);
            signature.update(str.getBytes());
            return signature.verify(signed);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean verifyDomainLicense(String license, String domain) {
        String[] ar = license.split(",");
        int size = ar.length;
        if (size != 2) {
            return false;
        }
        String sign = ar[0];
        String text = ar[1];
        boolean signResult = IKTokenAnalyzer.verifySign(PUBLIC_KEY, sign, text);
        if (signResult) {
            text = HitUtils.decryptCode(text);
            return IKTokenAnalyzer.parseLicenseText(text, domain);
        }
        return false;
    }

    private static boolean parseLicenseText(String str, String checkDomian) {
        String version = null;
        String type = null;
        String domain = null;
        String timeout = null;
        String ipstart = null;
        String ipend = null;
        String[] arr = str.split(",");
        if (arr.length > 1) {
            version = IKTokenAnalyzer.getValue(arr[0], SWMCQuery.decode("OZSXE43JN5XA"));
        }
        if (arr.length > 2) {
            type = IKTokenAnalyzer.getValue(arr[1], SWMCQuery.decode("OR4XAZI"));
        }
        if (arr.length > 3) {
            domain = IKTokenAnalyzer.getValue(arr[2], SWMCQuery.decode("MRXW2YLJNY"));
        }
        if (arr.length >= 4) {
            timeout = IKTokenAnalyzer.getValue(arr[3], SWMCQuery.decode("ORUW2ZLPOV2A"));
        }
        if (arr.length >= 5) {
            ipstart = IKTokenAnalyzer.getValue(arr[4], SWMCQuery.decode("NFYHG5DBOJ2A"));
        }
        if (arr.length >= 6) {
            ipend = IKTokenAnalyzer.getValue(arr[5], SWMCQuery.decode("NFYGK3TE"));
        }
        boolean domainResult = IKTokenAnalyzer.checkDomain(type, checkDomian, domain, ipstart, ipend);
        boolean timeResult = true;
        if (!SWMCQuery.decode("NZXWY2LNNF2A").equals(timeout)) {
            timeResult = NumberUtils.toLong((String)timeout, (long)Long.MAX_VALUE) > System.currentTimeMillis() / 1000L;
        }
        return domainResult && timeResult;
    }

    private static boolean checkDomain(String type, String currentDomain, String enableDomain, String ipstart, String ipend) {
        boolean domainResult = false;
        if ("1".equals(type) && currentDomain.contains(enableDomain)) {
            domainResult = true;
        }
        if ("0".equals(type) && currentDomain.equals(enableDomain)) {
            domainResult = true;
        }
        if ("2".equals(type)) {
            long checkip = IKTokenAnalyzer.ipToLong(currentDomain);
            long startip = IKTokenAnalyzer.ipToLong(ipstart);
            long endip = IKTokenAnalyzer.ipToLong(ipend);
            if (startip <= checkip && checkip <= endip) {
                domainResult = true;
            }
        }
        return domainResult;
    }

    private static String getValue(String str, String pre) {
        if (!str.startsWith(pre)) {
            return null;
        }
        String[] arr = str.split(":");
        return arr.length > 1 ? arr[1] : null;
    }

    private static long ipToLong(String strIp) {
        long[] ip = new long[4];
        int position1 = strIp.indexOf(".");
        int position2 = strIp.indexOf(".", position1 + 1);
        int position3 = strIp.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(strIp.substring(0, position1));
        ip[1] = Long.parseLong(strIp.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIp.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIp.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }
}

