/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.query;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.wltea.analyzer.query.SWMCQueryBuilder;

public class IKQueryExpressionParser {
    private List<Element> elements = new ArrayList<Element>();
    private Stack<Query> querys = new Stack();
    private Stack<Element> operates = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query parseExp(String expression, boolean quickMode) {
        Query lucenceQuery;
        block5: {
            lucenceQuery = null;
            if (expression != null && !"".equals(expression.trim())) {
                try {
                    this.splitElements(expression);
                    this.parseSyntax(quickMode);
                    if (this.querys.size() == 1) {
                        lucenceQuery = this.querys.pop();
                        break block5;
                    }
                    throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff1a \u7f3a\u5c11\u903b\u8f91\u64cd\u4f5c\u7b26 \u6216 \u62ec\u53f7\u7f3a\u5931");
                }
                finally {
                    this.elements.clear();
                    this.querys.clear();
                    this.operates.clear();
                }
            }
        }
        return lucenceQuery;
    }

    private void splitElements(String expression) {
        if (expression == null) {
            return;
        }
        Element curretElement = null;
        char[] expChars = expression.toCharArray();
        block16: for (int i = 0; i < expChars.length; ++i) {
            switch (expChars[i]) {
                case '&': {
                    if (curretElement == null) {
                        curretElement = new Element();
                        curretElement.type = (char)38;
                        curretElement.append(expChars[i]);
                        continue block16;
                    }
                    if (curretElement.type == '&') {
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    if (curretElement.type == '\'') {
                        curretElement.append(expChars[i]);
                        continue block16;
                    }
                    this.elements.add(curretElement);
                    curretElement = new Element();
                    curretElement.type = (char)38;
                    curretElement.append(expChars[i]);
                    continue block16;
                }
                case '|': {
                    if (curretElement == null) {
                        curretElement = new Element();
                        curretElement.type = (char)124;
                        curretElement.append(expChars[i]);
                        continue block16;
                    }
                    if (curretElement.type == '|') {
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    if (curretElement.type == '\'') {
                        curretElement.append(expChars[i]);
                        continue block16;
                    }
                    this.elements.add(curretElement);
                    curretElement = new Element();
                    curretElement.type = (char)124;
                    curretElement.append(expChars[i]);
                    continue block16;
                }
                case '-': {
                    if (curretElement != null) {
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                    }
                    curretElement = new Element();
                    curretElement.type = (char)45;
                    curretElement.append(expChars[i]);
                    this.elements.add(curretElement);
                    curretElement = null;
                    continue block16;
                }
                case '(': {
                    if (curretElement != null) {
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                    }
                    curretElement = new Element();
                    curretElement.type = (char)40;
                    curretElement.append(expChars[i]);
                    this.elements.add(curretElement);
                    curretElement = null;
                    continue block16;
                }
                case ')': {
                    if (curretElement != null) {
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                    }
                    curretElement = new Element();
                    curretElement.type = (char)41;
                    curretElement.append(expChars[i]);
                    this.elements.add(curretElement);
                    curretElement = null;
                    continue block16;
                }
                case ':': {
                    if (curretElement != null) {
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                    }
                    curretElement = new Element();
                    curretElement.type = (char)58;
                    curretElement.append(expChars[i]);
                    this.elements.add(curretElement);
                    curretElement = null;
                    continue block16;
                }
                case '=': {
                    if (curretElement != null) {
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                    }
                    curretElement = new Element();
                    curretElement.type = (char)61;
                    curretElement.append(expChars[i]);
                    this.elements.add(curretElement);
                    curretElement = null;
                    continue block16;
                }
                case ' ': {
                    if (curretElement == null) continue block16;
                    if (curretElement.type == '\'') {
                        curretElement.append(expChars[i]);
                        continue block16;
                    }
                    this.elements.add(curretElement);
                    curretElement = null;
                    continue block16;
                }
                case '\'': {
                    if (curretElement == null) {
                        curretElement = new Element();
                        curretElement.type = (char)39;
                        continue block16;
                    }
                    if (curretElement.type == '\'') {
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    this.elements.add(curretElement);
                    curretElement = new Element();
                    curretElement.type = (char)39;
                    continue block16;
                }
                case '[': {
                    if (curretElement != null) {
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                    }
                    curretElement = new Element();
                    curretElement.type = (char)91;
                    curretElement.append(expChars[i]);
                    this.elements.add(curretElement);
                    curretElement = null;
                    continue block16;
                }
                case ']': {
                    if (curretElement != null) {
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                    }
                    curretElement = new Element();
                    curretElement.type = (char)93;
                    curretElement.append(expChars[i]);
                    this.elements.add(curretElement);
                    curretElement = null;
                    continue block16;
                }
                case '{': {
                    if (curretElement != null) {
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                    }
                    curretElement = new Element();
                    curretElement.type = (char)123;
                    curretElement.append(expChars[i]);
                    this.elements.add(curretElement);
                    curretElement = null;
                    continue block16;
                }
                case '}': {
                    if (curretElement != null) {
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                    }
                    curretElement = new Element();
                    curretElement.type = (char)125;
                    curretElement.append(expChars[i]);
                    this.elements.add(curretElement);
                    curretElement = null;
                    continue block16;
                }
                case ',': {
                    if (curretElement != null) {
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                    }
                    curretElement = new Element();
                    curretElement.type = (char)44;
                    curretElement.append(expChars[i]);
                    this.elements.add(curretElement);
                    curretElement = null;
                    continue block16;
                }
                default: {
                    if (curretElement == null) {
                        curretElement = new Element();
                        curretElement.type = (char)70;
                        curretElement.append(expChars[i]);
                        continue block16;
                    }
                    if (curretElement.type == 'F') {
                        curretElement.append(expChars[i]);
                        continue block16;
                    }
                    if (curretElement.type == '\'') {
                        curretElement.append(expChars[i]);
                        continue block16;
                    }
                    this.elements.add(curretElement);
                    curretElement = new Element();
                    curretElement.type = (char)70;
                    curretElement.append(expChars[i]);
                }
            }
        }
        if (curretElement != null) {
            this.elements.add(curretElement);
            curretElement = null;
        }
    }

    private void parseSyntax(boolean quickMode) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Query q;
            Element e = this.elements.get(i);
            if ('F' == e.type) {
                Element e2 = this.elements.get(i + 1);
                if ('=' != e2.type && ':' != e2.type) {
                    throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff1a = \u6216 \uff1a \u53f7\u4e22\u5931");
                }
                Element e3 = this.elements.get(i + 2);
                if ('\'' == e3.type) {
                    i += 2;
                    if ('=' == e2.type) {
                        TermQuery tQuery = new TermQuery(new Term(e.toString(), e3.toString()));
                        this.querys.push((Query)tQuery);
                        continue;
                    }
                    if (':' != e2.type) continue;
                    String keyword = e3.toString();
                    Query _SWMCQuery = SWMCQueryBuilder.create(e.toString(), keyword, quickMode);
                    this.querys.push(_SWMCQuery);
                    continue;
                }
                if ('[' == e3.type || '{' == e3.type) {
                    i += 2;
                    LinkedList<Element> eQueue = new LinkedList<Element>();
                    eQueue.add(e3);
                    ++i;
                    while (i < this.elements.size()) {
                        Element eN = this.elements.get(i);
                        eQueue.add(eN);
                        if (']' == eN.type || '}' == eN.type) break;
                        ++i;
                    }
                    TermRangeQuery rangeQuery = this.toTermRangeQuery(e, eQueue);
                    this.querys.push((Query)rangeQuery);
                    continue;
                }
                throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff1a\u5339\u914d\u503c\u4e22\u5931");
            }
            if ('(' == e.type) {
                this.operates.push(e);
                continue;
            }
            if (')' == e.type) {
                boolean doPop = true;
                while (doPop && !this.operates.empty()) {
                    Element op = this.operates.pop();
                    if ('(' == op.type) {
                        doPop = false;
                        continue;
                    }
                    q = this.toBooleanQuery(op);
                    this.querys.push(q);
                }
                continue;
            }
            if (this.operates.isEmpty()) {
                this.operates.push(e);
                continue;
            }
            boolean doPeek = true;
            while (doPeek && !this.operates.isEmpty()) {
                Element eleOnTop = this.operates.peek();
                if ('(' == eleOnTop.type) {
                    doPeek = false;
                    this.operates.push(e);
                    continue;
                }
                if (this.compare(e, eleOnTop) == 1) {
                    this.operates.push(e);
                    doPeek = false;
                    continue;
                }
                if (this.compare(e, eleOnTop) == 0) {
                    q = this.toBooleanQuery(eleOnTop);
                    this.operates.pop();
                    this.querys.push(q);
                    continue;
                }
                q = this.toBooleanQuery(eleOnTop);
                this.operates.pop();
                this.querys.push(q);
            }
            if (!doPeek || !this.operates.empty()) continue;
            this.operates.push(e);
        }
        while (!this.operates.isEmpty()) {
            Element eleOnTop = this.operates.pop();
            Query q = this.toBooleanQuery(eleOnTop);
            this.querys.push(q);
        }
    }

    private Query toBooleanQuery(Element op) {
        if (this.querys.size() == 0) {
            return null;
        }
        BooleanQuery.Builder resultQuery = new BooleanQuery.Builder();
        if (this.querys.size() == 1) {
            return (Query)this.querys.get(0);
        }
        Query q2 = this.querys.pop();
        Query q1 = this.querys.pop();
        if ('&' == op.type) {
            List clauses;
            if (q1 != null) {
                if (q1 instanceof BooleanQuery) {
                    clauses = ((BooleanQuery)q1).clauses();
                    if (clauses.size() > 0 && ((BooleanClause)clauses.get(0)).getOccur() == BooleanClause.Occur.MUST) {
                        for (BooleanClause c : clauses) {
                            resultQuery.add(c);
                        }
                    } else {
                        resultQuery.add(q1, BooleanClause.Occur.MUST);
                    }
                } else {
                    resultQuery.add(q1, BooleanClause.Occur.MUST);
                }
            }
            if (q2 != null) {
                if (q2 instanceof BooleanQuery) {
                    clauses = ((BooleanQuery)q2).clauses();
                    if (clauses.size() > 0 && ((BooleanClause)clauses.get(0)).getOccur() == BooleanClause.Occur.MUST) {
                        for (BooleanClause c : clauses) {
                            resultQuery.add(c);
                        }
                    } else {
                        resultQuery.add(q2, BooleanClause.Occur.MUST);
                    }
                } else {
                    resultQuery.add(q2, BooleanClause.Occur.MUST);
                }
            }
        } else if ('|' == op.type) {
            List clauses;
            if (q1 != null) {
                if (q1 instanceof BooleanQuery) {
                    clauses = ((BooleanQuery)q1).clauses();
                    if (clauses.size() > 0 && ((BooleanClause)clauses.get(0)).getOccur() == BooleanClause.Occur.MUST) {
                        for (BooleanClause c : clauses) {
                            resultQuery.add(c);
                        }
                    } else {
                        resultQuery.add(q1, BooleanClause.Occur.SHOULD);
                    }
                } else {
                    resultQuery.add(q1, BooleanClause.Occur.SHOULD);
                }
            }
            if (q2 != null) {
                if (q2 instanceof BooleanQuery) {
                    clauses = ((BooleanQuery)q2).clauses();
                    if (clauses.size() > 0 && ((BooleanClause)clauses.get(0)).getOccur() == BooleanClause.Occur.MUST) {
                        for (BooleanClause c : clauses) {
                            resultQuery.add(c);
                        }
                    } else {
                        resultQuery.add(q2, BooleanClause.Occur.SHOULD);
                    }
                } else {
                    resultQuery.add(q2, BooleanClause.Occur.SHOULD);
                }
            }
        } else if ('-' == op.type) {
            if (q1 == null || q2 == null) {
                throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff1aSubQuery \u4e2a\u6570\u4e0d\u5339\u914d");
            }
            if (q1 instanceof BooleanQuery) {
                List clauses = ((BooleanQuery)q1).clauses();
                if (clauses.size() > 0) {
                    for (BooleanClause c : clauses) {
                        resultQuery.add(c);
                    }
                } else {
                    resultQuery.add(q1, BooleanClause.Occur.MUST);
                }
            } else {
                resultQuery.add(q1, BooleanClause.Occur.MUST);
            }
            resultQuery.add(q2, BooleanClause.Occur.MUST_NOT);
        }
        return resultQuery.build();
    }

    /*
     * Enabled aggressive block sorting
     */
    private TermRangeQuery toTermRangeQuery(Element fieldNameEle, LinkedList<Element> elements) {
        boolean includeFirst = false;
        boolean includeLast = false;
        String firstValue = null;
        String lastValue = null;
        Element first = elements.getFirst();
        if ('[' == first.type) {
            includeFirst = true;
        } else {
            if ('{' != first.type) throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38");
            includeFirst = false;
        }
        Element last = elements.getLast();
        if (']' == last.type) {
            includeLast = true;
        } else {
            if ('}' != last.type) throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38, RangeQuery\u7f3a\u5c11\u7ed3\u675f\u62ec\u53f7");
            includeLast = false;
        }
        if (elements.size() < 4) throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38, RangeQuery \u9519\u8bef");
        if (elements.size() > 5) {
            throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38, RangeQuery \u9519\u8bef");
        }
        Element e2 = elements.get(1);
        if ('\'' != e2.type) {
            if (',' != e2.type) throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38, RangeQuery\u683c\u5f0f\u9519\u8bef");
            firstValue = null;
            Element e3 = elements.get(2);
            if ('\'' != e3.type) throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff0cRangeQuery\u683c\u5f0f\u9519\u8bef");
            lastValue = e3.toString();
            return new TermRangeQuery(fieldNameEle.toString(), new BytesRef((CharSequence)firstValue), new BytesRef((CharSequence)lastValue), includeFirst, includeLast);
        }
        firstValue = e2.toString();
        Element e3 = elements.get(2);
        if (',' != e3.type) {
            throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38, RangeQuery\u7f3a\u5c11\u9017\u53f7\u5206\u9694");
        }
        Element e4 = elements.get(3);
        if ('\'' == e4.type) {
            lastValue = e4.toString();
            return new TermRangeQuery(fieldNameEle.toString(), new BytesRef((CharSequence)firstValue), new BytesRef((CharSequence)lastValue), includeFirst, includeLast);
        }
        if (e4 == last) return new TermRangeQuery(fieldNameEle.toString(), new BytesRef((CharSequence)firstValue), new BytesRef((CharSequence)lastValue), includeFirst, includeLast);
        throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff0cRangeQuery\u683c\u5f0f\u9519\u8bef");
    }

    private int compare(Element e1, Element e2) {
        if ('&' == e1.type) {
            if ('&' == e2.type) {
                return 0;
            }
            return 1;
        }
        if ('|' == e1.type) {
            if ('&' == e2.type) {
                return -1;
            }
            if ('|' == e2.type) {
                return 0;
            }
            return 1;
        }
        if ('-' == e2.type) {
            return 0;
        }
        return -1;
    }

    public static void main(String[] args) {
        IKQueryExpressionParser parser = new IKQueryExpressionParser();
        String ikQueryExp = "(id='ABcdRf' && date:{'20010101','20110101'} && keyword:'\u9b54\u517d\u4e2d\u56fd') || (content:'KSHT-KSH-A001-18'  || ulr='www.ik.com') - name:'\u6797\u826f\u76ca'";
        Query result = parser.parseExp(ikQueryExp, true);
        System.out.println(result);
    }

    private class Element {
        char type = '\u0000';
        StringBuffer eleTextBuff = new StringBuffer();

        public void append(char c) {
            this.eleTextBuff.append(c);
        }

        public String toString() {
            return this.eleTextBuff.toString();
        }
    }
}

