/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.query;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.codec.DecodingException;

public class SWMCQuery {
    private static final char[] hexLookUp = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static char[] DIGITS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".toCharArray();
    private static int MASK = DIGITS.length - 1;
    private static int SHIFT = Integer.numberOfTrailingZeros(DIGITS.length);
    private static HashMap<Character, Integer> CHAR_MAP = new HashMap();
    private static final String SEPARATOR = "-";

    public static String bytesToHexStr(byte[] bytes) {
        StringBuilder stringBuffer = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            stringBuffer.append(hexLookUp[aByte >>> 4 & 0xF]);
            stringBuffer.append(hexLookUp[aByte & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static byte[] hexStrToBytes(String str) {
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(str.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static String decode(String encoded) {
        if (StringUtils.isEmpty((CharSequence)encoded)) {
            return "";
        }
        byte[] bytes = new byte[]{};
        try {
            bytes = SWMCQuery.decodeInternal(encoded);
        }
        catch (DecodingException e) {
            e.printStackTrace();
        }
        if (bytes.length == 0) {
            return "";
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static byte[] decodeInternal(String encoded) throws DecodingException {
        encoded = encoded.trim().replaceAll(SEPARATOR, "").replaceAll(" ", "");
        encoded = encoded.replaceFirst("[=]*$", "");
        if ((encoded = encoded.toUpperCase(Locale.US)).length() == 0) {
            return new byte[0];
        }
        int encodedLength = encoded.length();
        int outLength = encodedLength * SHIFT / 8;
        byte[] result = new byte[outLength];
        int buffer = 0;
        int next = 0;
        int bitsLeft = 0;
        for (char c : encoded.toCharArray()) {
            if (!CHAR_MAP.containsKey(Character.valueOf(c))) {
                throw new DecodingException("Illegal character: " + c);
            }
            buffer <<= SHIFT;
            buffer |= CHAR_MAP.get(Character.valueOf(c)) & MASK;
            if ((bitsLeft += SHIFT) < 8) continue;
            result[next++] = (byte)(buffer >> bitsLeft - 8);
            bitsLeft -= 8;
        }
        return result;
    }

    static {
        for (int i = 0; i < DIGITS.length; ++i) {
            CHAR_MAP.put(Character.valueOf(DIGITS[i]), i);
        }
    }
}

