/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.util.intern;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xmlbeam.XBProjector;

public final class DOMHelper {
    private static final Comparator<? super Node> ATTRIBUTE_NODE_COMPARATOR = new Comparator<Node>(){

        private int compareMaybeNull(Comparable<Object> a, Object b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return a.compareTo(b);
        }

        @Override
        public int compare(Node o1, Node o2) {
            Comparable[] c1 = DOMHelper.getNodeAttributes(o1);
            Comparable[] c2 = DOMHelper.getNodeAttributes(o2);
            assert (c1.length == c2.length);
            for (int i = 0; i < c1.length; ++i) {
                int result = this.compareMaybeNull(c1[i], c2[i]);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    };

    public static Map<String, String> getNamespaceMapping(Document document) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("xmlns", "http://www.w3.org/2000/xmlns/");
        map.put("xml", "http://www.w3.org/XML/1998/namespace");
        Element root = document.getDocumentElement();
        if (root == null) {
            return map;
        }
        DOMHelper.fillNSMapWithPrefixesDeclaredInElement(map, root);
        return map;
    }

    private static void fillNSMapWithPrefixesDeclaredInElement(Map<String, String> nsMap, Element element) throws DOMException {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!"xmlns".equals(attribute.getPrefix()) && !"xmlns".equals(attribute.getLocalName())) continue;
            if ("xmlns".equals(attribute.getLocalName())) {
                nsMap.put("xbdefaultns", attribute.getNodeValue());
                continue;
            }
            nsMap.put(attribute.getLocalName(), attribute.getNodeValue());
        }
        NodeList childNodes = element.getChildNodes();
        for (Node n : DOMHelper.nodeListToIterator(childNodes)) {
            if (n.getNodeType() != 1) continue;
            DOMHelper.fillNSMapWithPrefixesDeclaredInElement(nsMap, (Element)n);
        }
    }

    public static void setDocumentElement(Document document, Element element) {
        Element documentElement = document.getDocumentElement();
        if (documentElement != null) {
            document.removeChild(documentElement);
        }
        if (element != null) {
            if (element.getOwnerDocument().equals(document)) {
                document.appendChild(element);
                return;
            }
            Node node = document.adoptNode(element);
            document.appendChild(node);
        }
    }

    public static boolean nodesAreEqual(Node a, Node b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (!Arrays.equals(DOMHelper.getNodeAttributes(a), DOMHelper.getNodeAttributes(b))) {
            return false;
        }
        if (!DOMHelper.namedNodeMapsAreEqual(a.getAttributes(), b.getAttributes())) {
            return false;
        }
        return DOMHelper.nodeListsAreEqual(a.getChildNodes(), b.getChildNodes());
    }

    private static boolean nodeListsAreEqual(NodeList a, NodeList b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getLength() != b.getLength()) {
            return false;
        }
        for (int i = 0; i < a.getLength(); ++i) {
            if (DOMHelper.nodesAreEqual(a.item(i), b.item(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean namedNodeMapsAreEqual(NamedNodeMap a, NamedNodeMap b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getLength() != b.getLength()) {
            return false;
        }
        ArrayList<Node> listA = new ArrayList<Node>(a.getLength());
        ArrayList<Node> listB = new ArrayList<Node>(a.getLength());
        for (int i = 0; i < a.getLength(); ++i) {
            listA.add(a.item(i));
            listB.add(b.item(i));
        }
        Collections.sort(listA, ATTRIBUTE_NODE_COMPARATOR);
        Collections.sort(listB, ATTRIBUTE_NODE_COMPARATOR);
        for (Node n1 : listA) {
            if (DOMHelper.nodesAreEqual(n1, (Node)listB.remove(0))) continue;
            return false;
        }
        return true;
    }

    private static Comparable<Object>[] getNodeAttributes(Node node) {
        return new Comparable[]{Short.valueOf(node.getNodeType()), node.getNodeName(), node.getLocalName(), node.getNamespaceURI(), node.getPrefix(), node.getNodeValue()};
    }

    public static int nodeHashCode(Node node) {
        int i;
        assert (node != null);
        int hash = 1 + node.getNodeType();
        hash = hash * 17 + Arrays.hashCode(DOMHelper.getNodeAttributes(node));
        if (node.hasAttributes()) {
            NamedNodeMap nodeMap = node.getAttributes();
            for (i = 0; i < nodeMap.getLength(); ++i) {
                hash = 31 * hash + DOMHelper.nodeHashCode(nodeMap.item(i));
            }
        }
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            for (i = 0; i < childNodes.getLength(); ++i) {
                hash = hash * 47 + DOMHelper.nodeHashCode(childNodes.item(i));
            }
        }
        return hash;
    }

    public static void setOrRemoveAttribute(Element element, String attributeName, String value) {
        if (value == null) {
            element.removeAttribute(attributeName);
            return;
        }
        element.setAttribute(attributeName, value);
    }

    public static <T extends Node> T renameNode(T node, String newName) {
        if (node instanceof Attr) {
            Attr attributeNode = (Attr)node;
            Element owner = attributeNode.getOwnerElement();
            if (owner == null) {
                throw new IllegalArgumentException("Attribute has no owner " + node);
            }
            owner.removeAttributeNode(attributeNode);
            owner.setAttribute(newName, attributeNode.getValue());
            return (T)owner.getAttributeNode(newName);
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            Node parent = element.getParentNode();
            Document document = element.getOwnerDocument();
            Element newElement = DOMHelper.createElement(document, newName);
            NodeList nodeList = element.getChildNodes();
            LinkedList<Node> toBeMoved = new LinkedList<Node>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                toBeMoved.add(nodeList.item(i));
            }
            for (Node e : toBeMoved) {
                element.removeChild(e);
                newElement.appendChild(e);
            }
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                newElement.setAttributeNode((Attr)attributes.item(i));
            }
            if (parent != null) {
                parent.replaceChild(newElement, element);
            }
            return (T)newElement;
        }
        throw new IllegalArgumentException("Can not rename node " + node);
    }

    public static void ensureOwnership(Document ownerDocument, Node node) {
        if (ownerDocument != node.getOwnerDocument()) {
            ownerDocument.adoptNode(node);
        }
    }

    public static Document getOwnerDocumentFor(Node documentOrElement) {
        if (9 == documentOrElement.getNodeType()) {
            return (Document)documentOrElement;
        }
        return documentOrElement.getOwnerDocument();
    }

    private static Element createElement(Document document, String elementName) {
        String prefix = DOMHelper.getPrefixOfQName(elementName);
        String namespaceURI = prefix.isEmpty() ? null : document.lookupNamespaceURI(prefix);
        Element element = namespaceURI == null ? document.createElement(elementName) : document.createElementNS(namespaceURI, elementName);
        return element;
    }

    private static String getPrefixOfQName(String elementName) {
        if (elementName.contains(":")) {
            return elementName.replaceAll(":.*", "");
        }
        return "";
    }

    public static void trim(Node domNode) {
        assert (domNode != null);
        assert (3 != domNode.getNodeType());
        LinkedList<Text> removeMe = new LinkedList<Text>();
        NodeList childNodes = domNode.getChildNodes();
        for (Node child : DOMHelper.nodeListToIterator(childNodes)) {
            if (3 == child.getNodeType()) {
                if (child.getNodeValue() != null && !child.getNodeValue().trim().isEmpty()) continue;
                removeMe.add((Text)child);
                continue;
            }
            DOMHelper.trim(child);
        }
        for (Text node : removeMe) {
            Node parent = node.getParentNode();
            if (parent == null) continue;
            parent.removeChild(node);
        }
    }

    private static Iterable<Node> nodeListToIterator(final NodeList nodeList) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    private int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return nodeList.getLength() > this.pos;
                    }

                    @Override
                    public Node next() {
                        return nodeList.item(this.pos++);
                    }

                    @Override
                    public void remove() {
                        throw new IllegalStateException();
                    }
                };
            }
        };
    }

    public static <T> List<T> asList(T node) {
        if (node == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(node);
    }

    public static void replaceElement(Element previous, Element newNode) {
        assert (previous.getParentNode() != null);
        Element parent = (Element)previous.getParentNode();
        Document document = DOMHelper.getOwnerDocumentFor(parent);
        DOMHelper.ensureOwnership(document, newNode);
        parent.replaceChild(newNode, previous);
    }

    public static void removeAllChildren(Node node) {
        assert (node != null);
        assert (node.getNodeType() != 2);
        if (node.getNodeType() == 10) {
            Element documentElement = ((Document)node).getDocumentElement();
            if (documentElement != null) {
                ((Document)node).removeChild(documentElement);
            }
            return;
        }
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            Node n = element.getFirstChild();
            while (n != null) {
                element.removeChild(n);
                n = element.getFirstChild();
            }
        }
    }

    public static void removeAttribute(Attr attributeNode) {
        if (attributeNode == null) {
            return;
        }
        Element owner = attributeNode.getOwnerElement();
        if (owner == null) {
            return;
        }
        owner.removeAttributeNode(attributeNode);
    }

    private static void removeNode(Node node) {
        if (node == null) {
            return;
        }
        while (node.hasChildNodes()) {
            DOMHelper.removeNode(node.getFirstChild());
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        parent.removeChild(node);
    }

    public static Node appendClone(Element parentElement, Node o) {
        Node clone = o.cloneNode(true);
        DOMHelper.ensureOwnership(DOMHelper.getOwnerDocumentFor(parentElement), clone);
        parentElement.appendChild(clone);
        return clone;
    }

    public static void removeNodes(Iterable<? extends Node> existingNodes) {
        for (Node node : existingNodes) {
            DOMHelper.removeNode(node);
        }
    }

    public static String toXMLString(XBProjector projector, Node domNode) {
        if (domNode == null) {
            return "<null>";
        }
        if (domNode.getNodeType() == 2) {
            return domNode.toString();
        }
        try {
            StringWriter writer = new StringWriter();
            projector.config().createTransformer(new Document[0]).transform(new DOMSource(domNode), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            return output;
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static String directTextContent(Node item) {
        NodeList childNodes = item.getChildNodes();
        if (childNodes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 3) continue;
            sb.append(child.getNodeValue());
        }
        return sb.toString();
    }

    public static void setDirectTextContent(Node elementToChange, String asString) {
        assert (elementToChange.getNodeType() != 9);
        if (2 == elementToChange.getNodeType()) {
            elementToChange.setTextContent(asString);
            return;
        }
        LinkedList<Node> nodes = new LinkedList<Node>();
        LinkedList nodes2 = new LinkedList();
        for (Node n : DOMHelper.nodeListToIterator(elementToChange.getChildNodes())) {
            if (3 == n.getNodeType()) continue;
            nodes.add(n);
        }
        if (asString != null && !asString.isEmpty()) {
            elementToChange.setTextContent(asString);
            for (Node n : DOMHelper.nodeListToIterator(elementToChange.getChildNodes())) {
                if (3 != n.getNodeType()) continue;
                nodes.add(n);
            }
        }
        DOMHelper.removeAllChildren(elementToChange);
        for (Node n : nodes) {
            elementToChange.appendChild(n);
        }
        for (Node n : nodes2) {
            elementToChange.appendChild(n);
        }
    }
}

