/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam;

import javax.xml.xpath.XPathExpressionException;
import org.xmlbeam.exceptions.XBException;
import org.xmlbeam.intern.DOMChangeListener;

abstract class DomChangeTracker
implements DOMChangeListener {
    private boolean needRefresh = true;

    DomChangeTracker() {
    }

    @Override
    public void domChanged() {
        this.needRefresh = true;
    }

    void refreshForReadIfNeeded() {
        if (this.needRefresh) {
            this.invokeRefresh(false);
        }
    }

    abstract void refresh(boolean var1) throws XPathExpressionException;

    void refreshForWriteIfNeeded() {
        if (this.needRefresh) {
            this.invokeRefresh(true);
        }
    }

    private void invokeRefresh(boolean b) {
        try {
            this.refresh(b);
            this.needRefresh = false;
        }
        catch (XPathExpressionException e) {
            this.needRefresh = true;
            throw new XBException("Unexpected error during evaluation.", e);
        }
    }
}

