/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.xmlbeam.AutoMap;
import org.xmlbeam.DefaultXPathBinder;
import org.xmlbeam.XBProjector;
import org.xmlbeam.evaluation.CanEvaluate;
import org.xmlbeam.evaluation.DefaultXPathEvaluator;
import org.xmlbeam.evaluation.DocumentResolver;
import org.xmlbeam.evaluation.InvocationContext;
import org.xmlbeam.evaluation.XPathEvaluator;
import org.xmlbeam.types.XBAutoMap;
import org.xmlbeam.util.IOHelper;
import org.xmlbeam.util.intern.DocScope;
import org.xmlbeam.util.intern.ReflectionHelper;
import org.xmlbeam.util.intern.Scope;

public class UrlIO
implements CanEvaluate {
    private final XBProjector projector;
    private final Map<String, String> requestProperties = new HashMap<String, String>();
    private final String url;

    public UrlIO(XBProjector projector, String url) {
        this.projector = projector;
        this.url = url;
        this.requestProperties.put("Content-Type", "text/xml");
    }

    @Scope(value=DocScope.IO)
    public <T> T read(Class<T> projectionInterface) throws IOException {
        Class<?> callerClass = null;
        if (IOHelper.isResourceProtocol(this.url)) {
            callerClass = ReflectionHelper.getDirectCallerClass();
        }
        Document document = IOHelper.getDocumentFromURL(this.projector.config().createDocumentBuilder(), this.url, this.requestProperties, projectionInterface, callerClass);
        return this.projector.projectDOMNode(document, projectionInterface);
    }

    @Scope(value=DocScope.IO)
    public String write(Object projection) throws IOException {
        return IOHelper.inputStreamToString(IOHelper.httpPost(this.url, projection.toString(), this.requestProperties), new String[0]);
    }

    @Scope(value=DocScope.IO)
    public UrlIO addRequestProperties(Map<String, String> params) {
        this.requestProperties.putAll(params);
        return this;
    }

    @Scope(value=DocScope.IO)
    public UrlIO addRequestProperty(String name, String value) {
        this.requestProperties.put(name, value);
        return this;
    }

    @Override
    @Scope(value=DocScope.IO)
    public XPathEvaluator evalXPath(String xpath) {
        return new DefaultXPathEvaluator(this.projector, new DocumentResolver(){

            @Override
            public Document resolve(Class<?> ... resourceAwareClasses) throws IOException {
                return IOHelper.getDocumentFromURL(UrlIO.this.projector.config().createDocumentBuilder(), UrlIO.this.url, UrlIO.this.requestProperties, resourceAwareClasses);
            }
        }, xpath);
    }

    @Scope(value=DocScope.IO)
    public <T> XBAutoMap<T> readAsMapOf(Class<T> valueType) throws IOException {
        DefaultXPathBinder.validateEvaluationType(valueType);
        Class<?> resourceAwareClass = ReflectionHelper.getDirectCallerClass();
        Document document = IOHelper.getDocumentFromURL(this.projector.config().createDocumentBuilder(), this.url, this.requestProperties, resourceAwareClass);
        InvocationContext invocationContext = new InvocationContext(null, null, null, null, null, valueType, this.projector);
        return new AutoMap(document, invocationContext, valueType);
    }
}

