/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.cts;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.test.cts.TestData;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.velocity.internal.log.SLF4JLogChute;
import org.xwiki.xml.XMLUtils;

public class RenderingTest {
    private static final String CTS_SYNTAX_ID = Syntax.XDOMXML_CURRENT.toIdString();
    private static final VelocityEngine VELOCITY_ENGINE = new VelocityEngine();
    private static final String SPECIAL_SYNTAX_START = "${{{";
    private static final String SPECIAL_SYNTAX_END = "}}}";
    private TestData testData;
    private ComponentManager componentManager;
    private String metadataSyntaxId;

    public RenderingTest(TestData testData, String metadataSyntaxId, ComponentManager componentManager) {
        this.testData = testData;
        this.componentManager = componentManager;
        this.metadataSyntaxId = metadataSyntaxId;
    }

    @Test
    public void execute() throws Exception {
        if (this.testData.isSyntaxInputTest) {
            this.executeInputTest();
        } else {
            this.executeOutputTest();
        }
    }

    private void executeInputTest() throws Exception {
        this.executeTest(this.testData.syntaxData, this.testData.syntaxId, this.testData.ctsData, CTS_SYNTAX_ID);
    }

    private void executeOutputTest() throws Exception {
        this.executeTest(this.testData.ctsData, CTS_SYNTAX_ID, this.testData.syntaxData, this.testData.syntaxId);
    }

    private void executeTest(String inputData, String inputSyntaxId, String expectedOutputData, String outputSyntaxId) throws Exception {
        Syntax inputSyntax = this.getInputSyntax(inputSyntaxId, outputSyntaxId);
        Syntax expectedSyntax = this.getOutputSyntax(inputSyntaxId, outputSyntaxId);
        Syntax validatedSyntax = inputSyntax.toIdString().equals(this.metadataSyntaxId) ? inputSyntax : expectedSyntax;
        String evaluatedInputData = this.evaluateContent(inputData, validatedSyntax);
        String evaluatedOutputData = this.evaluateContent(expectedOutputData, validatedSyntax);
        String result = this.convert(evaluatedInputData, inputSyntax.toIdString(), expectedSyntax.toIdString());
        try {
            if (this.isXMLSyntax(outputSyntaxId)) {
                this.assertExpectedResult(XMLUtils.formatXMLContent((String)this.normalizeXMLContent(evaluatedOutputData, outputSyntaxId)), XMLUtils.formatXMLContent((String)result));
            } else {
                this.assertExpectedResult(evaluatedOutputData, result);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Failed to compare expected result with [%s]", result), e);
        }
    }

    private boolean isStreamingTest(String inputSyntaxId, String outputSyntaxId) {
        return this.getComponentManager().hasComponent(StreamParser.class, inputSyntaxId) && this.getComponentManager().hasComponent(PrintRendererFactory.class, outputSyntaxId);
    }

    private Syntax getInputSyntax(String inputSyntaxId, String outputSyntaxId) throws Exception {
        Syntax syntax;
        if (this.isStreamingTest(inputSyntaxId, outputSyntaxId)) {
            StreamParser parser = (StreamParser)this.getComponentManager().getInstance(StreamParser.class, inputSyntaxId);
            syntax = parser.getSyntax();
        } else {
            Parser parser = (Parser)this.getComponentManager().getInstance(Parser.class, inputSyntaxId);
            syntax = parser.getSyntax();
        }
        return syntax;
    }

    private Syntax getOutputSyntax(String inputSyntaxId, String outputSyntaxId) throws Exception {
        Syntax syntax;
        if (this.isStreamingTest(inputSyntaxId, outputSyntaxId)) {
            PrintRendererFactory rendererFactory = (PrintRendererFactory)this.getComponentManager().getInstance(PrintRendererFactory.class, outputSyntaxId);
            syntax = rendererFactory.getSyntax();
        } else {
            syntax = Syntax.valueOf((String)outputSyntaxId);
        }
        return syntax;
    }

    private boolean isXMLSyntax(String syntaxId) {
        return syntaxId.startsWith("xdom+xml") || syntaxId.startsWith("docbook");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convert(String source, String sourceSyntaxId, String targetSyntaxId) throws Exception {
        String result;
        ExecutionContext executionContext = new ExecutionContext();
        ExecutionContextManager executionContextManager = (ExecutionContextManager)this.componentManager.getInstance(ExecutionContextManager.class);
        executionContextManager.initialize(executionContext);
        RenderingContext renderingContext = (RenderingContext)this.componentManager.getInstance(RenderingContext.class);
        ((MutableRenderingContext)renderingContext).push(renderingContext.getTransformation(), renderingContext.getXDOM(), renderingContext.getDefaultSyntax(), renderingContext.getTransformationId(), renderingContext.isRestricted(), Syntax.valueOf((String)targetSyntaxId));
        try {
            StreamParser parser;
            if (this.isStreamingTest(sourceSyntaxId, targetSyntaxId)) {
                parser = (StreamParser)this.getComponentManager().getInstance(StreamParser.class, sourceSyntaxId);
                PrintRendererFactory rendererFactory = (PrintRendererFactory)this.getComponentManager().getInstance(PrintRendererFactory.class, targetSyntaxId);
                result = this.convert(source, parser, rendererFactory);
            } else {
                parser = (Parser)this.getComponentManager().getInstance(Parser.class, sourceSyntaxId);
                BlockRenderer blockRenderer = (BlockRenderer)this.getComponentManager().getInstance(BlockRenderer.class, targetSyntaxId);
                result = this.convert(source, (Parser)parser, blockRenderer);
            }
        }
        finally {
            ((MutableRenderingContext)renderingContext).pop();
            Execution execution = (Execution)this.componentManager.getInstance(Execution.class);
            execution.removeContext();
        }
        return result;
    }

    private String convert(String source, StreamParser parser, PrintRendererFactory rendererFactory) throws Exception {
        PrintRenderer renderer = rendererFactory.createRenderer((WikiPrinter)new DefaultWikiPrinter());
        parser.parse((Reader)new StringReader(source), (Listener)renderer);
        return renderer.getPrinter().toString();
    }

    private String convert(String source, Parser parser, BlockRenderer blockRenderer) throws Exception {
        XDOM xdom = parser.parse((Reader)new StringReader(source));
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        blockRenderer.render((Block)xdom, (WikiPrinter)printer);
        return printer.toString();
    }

    private String normalizeXMLContent(String content, String syntaxId) throws Exception {
        return this.convert(content, syntaxId, syntaxId);
    }

    private String evaluateContent(String content, Syntax syntax) {
        StringBuilder builder = new StringBuilder();
        String fullSpecialSyntaxStart = String.format("%svelocity:", SPECIAL_SYNTAX_START);
        int pos = content.indexOf(fullSpecialSyntaxStart);
        if (pos > -1) {
            builder.append(content.substring(0, pos));
            int pos2 = content.indexOf(SPECIAL_SYNTAX_END, pos + fullSpecialSyntaxStart.length());
            if (pos2 == -1) {
                throw new RuntimeException("Invalid velocity declaration: missing closing part }}}");
            }
            VelocityContext context = new VelocityContext();
            context.put("syntax", (Object)syntax);
            StringWriter writer = new StringWriter();
            VELOCITY_ENGINE.evaluate((Context)context, (Writer)writer, "Rendering CTS", content.substring(pos + fullSpecialSyntaxStart.length(), pos2));
            builder.append(writer.toString());
            builder.append(this.evaluateContent(content.substring(pos2 + SPECIAL_SYNTAX_END.length()), syntax));
        } else {
            builder.append(content);
        }
        return builder.toString();
    }

    private void assertExpectedResult(String expected, String result) {
        String escapedExpected = this.escapeRegexContent(expected);
        Pattern pattern = Pattern.compile(escapedExpected, 32);
        Matcher matcher = pattern.matcher(result);
        if (!matcher.matches()) {
            throw new ComparisonFailure("", expected, result);
        }
    }

    private String escapeRegexContent(String content) {
        StringBuilder builder = new StringBuilder();
        String fullSpecialSyntaxStart = String.format("%sregex:", SPECIAL_SYNTAX_START);
        int pos = content.indexOf(fullSpecialSyntaxStart);
        if (pos > -1) {
            builder.append(Pattern.quote(content.substring(0, pos)));
            int pos2 = this.findPositionOfRegexEnd(content, pos + fullSpecialSyntaxStart.length());
            if (pos2 == -1) {
                throw new RuntimeException("Invalid regex declaration: missing closing part }}}");
            }
            builder.append(content.substring(pos + fullSpecialSyntaxStart.length(), pos2));
            builder.append(this.escapeRegexContent(content.substring(pos2 + SPECIAL_SYNTAX_END.length())));
        } else {
            builder.append(Pattern.quote(content));
        }
        return builder.toString();
    }

    private int findPositionOfRegexEnd(String content, int pos) {
        int result = content.indexOf(SPECIAL_SYNTAX_END, pos);
        if (result > -1 && content.charAt(result - 1) == '\\') {
            result = this.findPositionOfRegexEnd(content, result + 1);
        }
        return result;
    }

    private ComponentManager getComponentManager() {
        return this.componentManager;
    }

    static {
        VELOCITY_ENGINE.setProperty("runtime.log.logsystem", (Object)new SLF4JLogChute());
    }
}

