/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.collections;

import org.yatech.jedis.collections.JedisList;
import org.yatech.jedis.collections.JedisMap;
import org.yatech.jedis.collections.JedisSet;
import org.yatech.jedis.collections.JedisSortedSet;
import org.yatech.jedis.collections.Utils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisCollections {
    private final JedisPool jedisPool;

    private JedisCollections(JedisPool jedisPool) {
        this.jedisPool = Utils.checkNotNull(jedisPool, "jedisPool");
    }

    public static JedisCollections getInstance(JedisPool jedisPool) {
        return new JedisCollections(jedisPool);
    }

    public static JedisMap getMap(Jedis jedis, String key) {
        return new JedisMap(jedis, key);
    }

    public JedisMap getMap(int db, String key) {
        return new JedisMap(this.jedisPool, db, key);
    }

    public static JedisList getList(Jedis jedis, String key) {
        return new JedisList(jedis, key);
    }

    public JedisList getList(int db, String key) {
        return new JedisList(this.jedisPool, db, key);
    }

    public static JedisSet getSet(Jedis jedis, String key) {
        return new JedisSet(jedis, key);
    }

    public JedisSet getSet(int db, String key) {
        return new JedisSet(this.jedisPool, db, key);
    }

    public static JedisSortedSet getSortedSet(Jedis jedis, String key) {
        return new JedisSortedSet(jedis, key);
    }

    public static JedisSortedSet getSortedSet(Jedis jedis, String key, JedisSortedSet.ScoreProvider scoreProvider) {
        return new JedisSortedSet(jedis, key, scoreProvider);
    }

    public JedisSortedSet getSortedSet(int db, String key) {
        return new JedisSortedSet(this.jedisPool, db, key);
    }

    public JedisSortedSet getSortedSet(int db, String key, JedisSortedSet.ScoreProvider scoreProvider) {
        return new JedisSortedSet(this.jedisPool, db, key, scoreProvider);
    }
}

