/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.yatech.jedis.collections.JedisCallable;
import org.yatech.jedis.collections.JedisCollectionBase;
import org.yatech.jedis.collections.Utils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisSet
extends JedisCollectionBase
implements Set<String> {
    JedisSet(JedisPool jedisPool, int db, String key) {
        super(jedisPool, db, key);
    }

    JedisSet(Jedis jedis, String key) {
        super(jedis, key);
    }

    @Override
    public int size() {
        return Integer.valueOf("" + this.cardinality());
    }

    public long cardinality() {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.scard(JedisSet.this.getKey());
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    @Override
    public boolean contains(final Object o) {
        return this.doWithJedis(new JedisCallable<Boolean>(){

            @Override
            public Boolean call(Jedis jedis) {
                return jedis.sismember(JedisSet.this.getKey(), o.toString());
            }
        });
    }

    @Override
    public Iterator<String> iterator() {
        return this.toSet().iterator();
    }

    public Set<String> toSet() {
        return this.doWithJedis(new JedisCallable<Set<String>>(){

            @Override
            public Set<String> call(Jedis jedis) {
                return jedis.smembers(JedisSet.this.getKey());
            }
        });
    }

    @Override
    public Object[] toArray() {
        return this.toSet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toSet().toArray(a);
    }

    @Override
    public boolean add(String member) {
        return this.addAll(member) > 0L;
    }

    public long addAll(final String ... members) {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.sadd(JedisSet.this.getKey(), members);
            }
        });
    }

    @Override
    public boolean remove(Object member) {
        return this.removeAll(member.toString()) > 0L;
    }

    public long removeAll(final String ... members) {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.srem(JedisSet.this.getKey(), members);
            }
        });
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> members) {
        return this.addAll(members.toArray(new String[members.size()])) > 0L;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        for (String member : this.toSet()) {
            if (c.contains(member)) continue;
            changed |= this.remove(member);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> members) {
        return this.removeAll(Utils.toStringArray(members)) > 0L;
    }

    @Override
    public void clear() {
        this.doWithJedis(new JedisCallable<Void>(){

            @Override
            public Void call(Jedis jedis) {
                jedis.del(JedisSet.this.getKey());
                return null;
            }
        });
    }

    public String pop() {
        return this.doWithJedis(new JedisCallable<String>(){

            @Override
            public String call(Jedis jedis) {
                return jedis.spop(JedisSet.this.getKey());
            }
        });
    }

    public Set<String> pop(final long count) {
        return this.doWithJedis(new JedisCallable<Set<String>>(){

            @Override
            public Set<String> call(Jedis jedis) {
                return jedis.spop(JedisSet.this.getKey(), count);
            }
        });
    }
}

