/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.yatech.jedis.collections.JedisCallable;
import org.yatech.jedis.collections.JedisCollectionBase;
import org.yatech.jedis.collections.Utils;
import org.yatech.jedis.utils.LexRange;
import org.yatech.jedis.utils.ScoreRange;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisSortedSet
extends JedisCollectionBase
implements Set<String> {
    public static final ScoreProvider CURRENT_TIME_SCORE_PROVIDER = new ScoreProvider(){

        @Override
        public double getScore(String member) {
            return System.currentTimeMillis();
        }
    };
    public static final ScoreProvider FIXED_ZERO_SCORE_PROVIDER = new ScoreProvider(){

        @Override
        public double getScore(String member) {
            return 0.0;
        }
    };
    private static final ScoreProvider DEFAULT_SCORE_PROVIDER = CURRENT_TIME_SCORE_PROVIDER;
    private final ScoreProvider scoreProvider;

    JedisSortedSet(JedisPool jedisPool, int db, String key) {
        this(jedisPool, db, key, DEFAULT_SCORE_PROVIDER);
    }

    JedisSortedSet(JedisPool jedisPool, int db, String key, ScoreProvider scoreProvider) {
        super(jedisPool, db, key);
        this.scoreProvider = scoreProvider == null ? DEFAULT_SCORE_PROVIDER : scoreProvider;
    }

    JedisSortedSet(Jedis jedis, String key) {
        this(jedis, key, DEFAULT_SCORE_PROVIDER);
    }

    JedisSortedSet(Jedis jedis, String key, ScoreProvider scoreProvider) {
        super(jedis, key);
        this.scoreProvider = scoreProvider == null ? DEFAULT_SCORE_PROVIDER : scoreProvider;
    }

    @Override
    public int size() {
        return Integer.valueOf("" + this.cardinality());
    }

    public long cardinality() {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.zcard(JedisSortedSet.this.getKey());
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    @Override
    public boolean contains(Object member) {
        return this.score(member.toString()) != null;
    }

    public Double score(final String member) {
        return this.doWithJedis(new JedisCallable<Double>(){

            @Override
            public Double call(Jedis jedis) {
                return jedis.zscore(JedisSortedSet.this.getKey(), member);
            }
        });
    }

    @Override
    public Iterator<String> iterator() {
        return this.toSet().iterator();
    }

    public Set<String> toSet() {
        return this.doWithJedis(new JedisCallable<Set<String>>(){

            @Override
            public Set<String> call(Jedis jedis) {
                return jedis.zrange(JedisSortedSet.this.getKey(), 0L, -1L);
            }
        });
    }

    @Override
    public Object[] toArray() {
        return this.toSet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toSet().toArray(a);
    }

    @Override
    public boolean add(String member) {
        double score = this.scoreProvider.getScore(member);
        return this.add(member, score);
    }

    public boolean add(final String member, final double score) {
        return this.doWithJedis(new JedisCallable<Boolean>(){

            @Override
            public Boolean call(Jedis jedis) {
                return jedis.zadd(JedisSortedSet.this.getKey(), score, member) > 0L;
            }
        });
    }

    public long addAll(String ... members) {
        HashMap<String, Double> scoredMembers = new HashMap<String, Double>(members.length);
        for (String member : members) {
            scoredMembers.put(member, this.scoreProvider.getScore(member));
        }
        return this.addAll(scoredMembers);
    }

    public long addAll(final Map<String, Double> scoredMember) {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.zadd(JedisSortedSet.this.getKey(), scoredMember);
            }
        });
    }

    @Override
    public boolean remove(Object member) {
        return this.removeAll(member.toString()) > 0L;
    }

    public long removeAll(final String ... members) {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.zrem(JedisSortedSet.this.getKey(), members);
            }
        });
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> members) {
        return this.addAll(members.toArray(new String[members.size()])) > 0L;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        for (String member : this.toSet()) {
            if (c.contains(member)) continue;
            changed |= this.remove(member);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> members) {
        return this.removeAll(Utils.toStringArray(members)) > 0L;
    }

    @Override
    public void clear() {
        this.doWithJedis(new JedisCallable<Void>(){

            @Override
            public Void call(Jedis jedis) {
                jedis.del(JedisSortedSet.this.getKey());
                return null;
            }
        });
    }

    public Long rank(final String member) {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.zrank(JedisSortedSet.this.getKey(), member);
            }
        });
    }

    public Long rankReverse(final String member) {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.zrevrank(JedisSortedSet.this.getKey(), member);
            }
        });
    }

    public Set<String> rangeByRank(final long start, final long end) {
        return this.doWithJedis(new JedisCallable<Set<String>>(){

            @Override
            public Set<String> call(Jedis jedis) {
                return jedis.zrange(JedisSortedSet.this.getKey(), start, end);
            }
        });
    }

    public Set<String> rangeByRankReverse(final long start, final long end) {
        return this.doWithJedis(new JedisCallable<Set<String>>(){

            @Override
            public Set<String> call(Jedis jedis) {
                return jedis.zrevrange(JedisSortedSet.this.getKey(), start, end);
            }
        });
    }

    public long removeRangeByRank(final long start, final long end) {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.zremrangeByRank(JedisSortedSet.this.getKey(), start, end);
            }
        });
    }

    public long countByLex(final LexRange lexRange) {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.zlexcount(JedisSortedSet.this.getKey(), lexRange.from(), lexRange.to());
            }
        });
    }

    public Set<String> rangeByLex(final LexRange lexRange) {
        return this.doWithJedis(new JedisCallable<Set<String>>(){

            @Override
            public Set<String> call(Jedis jedis) {
                if (lexRange.hasLimit()) {
                    return jedis.zrangeByLex(JedisSortedSet.this.getKey(), lexRange.from(), lexRange.to(), lexRange.offset(), lexRange.count());
                }
                return jedis.zrangeByLex(JedisSortedSet.this.getKey(), lexRange.from(), lexRange.to());
            }
        });
    }

    public Set<String> rangeByLexReverse(final LexRange lexRange) {
        return this.doWithJedis(new JedisCallable<Set<String>>(){

            @Override
            public Set<String> call(Jedis jedis) {
                if (lexRange.hasLimit()) {
                    return jedis.zrevrangeByLex(JedisSortedSet.this.getKey(), lexRange.fromReverse(), lexRange.toReverse(), lexRange.offset(), lexRange.count());
                }
                return jedis.zrevrangeByLex(JedisSortedSet.this.getKey(), lexRange.fromReverse(), lexRange.toReverse());
            }
        });
    }

    public long removeRangeByLex(final LexRange lexRange) {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.zremrangeByLex(JedisSortedSet.this.getKey(), lexRange.from(), lexRange.to());
            }
        });
    }

    public Set<String> rangeByScore(final ScoreRange scoreRange) {
        return this.doWithJedis(new JedisCallable<Set<String>>(){

            @Override
            public Set<String> call(Jedis jedis) {
                if (scoreRange.hasLimit()) {
                    return jedis.zrangeByScore(JedisSortedSet.this.getKey(), scoreRange.from(), scoreRange.to(), scoreRange.offset(), scoreRange.count());
                }
                return jedis.zrangeByScore(JedisSortedSet.this.getKey(), scoreRange.from(), scoreRange.to());
            }
        });
    }

    public Set<String> rangeByScoreReverse(final ScoreRange scoreRange) {
        return this.doWithJedis(new JedisCallable<Set<String>>(){

            @Override
            public Set<String> call(Jedis jedis) {
                if (scoreRange.hasLimit()) {
                    return jedis.zrevrangeByScore(JedisSortedSet.this.getKey(), scoreRange.fromReverse(), scoreRange.toReverse(), scoreRange.offset(), scoreRange.count());
                }
                return jedis.zrevrangeByScore(JedisSortedSet.this.getKey(), scoreRange.fromReverse(), scoreRange.toReverse());
            }
        });
    }

    public long removeRangeByScore(final ScoreRange scoreRange) {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.zremrangeByScore(JedisSortedSet.this.getKey(), scoreRange.from(), scoreRange.to());
            }
        });
    }

    public static interface ScoreProvider {
        public double getScore(String var1);
    }
}

