/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.utils.lua;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.yatech.jedis.utils.lua.AbstractLuaScriptBuilder;
import org.yatech.jedis.utils.lua.BasicLuaPreparedScript;
import org.yatech.jedis.utils.lua.BasicLuaScript;
import org.yatech.jedis.utils.lua.LuaKeyArgument;
import org.yatech.jedis.utils.lua.LuaPreparedScript;
import org.yatech.jedis.utils.lua.LuaScript;
import org.yatech.jedis.utils.lua.LuaScriptBlockBuilder;
import org.yatech.jedis.utils.lua.LuaScriptConfig;
import org.yatech.jedis.utils.lua.LuaScriptVisitor;
import org.yatech.jedis.utils.lua.LuaValue;
import org.yatech.jedis.utils.lua.LuaValueArgument;
import org.yatech.jedis.utils.lua.ThreadSafeLuaPreparedScript;
import org.yatech.jedis.utils.lua.ast.LuaAstArg;
import org.yatech.jedis.utils.lua.ast.LuaAstReturnStatement;
import org.yatech.jedis.utils.lua.ast.LuaAstStatement;

public class LuaScriptBuilder
extends AbstractLuaScriptBuilder<LuaScriptBuilder> {
    private int localIndex = 0;
    private int keysIndex = 1;
    private int argvIndex = 1;
    private final LinkedHashMap<LuaValueArgument, LuaAstArg> valueArg2AstArg = new LinkedHashMap();
    private final LinkedHashMap<LuaKeyArgument, LuaAstArg> keyArg2AstArg = new LinkedHashMap();

    private LuaScriptBuilder() {
    }

    @Override
    String getNextLocalName() {
        return "local" + this.localIndex++;
    }

    @Override
    LuaAstArg getOrCreateArgvArgument(LuaValueArgument<?> valueArgument) {
        LuaAstArg astArg = this.valueArg2AstArg.get(valueArgument);
        if (astArg == null) {
            astArg = new LuaAstArg(this.getNextArgvName());
            this.valueArg2AstArg.put(valueArgument, astArg);
        }
        return astArg;
    }

    @Override
    LuaAstArg getOrCreateKeyArgument(LuaKeyArgument keyArgument) {
        LuaAstArg astArg = this.keyArg2AstArg.get(keyArgument);
        if (astArg == null) {
            astArg = new LuaAstArg(this.getNextKeysName());
            this.keyArg2AstArg.put(keyArgument, astArg);
        }
        return astArg;
    }

    private String getNextKeysName() {
        return "KEYS[" + this.keysIndex++ + "]";
    }

    private String getNextArgvName() {
        return "ARGV[" + this.argvIndex++ + "]";
    }

    public static LuaScriptBuilder startScript() {
        return new LuaScriptBuilder();
    }

    public LuaScript endScript(LuaScriptConfig config) {
        if (!this.endsWithReturnStatement()) {
            this.add(new LuaAstReturnStatement());
        }
        String scriptText = this.buildScriptText();
        return new BasicLuaScript(scriptText, config);
    }

    public LuaScript endScript() {
        return this.endScript(LuaScriptConfig.DEFAULT);
    }

    public LuaScript endScriptReturn(LuaValue value, LuaScriptConfig config) {
        this.add(new LuaAstReturnStatement(this.argument(value)));
        String scriptText = this.buildScriptText();
        return new BasicLuaScript(scriptText, config);
    }

    public LuaScript endScriptReturn(LuaValue value) {
        return this.endScriptReturn(value, LuaScriptConfig.DEFAULT);
    }

    private boolean endsWithReturnStatement() {
        List<LuaAstStatement> statements = this.script.getStatements();
        return !statements.isEmpty() && statements.get(statements.size() - 1) instanceof LuaAstReturnStatement;
    }

    public LuaPreparedScript endPreparedScript(LuaScriptConfig config) {
        if (!this.endsWithReturnStatement()) {
            this.add(new LuaAstReturnStatement());
        }
        String scriptText = this.buildScriptText();
        ArrayList<LuaKeyArgument> keyList = new ArrayList<LuaKeyArgument>(this.keyArg2AstArg.keySet());
        ArrayList<LuaValueArgument> argvList = new ArrayList<LuaValueArgument>(this.valueArg2AstArg.keySet());
        if (config.isThreadSafe()) {
            return new ThreadSafeLuaPreparedScript(scriptText, keyList, argvList, config);
        }
        return new BasicLuaPreparedScript(scriptText, keyList, argvList, config);
    }

    public LuaPreparedScript endPreparedScript() {
        return this.endPreparedScript(LuaScriptConfig.DEFAULT);
    }

    public LuaPreparedScript endPreparedScriptReturn(LuaValue value, LuaScriptConfig config) {
        this.add(new LuaAstReturnStatement(this.argument(value)));
        return this.endPreparedScript(config);
    }

    public LuaPreparedScript endPreparedScriptReturn(LuaValue value) {
        return this.endPreparedScriptReturn(value, LuaScriptConfig.DEFAULT);
    }

    public static LuaScriptBlockBuilder startBlock(LuaScriptBuilder parentBuilder) {
        return LuaScriptBlockBuilder.startBlock(parentBuilder);
    }

    private String buildScriptText() {
        LuaScriptVisitor scriptVisitor = new LuaScriptVisitor();
        this.script.accept(scriptVisitor);
        return scriptVisitor.toString();
    }
}

