/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.utils.lua;

public final class LuaScriptConfig {
    public static final LuaScriptConfig DEFAULT = LuaScriptConfig.newConfig().build();
    private final boolean useScriptCaching;
    private final boolean threadSafe;

    private LuaScriptConfig(boolean useScriptCaching, boolean threadSafe) {
        this.useScriptCaching = useScriptCaching;
        this.threadSafe = threadSafe;
    }

    public boolean isUseScriptCaching() {
        return this.useScriptCaching;
    }

    public boolean isThreadSafe() {
        return this.threadSafe;
    }

    public static LuaScriptConfigBuilder newConfig() {
        return new LuaScriptConfigBuilder();
    }

    public static class LuaScriptConfigBuilder {
        private boolean useScriptCaching = true;
        private boolean threadSafe = false;

        private LuaScriptConfigBuilder() {
        }

        public LuaScriptConfigBuilder useScriptCaching(boolean use) {
            this.useScriptCaching = use;
            return this;
        }

        public LuaScriptConfigBuilder threadSafe(boolean safe) {
            this.threadSafe = safe;
            return this;
        }

        public LuaScriptConfig build() {
            return new LuaScriptConfig(this.useScriptCaching, this.threadSafe);
        }
    }
}

