/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.utils.lua.ast;

import java.util.Arrays;
import java.util.List;
import org.yatech.jedis.utils.lua.ast.LuaAstAssignmentStatement;
import org.yatech.jedis.utils.lua.ast.LuaAstDoubleValue;
import org.yatech.jedis.utils.lua.ast.LuaAstExpression;
import org.yatech.jedis.utils.lua.ast.LuaAstFunctionCallStatement;
import org.yatech.jedis.utils.lua.ast.LuaAstIntValue;
import org.yatech.jedis.utils.lua.ast.LuaAstLocal;
import org.yatech.jedis.utils.lua.ast.LuaAstLocalDeclaration;
import org.yatech.jedis.utils.lua.ast.LuaAstLongValue;
import org.yatech.jedis.utils.lua.ast.LuaAstRedisCall;
import org.yatech.jedis.utils.lua.ast.LuaAstStringValue;
import org.yatech.jedis.utils.lua.ast.LuaAstUnpack;

public class LuaAstHelper {
    private LuaAstHelper() {
    }

    public static LuaAstFunctionCallStatement redisCallStatement(String methodName, List<LuaAstExpression> arguments) {
        return new LuaAstFunctionCallStatement(LuaAstHelper.redisCall(methodName, arguments));
    }

    public static LuaAstRedisCall redisCall(String methodName, List<LuaAstExpression> arguments) {
        return new LuaAstRedisCall(methodName, arguments);
    }

    public static List<LuaAstExpression> arguments(LuaAstExpression ... args) {
        return Arrays.asList(args);
    }

    public static LuaAstAssignmentStatement assignment(LuaAstLocalDeclaration local, LuaAstExpression expression) {
        return new LuaAstAssignmentStatement(local, expression);
    }

    public static LuaAstAssignmentStatement assignment(LuaAstLocal local, LuaAstExpression expression) {
        return new LuaAstAssignmentStatement(local, expression);
    }

    public static LuaAstStringValue stringValue(String value) {
        return new LuaAstStringValue(value);
    }

    public static LuaAstIntValue intValue(int value) {
        return new LuaAstIntValue(value);
    }

    public static LuaAstLongValue longValue(long value) {
        return new LuaAstLongValue(value);
    }

    public static LuaAstDoubleValue doubleValue(double value) {
        return new LuaAstDoubleValue(value);
    }

    public static LuaAstLocalDeclaration declareLocal(String name) {
        return new LuaAstLocalDeclaration(name);
    }

    public static LuaAstUnpack unpack(LuaAstLocal local) {
        return new LuaAstUnpack(local);
    }

    public static LuaAstLocal local(String localName) {
        return new LuaAstLocal(localName);
    }
}

