/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.DiscoveryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationInfo> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ApplicationInfo.getter(ApplicationInfo::accountId)).setter(ApplicationInfo.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(ApplicationInfo.getter(ApplicationInfo::resourceGroupName)).setter(ApplicationInfo.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<String> LIFE_CYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LifeCycle").getter(ApplicationInfo.getter(ApplicationInfo::lifeCycle)).setter(ApplicationInfo.setter(Builder::lifeCycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycle").build()}).build();
    private static final SdkField<String> OPS_ITEM_SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemSNSTopicArn").getter(ApplicationInfo.getter(ApplicationInfo::opsItemSNSTopicArn)).setter(ApplicationInfo.setter(Builder::opsItemSNSTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemSNSTopicArn").build()}).build();
    private static final SdkField<String> SNS_NOTIFICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SNSNotificationArn").getter(ApplicationInfo.getter(ApplicationInfo::snsNotificationArn)).setter(ApplicationInfo.setter(Builder::snsNotificationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSNotificationArn").build()}).build();
    private static final SdkField<Boolean> OPS_CENTER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OpsCenterEnabled").getter(ApplicationInfo.getter(ApplicationInfo::opsCenterEnabled)).setter(ApplicationInfo.setter(Builder::opsCenterEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsCenterEnabled").build()}).build();
    private static final SdkField<Boolean> CWE_MONITOR_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CWEMonitorEnabled").getter(ApplicationInfo.getter(ApplicationInfo::cweMonitorEnabled)).setter(ApplicationInfo.setter(Builder::cweMonitorEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CWEMonitorEnabled").build()}).build();
    private static final SdkField<String> REMARKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Remarks").getter(ApplicationInfo.getter(ApplicationInfo::remarks)).setter(ApplicationInfo.setter(Builder::remarks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remarks").build()}).build();
    private static final SdkField<Boolean> AUTO_CONFIG_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoConfigEnabled").getter(ApplicationInfo.getter(ApplicationInfo::autoConfigEnabled)).setter(ApplicationInfo.setter(Builder::autoConfigEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoConfigEnabled").build()}).build();
    private static final SdkField<String> DISCOVERY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryType").getter(ApplicationInfo.getter(ApplicationInfo::discoveryTypeAsString)).setter(ApplicationInfo.setter(Builder::discoveryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryType").build()}).build();
    private static final SdkField<Boolean> ATTACH_MISSING_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AttachMissingPermission").getter(ApplicationInfo.getter(ApplicationInfo::attachMissingPermission)).setter(ApplicationInfo.setter(Builder::attachMissingPermission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachMissingPermission").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, RESOURCE_GROUP_NAME_FIELD, LIFE_CYCLE_FIELD, OPS_ITEM_SNS_TOPIC_ARN_FIELD, SNS_NOTIFICATION_ARN_FIELD, OPS_CENTER_ENABLED_FIELD, CWE_MONITOR_ENABLED_FIELD, REMARKS_FIELD, AUTO_CONFIG_ENABLED_FIELD, DISCOVERY_TYPE_FIELD, ATTACH_MISSING_PERMISSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountId", ACCOUNT_ID_FIELD);
            this.put("ResourceGroupName", RESOURCE_GROUP_NAME_FIELD);
            this.put("LifeCycle", LIFE_CYCLE_FIELD);
            this.put("OpsItemSNSTopicArn", OPS_ITEM_SNS_TOPIC_ARN_FIELD);
            this.put("SNSNotificationArn", SNS_NOTIFICATION_ARN_FIELD);
            this.put("OpsCenterEnabled", OPS_CENTER_ENABLED_FIELD);
            this.put("CWEMonitorEnabled", CWE_MONITOR_ENABLED_FIELD);
            this.put("Remarks", REMARKS_FIELD);
            this.put("AutoConfigEnabled", AUTO_CONFIG_ENABLED_FIELD);
            this.put("DiscoveryType", DISCOVERY_TYPE_FIELD);
            this.put("AttachMissingPermission", ATTACH_MISSING_PERMISSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String resourceGroupName;
    private final String lifeCycle;
    private final String opsItemSNSTopicArn;
    private final String snsNotificationArn;
    private final Boolean opsCenterEnabled;
    private final Boolean cweMonitorEnabled;
    private final String remarks;
    private final Boolean autoConfigEnabled;
    private final String discoveryType;
    private final Boolean attachMissingPermission;

    private ApplicationInfo(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.resourceGroupName = builder.resourceGroupName;
        this.lifeCycle = builder.lifeCycle;
        this.opsItemSNSTopicArn = builder.opsItemSNSTopicArn;
        this.snsNotificationArn = builder.snsNotificationArn;
        this.opsCenterEnabled = builder.opsCenterEnabled;
        this.cweMonitorEnabled = builder.cweMonitorEnabled;
        this.remarks = builder.remarks;
        this.autoConfigEnabled = builder.autoConfigEnabled;
        this.discoveryType = builder.discoveryType;
        this.attachMissingPermission = builder.attachMissingPermission;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final String lifeCycle() {
        return this.lifeCycle;
    }

    public final String opsItemSNSTopicArn() {
        return this.opsItemSNSTopicArn;
    }

    public final String snsNotificationArn() {
        return this.snsNotificationArn;
    }

    public final Boolean opsCenterEnabled() {
        return this.opsCenterEnabled;
    }

    public final Boolean cweMonitorEnabled() {
        return this.cweMonitorEnabled;
    }

    public final String remarks() {
        return this.remarks;
    }

    public final Boolean autoConfigEnabled() {
        return this.autoConfigEnabled;
    }

    public final DiscoveryType discoveryType() {
        return DiscoveryType.fromValue(this.discoveryType);
    }

    public final String discoveryTypeAsString() {
        return this.discoveryType;
    }

    public final Boolean attachMissingPermission() {
        return this.attachMissingPermission;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemSNSTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsNotificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsCenterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cweMonitorEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.remarks());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoConfigEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachMissingPermission());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationInfo)) {
            return false;
        }
        ApplicationInfo other = (ApplicationInfo)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.lifeCycle(), other.lifeCycle()) && Objects.equals(this.opsItemSNSTopicArn(), other.opsItemSNSTopicArn()) && Objects.equals(this.snsNotificationArn(), other.snsNotificationArn()) && Objects.equals(this.opsCenterEnabled(), other.opsCenterEnabled()) && Objects.equals(this.cweMonitorEnabled(), other.cweMonitorEnabled()) && Objects.equals(this.remarks(), other.remarks()) && Objects.equals(this.autoConfigEnabled(), other.autoConfigEnabled()) && Objects.equals(this.discoveryTypeAsString(), other.discoveryTypeAsString()) && Objects.equals(this.attachMissingPermission(), other.attachMissingPermission());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationInfo").add("AccountId", (Object)this.accountId()).add("ResourceGroupName", (Object)this.resourceGroupName()).add("LifeCycle", (Object)this.lifeCycle()).add("OpsItemSNSTopicArn", (Object)this.opsItemSNSTopicArn()).add("SNSNotificationArn", (Object)this.snsNotificationArn()).add("OpsCenterEnabled", (Object)this.opsCenterEnabled()).add("CWEMonitorEnabled", (Object)this.cweMonitorEnabled()).add("Remarks", (Object)this.remarks()).add("AutoConfigEnabled", (Object)this.autoConfigEnabled()).add("DiscoveryType", (Object)this.discoveryTypeAsString()).add("AttachMissingPermission", (Object)this.attachMissingPermission()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "LifeCycle": {
                return Optional.ofNullable(clazz.cast(this.lifeCycle()));
            }
            case "OpsItemSNSTopicArn": {
                return Optional.ofNullable(clazz.cast(this.opsItemSNSTopicArn()));
            }
            case "SNSNotificationArn": {
                return Optional.ofNullable(clazz.cast(this.snsNotificationArn()));
            }
            case "OpsCenterEnabled": {
                return Optional.ofNullable(clazz.cast(this.opsCenterEnabled()));
            }
            case "CWEMonitorEnabled": {
                return Optional.ofNullable(clazz.cast(this.cweMonitorEnabled()));
            }
            case "Remarks": {
                return Optional.ofNullable(clazz.cast(this.remarks()));
            }
            case "AutoConfigEnabled": {
                return Optional.ofNullable(clazz.cast(this.autoConfigEnabled()));
            }
            case "DiscoveryType": {
                return Optional.ofNullable(clazz.cast(this.discoveryTypeAsString()));
            }
            case "AttachMissingPermission": {
                return Optional.ofNullable(clazz.cast(this.attachMissingPermission()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationInfo, T> g) {
        return obj -> g.apply((ApplicationInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String resourceGroupName;
        private String lifeCycle;
        private String opsItemSNSTopicArn;
        private String snsNotificationArn;
        private Boolean opsCenterEnabled;
        private Boolean cweMonitorEnabled;
        private String remarks;
        private Boolean autoConfigEnabled;
        private String discoveryType;
        private Boolean attachMissingPermission;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationInfo model) {
            this.accountId(model.accountId);
            this.resourceGroupName(model.resourceGroupName);
            this.lifeCycle(model.lifeCycle);
            this.opsItemSNSTopicArn(model.opsItemSNSTopicArn);
            this.snsNotificationArn(model.snsNotificationArn);
            this.opsCenterEnabled(model.opsCenterEnabled);
            this.cweMonitorEnabled(model.cweMonitorEnabled);
            this.remarks(model.remarks);
            this.autoConfigEnabled(model.autoConfigEnabled);
            this.discoveryType(model.discoveryType);
            this.attachMissingPermission(model.attachMissingPermission);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getLifeCycle() {
            return this.lifeCycle;
        }

        public final void setLifeCycle(String lifeCycle) {
            this.lifeCycle = lifeCycle;
        }

        @Override
        public final Builder lifeCycle(String lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final String getOpsItemSNSTopicArn() {
            return this.opsItemSNSTopicArn;
        }

        public final void setOpsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
        }

        @Override
        public final Builder opsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
            return this;
        }

        public final String getSnsNotificationArn() {
            return this.snsNotificationArn;
        }

        public final void setSnsNotificationArn(String snsNotificationArn) {
            this.snsNotificationArn = snsNotificationArn;
        }

        @Override
        public final Builder snsNotificationArn(String snsNotificationArn) {
            this.snsNotificationArn = snsNotificationArn;
            return this;
        }

        public final Boolean getOpsCenterEnabled() {
            return this.opsCenterEnabled;
        }

        public final void setOpsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
        }

        @Override
        public final Builder opsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
            return this;
        }

        public final Boolean getCweMonitorEnabled() {
            return this.cweMonitorEnabled;
        }

        public final void setCweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
        }

        @Override
        public final Builder cweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
            return this;
        }

        public final String getRemarks() {
            return this.remarks;
        }

        public final void setRemarks(String remarks) {
            this.remarks = remarks;
        }

        @Override
        public final Builder remarks(String remarks) {
            this.remarks = remarks;
            return this;
        }

        public final Boolean getAutoConfigEnabled() {
            return this.autoConfigEnabled;
        }

        public final void setAutoConfigEnabled(Boolean autoConfigEnabled) {
            this.autoConfigEnabled = autoConfigEnabled;
        }

        @Override
        public final Builder autoConfigEnabled(Boolean autoConfigEnabled) {
            this.autoConfigEnabled = autoConfigEnabled;
            return this;
        }

        public final String getDiscoveryType() {
            return this.discoveryType;
        }

        public final void setDiscoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
        }

        @Override
        public final Builder discoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
            return this;
        }

        @Override
        public final Builder discoveryType(DiscoveryType discoveryType) {
            this.discoveryType(discoveryType == null ? null : discoveryType.toString());
            return this;
        }

        public final Boolean getAttachMissingPermission() {
            return this.attachMissingPermission;
        }

        public final void setAttachMissingPermission(Boolean attachMissingPermission) {
            this.attachMissingPermission = attachMissingPermission;
        }

        @Override
        public final Builder attachMissingPermission(Boolean attachMissingPermission) {
            this.attachMissingPermission = attachMissingPermission;
            return this;
        }

        public ApplicationInfo build() {
            return new ApplicationInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationInfo> {
        public Builder accountId(String var1);

        public Builder resourceGroupName(String var1);

        public Builder lifeCycle(String var1);

        public Builder opsItemSNSTopicArn(String var1);

        public Builder snsNotificationArn(String var1);

        public Builder opsCenterEnabled(Boolean var1);

        public Builder cweMonitorEnabled(Boolean var1);

        public Builder remarks(String var1);

        public Builder autoConfigEnabled(Boolean var1);

        public Builder discoveryType(String var1);

        public Builder discoveryType(DiscoveryType var1);

        public Builder attachMissingPermission(Boolean var1);
    }
}

