/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationComponent;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationComponentListCopier;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComponentsResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, ListComponentsResponse> {
    private static final SdkField<List<ApplicationComponent>> APPLICATION_COMPONENT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationComponentList").getter(ListComponentsResponse.getter(ListComponentsResponse::applicationComponentList)).setter(ListComponentsResponse.setter(Builder::applicationComponentList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationComponentList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListComponentsResponse.getter(ListComponentsResponse::nextToken)).setter(ListComponentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_COMPONENT_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApplicationComponentList", APPLICATION_COMPONENT_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ApplicationComponent> applicationComponentList;
    private final String nextToken;

    private ListComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationComponentList = builder.applicationComponentList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApplicationComponentList() {
        return this.applicationComponentList != null && !(this.applicationComponentList instanceof SdkAutoConstructList);
    }

    public final List<ApplicationComponent> applicationComponentList() {
        return this.applicationComponentList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationComponentList() ? this.applicationComponentList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentsResponse)) {
            return false;
        }
        ListComponentsResponse other = (ListComponentsResponse)((Object)obj);
        return this.hasApplicationComponentList() == other.hasApplicationComponentList() && Objects.equals(this.applicationComponentList(), other.applicationComponentList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListComponentsResponse").add("ApplicationComponentList", this.hasApplicationComponentList() ? this.applicationComponentList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationComponentList": {
                return Optional.ofNullable(clazz.cast(this.applicationComponentList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListComponentsResponse, T> g) {
        return obj -> g.apply((ListComponentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private List<ApplicationComponent> applicationComponentList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentsResponse model) {
            super(model);
            this.applicationComponentList(model.applicationComponentList);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationComponent.Builder> getApplicationComponentList() {
            List<ApplicationComponent.Builder> result = ApplicationComponentListCopier.copyToBuilder(this.applicationComponentList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationComponentList(Collection<ApplicationComponent.BuilderImpl> applicationComponentList) {
            this.applicationComponentList = ApplicationComponentListCopier.copyFromBuilder(applicationComponentList);
        }

        @Override
        public final Builder applicationComponentList(Collection<ApplicationComponent> applicationComponentList) {
            this.applicationComponentList = ApplicationComponentListCopier.copy(applicationComponentList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationComponentList(ApplicationComponent ... applicationComponentList) {
            this.applicationComponentList(Arrays.asList(applicationComponentList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationComponentList(Consumer<ApplicationComponent.Builder> ... applicationComponentList) {
            this.applicationComponentList(Stream.of(applicationComponentList).map(c -> (ApplicationComponent)((ApplicationComponent.Builder)ApplicationComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComponentsResponse build() {
            return new ListComponentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComponentsResponse> {
        public Builder applicationComponentList(Collection<ApplicationComponent> var1);

        public Builder applicationComponentList(ApplicationComponent ... var1);

        public Builder applicationComponentList(Consumer<ApplicationComponent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

