/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The baseline performance to consider, using an instance family as a baseline reference. The instance family
 * establishes the lowest acceptable level of performance. Auto Scaling uses this baseline to guide instance type
 * selection, but there is no guarantee that the selected instance types will always exceed the baseline for every
 * application.
 * </p>
 * <p>
 * Currently, this parameter only supports CPU performance as a baseline performance factor. For example, specifying
 * <code>c6i</code> uses the CPU performance of the <code>c6i</code> family as the baseline reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BaselinePerformanceFactorsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<BaselinePerformanceFactorsRequest.Builder, BaselinePerformanceFactorsRequest> {
    private static final SdkField<CpuPerformanceFactorRequest> CPU_FIELD = SdkField
            .<CpuPerformanceFactorRequest> builder(MarshallingType.SDK_POJO).memberName("Cpu")
            .getter(getter(BaselinePerformanceFactorsRequest::cpu)).setter(setter(Builder::cpu))
            .constructor(CpuPerformanceFactorRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cpu").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CpuPerformanceFactorRequest cpu;

    private BaselinePerformanceFactorsRequest(BuilderImpl builder) {
        this.cpu = builder.cpu;
    }

    /**
     * <p>
     * The CPU performance to consider, using an instance family as the baseline reference.
     * </p>
     * 
     * @return The CPU performance to consider, using an instance family as the baseline reference.
     */
    public final CpuPerformanceFactorRequest cpu() {
        return cpu;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaselinePerformanceFactorsRequest)) {
            return false;
        }
        BaselinePerformanceFactorsRequest other = (BaselinePerformanceFactorsRequest) obj;
        return Objects.equals(cpu(), other.cpu());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BaselinePerformanceFactorsRequest").add("Cpu", cpu()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cpu", CPU_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BaselinePerformanceFactorsRequest, T> g) {
        return obj -> g.apply((BaselinePerformanceFactorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BaselinePerformanceFactorsRequest> {
        /**
         * <p>
         * The CPU performance to consider, using an instance family as the baseline reference.
         * </p>
         * 
         * @param cpu
         *        The CPU performance to consider, using an instance family as the baseline reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(CpuPerformanceFactorRequest cpu);

        /**
         * <p>
         * The CPU performance to consider, using an instance family as the baseline reference.
         * </p>
         * This is a convenience method that creates an instance of the {@link CpuPerformanceFactorRequest.Builder}
         * avoiding the need to create one manually via {@link CpuPerformanceFactorRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CpuPerformanceFactorRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #cpu(CpuPerformanceFactorRequest)}.
         * 
         * @param cpu
         *        a consumer that will call methods on {@link CpuPerformanceFactorRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpu(CpuPerformanceFactorRequest)
         */
        default Builder cpu(Consumer<CpuPerformanceFactorRequest.Builder> cpu) {
            return cpu(CpuPerformanceFactorRequest.builder().applyMutation(cpu).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CpuPerformanceFactorRequest cpu;

        private BuilderImpl() {
        }

        private BuilderImpl(BaselinePerformanceFactorsRequest model) {
            cpu(model.cpu);
        }

        public final CpuPerformanceFactorRequest.Builder getCpu() {
            return cpu != null ? cpu.toBuilder() : null;
        }

        public final void setCpu(CpuPerformanceFactorRequest.BuilderImpl cpu) {
            this.cpu = cpu != null ? cpu.build() : null;
        }

        @Override
        public final Builder cpu(CpuPerformanceFactorRequest cpu) {
            this.cpu = cpu;
            return this;
        }

        @Override
        public BaselinePerformanceFactorsRequest build() {
            return new BaselinePerformanceFactorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
