/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponsesTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ClientMetadataTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ContextDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminRespondToAuthChallengeRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AdminRespondToAuthChallengeRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(AdminRespondToAuthChallengeRequest.getter(AdminRespondToAuthChallengeRequest::userPoolId)).setter(AdminRespondToAuthChallengeRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(AdminRespondToAuthChallengeRequest.getter(AdminRespondToAuthChallengeRequest::clientId)).setter(AdminRespondToAuthChallengeRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> CHALLENGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChallengeName").getter(AdminRespondToAuthChallengeRequest.getter(AdminRespondToAuthChallengeRequest::challengeNameAsString)).setter(AdminRespondToAuthChallengeRequest.setter(Builder::challengeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeName").build()}).build();
    private static final SdkField<Map<String, String>> CHALLENGE_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ChallengeResponses").getter(AdminRespondToAuthChallengeRequest.getter(AdminRespondToAuthChallengeRequest::challengeResponses)).setter(AdminRespondToAuthChallengeRequest.setter(Builder::challengeResponses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeResponses").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Session").getter(AdminRespondToAuthChallengeRequest.getter(AdminRespondToAuthChallengeRequest::session)).setter(AdminRespondToAuthChallengeRequest.setter(Builder::session)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()}).build();
    private static final SdkField<AnalyticsMetadataType> ANALYTICS_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnalyticsMetadata").getter(AdminRespondToAuthChallengeRequest.getter(AdminRespondToAuthChallengeRequest::analyticsMetadata)).setter(AdminRespondToAuthChallengeRequest.setter(Builder::analyticsMetadata)).constructor(AnalyticsMetadataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsMetadata").build()}).build();
    private static final SdkField<ContextDataType> CONTEXT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContextData").getter(AdminRespondToAuthChallengeRequest.getter(AdminRespondToAuthChallengeRequest::contextData)).setter(AdminRespondToAuthChallengeRequest.setter(Builder::contextData)).constructor(ContextDataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextData").build()}).build();
    private static final SdkField<Map<String, String>> CLIENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ClientMetadata").getter(AdminRespondToAuthChallengeRequest.getter(AdminRespondToAuthChallengeRequest::clientMetadata)).setter(AdminRespondToAuthChallengeRequest.setter(Builder::clientMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, CLIENT_ID_FIELD, CHALLENGE_NAME_FIELD, CHALLENGE_RESPONSES_FIELD, SESSION_FIELD, ANALYTICS_METADATA_FIELD, CONTEXT_DATA_FIELD, CLIENT_METADATA_FIELD));
    private final String userPoolId;
    private final String clientId;
    private final String challengeName;
    private final Map<String, String> challengeResponses;
    private final String session;
    private final AnalyticsMetadataType analyticsMetadata;
    private final ContextDataType contextData;
    private final Map<String, String> clientMetadata;

    private AdminRespondToAuthChallengeRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.challengeName = builder.challengeName;
        this.challengeResponses = builder.challengeResponses;
        this.session = builder.session;
        this.analyticsMetadata = builder.analyticsMetadata;
        this.contextData = builder.contextData;
        this.clientMetadata = builder.clientMetadata;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final ChallengeNameType challengeName() {
        return ChallengeNameType.fromValue(this.challengeName);
    }

    public final String challengeNameAsString() {
        return this.challengeName;
    }

    public final boolean hasChallengeResponses() {
        return this.challengeResponses != null && !(this.challengeResponses instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> challengeResponses() {
        return this.challengeResponses;
    }

    public final String session() {
        return this.session;
    }

    public final AnalyticsMetadataType analyticsMetadata() {
        return this.analyticsMetadata;
    }

    public final ContextDataType contextData() {
        return this.contextData;
    }

    public final boolean hasClientMetadata() {
        return this.clientMetadata != null && !(this.clientMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> clientMetadata() {
        return this.clientMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChallengeResponses() ? this.challengeResponses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyticsMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientMetadata() ? this.clientMetadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminRespondToAuthChallengeRequest)) {
            return false;
        }
        AdminRespondToAuthChallengeRequest other = (AdminRespondToAuthChallengeRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.challengeNameAsString(), other.challengeNameAsString()) && this.hasChallengeResponses() == other.hasChallengeResponses() && Objects.equals(this.challengeResponses(), other.challengeResponses()) && Objects.equals(this.session(), other.session()) && Objects.equals(this.analyticsMetadata(), other.analyticsMetadata()) && Objects.equals(this.contextData(), other.contextData()) && this.hasClientMetadata() == other.hasClientMetadata() && Objects.equals(this.clientMetadata(), other.clientMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"AdminRespondToAuthChallengeRequest").add("UserPoolId", (Object)this.userPoolId()).add("ClientId", (Object)(this.clientId() == null ? null : "*** Sensitive Data Redacted ***")).add("ChallengeName", (Object)this.challengeNameAsString()).add("ChallengeResponses", this.hasChallengeResponses() ? this.challengeResponses() : null).add("Session", (Object)this.session()).add("AnalyticsMetadata", (Object)this.analyticsMetadata()).add("ContextData", (Object)this.contextData()).add("ClientMetadata", this.hasClientMetadata() ? this.clientMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ChallengeName": {
                return Optional.ofNullable(clazz.cast(this.challengeNameAsString()));
            }
            case "ChallengeResponses": {
                return Optional.ofNullable(clazz.cast(this.challengeResponses()));
            }
            case "Session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
            case "AnalyticsMetadata": {
                return Optional.ofNullable(clazz.cast(this.analyticsMetadata()));
            }
            case "ContextData": {
                return Optional.ofNullable(clazz.cast(this.contextData()));
            }
            case "ClientMetadata": {
                return Optional.ofNullable(clazz.cast(this.clientMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminRespondToAuthChallengeRequest, T> g) {
        return obj -> g.apply((AdminRespondToAuthChallengeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String clientId;
        private String challengeName;
        private Map<String, String> challengeResponses = DefaultSdkAutoConstructMap.getInstance();
        private String session;
        private AnalyticsMetadataType analyticsMetadata;
        private ContextDataType contextData;
        private Map<String, String> clientMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdminRespondToAuthChallengeRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.clientId(model.clientId);
            this.challengeName(model.challengeName);
            this.challengeResponses(model.challengeResponses);
            this.session(model.session);
            this.analyticsMetadata(model.analyticsMetadata);
            this.contextData(model.contextData);
            this.clientMetadata(model.clientMetadata);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getChallengeName() {
            return this.challengeName;
        }

        public final void setChallengeName(String challengeName) {
            this.challengeName = challengeName;
        }

        @Override
        public final Builder challengeName(String challengeName) {
            this.challengeName = challengeName;
            return this;
        }

        @Override
        public final Builder challengeName(ChallengeNameType challengeName) {
            this.challengeName(challengeName == null ? null : challengeName.toString());
            return this;
        }

        public final Map<String, String> getChallengeResponses() {
            if (this.challengeResponses instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.challengeResponses;
        }

        public final void setChallengeResponses(Map<String, String> challengeResponses) {
            this.challengeResponses = ChallengeResponsesTypeCopier.copy(challengeResponses);
        }

        @Override
        public final Builder challengeResponses(Map<String, String> challengeResponses) {
            this.challengeResponses = ChallengeResponsesTypeCopier.copy(challengeResponses);
            return this;
        }

        public final String getSession() {
            return this.session;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        @Override
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        public final AnalyticsMetadataType.Builder getAnalyticsMetadata() {
            return this.analyticsMetadata != null ? this.analyticsMetadata.toBuilder() : null;
        }

        public final void setAnalyticsMetadata(AnalyticsMetadataType.BuilderImpl analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata != null ? analyticsMetadata.build() : null;
        }

        @Override
        public final Builder analyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata;
            return this;
        }

        public final ContextDataType.Builder getContextData() {
            return this.contextData != null ? this.contextData.toBuilder() : null;
        }

        public final void setContextData(ContextDataType.BuilderImpl contextData) {
            this.contextData = contextData != null ? contextData.build() : null;
        }

        @Override
        public final Builder contextData(ContextDataType contextData) {
            this.contextData = contextData;
            return this;
        }

        public final Map<String, String> getClientMetadata() {
            if (this.clientMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.clientMetadata;
        }

        public final void setClientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
        }

        @Override
        public final Builder clientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminRespondToAuthChallengeRequest build() {
            return new AdminRespondToAuthChallengeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AdminRespondToAuthChallengeRequest> {
        public Builder userPoolId(String var1);

        public Builder clientId(String var1);

        public Builder challengeName(String var1);

        public Builder challengeName(ChallengeNameType var1);

        public Builder challengeResponses(Map<String, String> var1);

        public Builder session(String var1);

        public Builder analyticsMetadata(AnalyticsMetadataType var1);

        default public Builder analyticsMetadata(Consumer<AnalyticsMetadataType.Builder> analyticsMetadata) {
            return this.analyticsMetadata((AnalyticsMetadataType)((AnalyticsMetadataType.Builder)AnalyticsMetadataType.builder().applyMutation(analyticsMetadata)).build());
        }

        public Builder contextData(ContextDataType var1);

        default public Builder contextData(Consumer<ContextDataType.Builder> contextData) {
            return this.contextData((ContextDataType)((ContextDataType.Builder)ContextDataType.builder().applyMutation(contextData)).build());
        }

        public Builder clientMetadata(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

