/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationSummary> {
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("group").getter(RecommendationSummary.getter(RecommendationSummary::group)).setter(RecommendationSummary.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<Double> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedMonthlySavings").getter(RecommendationSummary.getter(RecommendationSummary::estimatedMonthlySavings)).setter(RecommendationSummary.setter(Builder::estimatedMonthlySavings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlySavings").build()}).build();
    private static final SdkField<Integer> RECOMMENDATION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("recommendationCount").getter(RecommendationSummary.getter(RecommendationSummary::recommendationCount)).setter(RecommendationSummary.setter(Builder::recommendationCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, ESTIMATED_MONTHLY_SAVINGS_FIELD, RECOMMENDATION_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String group;
    private final Double estimatedMonthlySavings;
    private final Integer recommendationCount;

    private RecommendationSummary(BuilderImpl builder) {
        this.group = builder.group;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
        this.recommendationCount = builder.recommendationCount;
    }

    public final String group() {
        return this.group;
    }

    public final Double estimatedMonthlySavings() {
        return this.estimatedMonthlySavings;
    }

    public final Integer recommendationCount() {
        return this.recommendationCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlySavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSummary)) {
            return false;
        }
        RecommendationSummary other = (RecommendationSummary)obj;
        return Objects.equals(this.group(), other.group()) && Objects.equals(this.estimatedMonthlySavings(), other.estimatedMonthlySavings()) && Objects.equals(this.recommendationCount(), other.recommendationCount());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationSummary").add("Group", (Object)this.group()).add("EstimatedMonthlySavings", (Object)this.estimatedMonthlySavings()).add("RecommendationCount", (Object)this.recommendationCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "estimatedMonthlySavings": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlySavings()));
            }
            case "recommendationCount": {
                return Optional.ofNullable(clazz.cast(this.recommendationCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSummary, T> g) {
        return obj -> g.apply((RecommendationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String group;
        private Double estimatedMonthlySavings;
        private Integer recommendationCount;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSummary model) {
            this.group(model.group);
            this.estimatedMonthlySavings(model.estimatedMonthlySavings);
            this.recommendationCount(model.recommendationCount);
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final Double getEstimatedMonthlySavings() {
            return this.estimatedMonthlySavings;
        }

        public final void setEstimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
        }

        @Override
        public final Builder estimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public final Integer getRecommendationCount() {
            return this.recommendationCount;
        }

        public final void setRecommendationCount(Integer recommendationCount) {
            this.recommendationCount = recommendationCount;
        }

        @Override
        public final Builder recommendationCount(Integer recommendationCount) {
            this.recommendationCount = recommendationCount;
            return this;
        }

        public RecommendationSummary build() {
            return new RecommendationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationSummary> {
        public Builder group(String var1);

        public Builder estimatedMonthlySavings(Double var1);

        public Builder recommendationCount(Integer var1);
    }
}

