/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costoptimizationhub.model.AllocationStrategy;
import software.amazon.awssdk.services.costoptimizationhub.model.Ec2AutoScalingGroupType;
import software.amazon.awssdk.services.costoptimizationhub.model.InstanceConfiguration;
import software.amazon.awssdk.services.costoptimizationhub.model.MixedInstanceConfiguration;
import software.amazon.awssdk.services.costoptimizationhub.model.MixedInstanceConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2AutoScalingGroupConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2AutoScalingGroupConfiguration> {
    private static final SdkField<InstanceConfiguration> INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instance").getter(Ec2AutoScalingGroupConfiguration.getter(Ec2AutoScalingGroupConfiguration::instance)).setter(Ec2AutoScalingGroupConfiguration.setter(Builder::instance)).constructor(InstanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instance").build()}).build();
    private static final SdkField<List<MixedInstanceConfiguration>> MIXED_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mixedInstances").getter(Ec2AutoScalingGroupConfiguration.getter(Ec2AutoScalingGroupConfiguration::mixedInstances)).setter(Ec2AutoScalingGroupConfiguration.setter(Builder::mixedInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mixedInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MixedInstanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Ec2AutoScalingGroupConfiguration.getter(Ec2AutoScalingGroupConfiguration::typeAsString)).setter(Ec2AutoScalingGroupConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("allocationStrategy").getter(Ec2AutoScalingGroupConfiguration.getter(Ec2AutoScalingGroupConfiguration::allocationStrategyAsString)).setter(Ec2AutoScalingGroupConfiguration.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocationStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FIELD, MIXED_INSTANCES_FIELD, TYPE_FIELD, ALLOCATION_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Ec2AutoScalingGroupConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InstanceConfiguration instance;
    private final List<MixedInstanceConfiguration> mixedInstances;
    private final String type;
    private final String allocationStrategy;

    private Ec2AutoScalingGroupConfiguration(BuilderImpl builder) {
        this.instance = builder.instance;
        this.mixedInstances = builder.mixedInstances;
        this.type = builder.type;
        this.allocationStrategy = builder.allocationStrategy;
    }

    public final InstanceConfiguration instance() {
        return this.instance;
    }

    public final boolean hasMixedInstances() {
        return this.mixedInstances != null && !(this.mixedInstances instanceof SdkAutoConstructList);
    }

    public final List<MixedInstanceConfiguration> mixedInstances() {
        return this.mixedInstances;
    }

    public final Ec2AutoScalingGroupType type() {
        return Ec2AutoScalingGroupType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final AllocationStrategy allocationStrategy() {
        return AllocationStrategy.fromValue(this.allocationStrategy);
    }

    public final String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instance());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMixedInstances() ? this.mixedInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2AutoScalingGroupConfiguration)) {
            return false;
        }
        Ec2AutoScalingGroupConfiguration other = (Ec2AutoScalingGroupConfiguration)obj;
        return Objects.equals(this.instance(), other.instance()) && this.hasMixedInstances() == other.hasMixedInstances() && Objects.equals(this.mixedInstances(), other.mixedInstances()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Ec2AutoScalingGroupConfiguration").add("Instance", (Object)this.instance()).add("MixedInstances", this.hasMixedInstances() ? this.mixedInstances() : null).add("Type", (Object)this.typeAsString()).add("AllocationStrategy", (Object)this.allocationStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instance": {
                return Optional.ofNullable(clazz.cast(this.instance()));
            }
            case "mixedInstances": {
                return Optional.ofNullable(clazz.cast(this.mixedInstances()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "allocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instance", INSTANCE_FIELD);
        map.put("mixedInstances", MIXED_INSTANCES_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("allocationStrategy", ALLOCATION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2AutoScalingGroupConfiguration, T> g) {
        return obj -> g.apply((Ec2AutoScalingGroupConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InstanceConfiguration instance;
        private List<MixedInstanceConfiguration> mixedInstances = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private String allocationStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2AutoScalingGroupConfiguration model) {
            this.instance(model.instance);
            this.mixedInstances(model.mixedInstances);
            this.type(model.type);
            this.allocationStrategy(model.allocationStrategy);
        }

        public final InstanceConfiguration.Builder getInstance() {
            return this.instance != null ? this.instance.toBuilder() : null;
        }

        public final void setInstance(InstanceConfiguration.BuilderImpl instance) {
            this.instance = instance != null ? instance.build() : null;
        }

        @Override
        public final Builder instance(InstanceConfiguration instance) {
            this.instance = instance;
            return this;
        }

        public final List<MixedInstanceConfiguration.Builder> getMixedInstances() {
            List<MixedInstanceConfiguration.Builder> result = MixedInstanceConfigurationListCopier.copyToBuilder(this.mixedInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMixedInstances(Collection<MixedInstanceConfiguration.BuilderImpl> mixedInstances) {
            this.mixedInstances = MixedInstanceConfigurationListCopier.copyFromBuilder(mixedInstances);
        }

        @Override
        public final Builder mixedInstances(Collection<MixedInstanceConfiguration> mixedInstances) {
            this.mixedInstances = MixedInstanceConfigurationListCopier.copy(mixedInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mixedInstances(MixedInstanceConfiguration ... mixedInstances) {
            this.mixedInstances(Arrays.asList(mixedInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mixedInstances(Consumer<MixedInstanceConfiguration.Builder> ... mixedInstances) {
            this.mixedInstances(Stream.of(mixedInstances).map(c -> (MixedInstanceConfiguration)((MixedInstanceConfiguration.Builder)MixedInstanceConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Ec2AutoScalingGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(AllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public Ec2AutoScalingGroupConfiguration build() {
            return new Ec2AutoScalingGroupConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2AutoScalingGroupConfiguration> {
        public Builder instance(InstanceConfiguration var1);

        default public Builder instance(Consumer<InstanceConfiguration.Builder> instance) {
            return this.instance((InstanceConfiguration)((InstanceConfiguration.Builder)InstanceConfiguration.builder().applyMutation(instance)).build());
        }

        public Builder mixedInstances(Collection<MixedInstanceConfiguration> var1);

        public Builder mixedInstances(MixedInstanceConfiguration ... var1);

        public Builder mixedInstances(Consumer<MixedInstanceConfiguration.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(Ec2AutoScalingGroupType var1);

        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(AllocationStrategy var1);
    }
}

