/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrserverless.model.LogTypeMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchLoggingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchLoggingConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(CloudWatchLoggingConfiguration.getter(CloudWatchLoggingConfiguration::enabled)).setter(CloudWatchLoggingConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(CloudWatchLoggingConfiguration.getter(CloudWatchLoggingConfiguration::logGroupName)).setter(CloudWatchLoggingConfiguration.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<String> LOG_STREAM_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logStreamNamePrefix").getter(CloudWatchLoggingConfiguration.getter(CloudWatchLoggingConfiguration::logStreamNamePrefix)).setter(CloudWatchLoggingConfiguration.setter(Builder::logStreamNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNamePrefix").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKeyArn").getter(CloudWatchLoggingConfiguration.getter(CloudWatchLoggingConfiguration::encryptionKeyArn)).setter(CloudWatchLoggingConfiguration.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyArn").build()}).build();
    private static final SdkField<Map<String, List<String>>> LOG_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("logTypes").getter(CloudWatchLoggingConfiguration.getter(CloudWatchLoggingConfiguration::logTypes)).setter(CloudWatchLoggingConfiguration.setter(Builder::logTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logTypes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, LOG_GROUP_NAME_FIELD, LOG_STREAM_NAME_PREFIX_FIELD, ENCRYPTION_KEY_ARN_FIELD, LOG_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudWatchLoggingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String logGroupName;
    private final String logStreamNamePrefix;
    private final String encryptionKeyArn;
    private final Map<String, List<String>> logTypes;

    private CloudWatchLoggingConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.logGroupName = builder.logGroupName;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.logTypes = builder.logTypes;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final String logStreamNamePrefix() {
        return this.logStreamNamePrefix;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final boolean hasLogTypes() {
        return this.logTypes != null && !(this.logTypes instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> logTypes() {
        return this.logTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogTypes() ? this.logTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingConfiguration)) {
            return false;
        }
        CloudWatchLoggingConfiguration other = (CloudWatchLoggingConfiguration)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.logStreamNamePrefix(), other.logStreamNamePrefix()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && this.hasLogTypes() == other.hasLogTypes() && Objects.equals(this.logTypes(), other.logTypes());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchLoggingConfiguration").add("Enabled", (Object)this.enabled()).add("LogGroupName", (Object)this.logGroupName()).add("LogStreamNamePrefix", (Object)this.logStreamNamePrefix()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("LogTypes", this.hasLogTypes() ? this.logTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "logStreamNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.logStreamNamePrefix()));
            }
            case "encryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "logTypes": {
                return Optional.ofNullable(clazz.cast(this.logTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", ENABLED_FIELD);
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("logStreamNamePrefix", LOG_STREAM_NAME_PREFIX_FIELD);
        map.put("encryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("logTypes", LOG_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLoggingConfiguration, T> g) {
        return obj -> g.apply((CloudWatchLoggingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String logGroupName;
        private String logStreamNamePrefix;
        private String encryptionKeyArn;
        private Map<String, List<String>> logTypes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingConfiguration model) {
            this.enabled(model.enabled);
            this.logGroupName(model.logGroupName);
            this.logStreamNamePrefix(model.logStreamNamePrefix);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.logTypes(model.logTypes);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getLogStreamNamePrefix() {
            return this.logStreamNamePrefix;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getLogTypes() {
            if (this.logTypes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.logTypes;
        }

        public final void setLogTypes(Map<String, ? extends Collection<String>> logTypes) {
            this.logTypes = LogTypeMapCopier.copy(logTypes);
        }

        @Override
        public final Builder logTypes(Map<String, ? extends Collection<String>> logTypes) {
            this.logTypes = LogTypeMapCopier.copy(logTypes);
            return this;
        }

        public CloudWatchLoggingConfiguration build() {
            return new CloudWatchLoggingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchLoggingConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder logGroupName(String var1);

        public Builder logStreamNamePrefix(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder logTypes(Map<String, ? extends Collection<String>> var1);
    }
}

