/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.healthlake.HealthLakeAsyncClient;
import software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse;

public class ListFHIRDatastoresPublisher
implements SdkPublisher<ListFhirDatastoresResponse> {
    private final HealthLakeAsyncClient client;
    private final ListFhirDatastoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFHIRDatastoresPublisher(HealthLakeAsyncClient client, ListFhirDatastoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFHIRDatastoresPublisher(HealthLakeAsyncClient client, ListFhirDatastoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFhirDatastoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFhirDatastoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFhirDatastoresResponseFetcher
    implements AsyncPageFetcher<ListFhirDatastoresResponse> {
        private ListFhirDatastoresResponseFetcher() {
        }

        public boolean hasNextPage(ListFhirDatastoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFhirDatastoresResponse> nextPage(ListFhirDatastoresResponse previousPage) {
            if (previousPage == null) {
                return ListFHIRDatastoresPublisher.this.client.listFHIRDatastores(ListFHIRDatastoresPublisher.this.firstRequest);
            }
            return ListFHIRDatastoresPublisher.this.client.listFHIRDatastores((ListFhirDatastoresRequest)((Object)ListFHIRDatastoresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

