/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobProgressReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobProgressReport> {
    private static final SdkField<Long> TOTAL_NUMBER_OF_SCANNED_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalNumberOfScannedFiles").getter(JobProgressReport.getter(JobProgressReport::totalNumberOfScannedFiles)).setter(JobProgressReport.setter(Builder::totalNumberOfScannedFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfScannedFiles").build()}).build();
    private static final SdkField<Double> TOTAL_SIZE_OF_SCANNED_FILES_IN_MB_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalSizeOfScannedFilesInMB").getter(JobProgressReport.getter(JobProgressReport::totalSizeOfScannedFilesInMB)).setter(JobProgressReport.setter(Builder::totalSizeOfScannedFilesInMB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSizeOfScannedFilesInMB").build()}).build();
    private static final SdkField<Long> TOTAL_NUMBER_OF_IMPORTED_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalNumberOfImportedFiles").getter(JobProgressReport.getter(JobProgressReport::totalNumberOfImportedFiles)).setter(JobProgressReport.setter(Builder::totalNumberOfImportedFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfImportedFiles").build()}).build();
    private static final SdkField<Long> TOTAL_NUMBER_OF_RESOURCES_SCANNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalNumberOfResourcesScanned").getter(JobProgressReport.getter(JobProgressReport::totalNumberOfResourcesScanned)).setter(JobProgressReport.setter(Builder::totalNumberOfResourcesScanned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfResourcesScanned").build()}).build();
    private static final SdkField<Long> TOTAL_NUMBER_OF_RESOURCES_IMPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalNumberOfResourcesImported").getter(JobProgressReport.getter(JobProgressReport::totalNumberOfResourcesImported)).setter(JobProgressReport.setter(Builder::totalNumberOfResourcesImported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfResourcesImported").build()}).build();
    private static final SdkField<Long> TOTAL_NUMBER_OF_RESOURCES_WITH_CUSTOMER_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalNumberOfResourcesWithCustomerError").getter(JobProgressReport.getter(JobProgressReport::totalNumberOfResourcesWithCustomerError)).setter(JobProgressReport.setter(Builder::totalNumberOfResourcesWithCustomerError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfResourcesWithCustomerError").build()}).build();
    private static final SdkField<Long> TOTAL_NUMBER_OF_FILES_READ_WITH_CUSTOMER_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalNumberOfFilesReadWithCustomerError").getter(JobProgressReport.getter(JobProgressReport::totalNumberOfFilesReadWithCustomerError)).setter(JobProgressReport.setter(Builder::totalNumberOfFilesReadWithCustomerError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfFilesReadWithCustomerError").build()}).build();
    private static final SdkField<Double> THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Throughput").getter(JobProgressReport.getter(JobProgressReport::throughput)).setter(JobProgressReport.setter(Builder::throughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_NUMBER_OF_SCANNED_FILES_FIELD, TOTAL_SIZE_OF_SCANNED_FILES_IN_MB_FIELD, TOTAL_NUMBER_OF_IMPORTED_FILES_FIELD, TOTAL_NUMBER_OF_RESOURCES_SCANNED_FIELD, TOTAL_NUMBER_OF_RESOURCES_IMPORTED_FIELD, TOTAL_NUMBER_OF_RESOURCES_WITH_CUSTOMER_ERROR_FIELD, TOTAL_NUMBER_OF_FILES_READ_WITH_CUSTOMER_ERROR_FIELD, THROUGHPUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long totalNumberOfScannedFiles;
    private final Double totalSizeOfScannedFilesInMB;
    private final Long totalNumberOfImportedFiles;
    private final Long totalNumberOfResourcesScanned;
    private final Long totalNumberOfResourcesImported;
    private final Long totalNumberOfResourcesWithCustomerError;
    private final Long totalNumberOfFilesReadWithCustomerError;
    private final Double throughput;

    private JobProgressReport(BuilderImpl builder) {
        this.totalNumberOfScannedFiles = builder.totalNumberOfScannedFiles;
        this.totalSizeOfScannedFilesInMB = builder.totalSizeOfScannedFilesInMB;
        this.totalNumberOfImportedFiles = builder.totalNumberOfImportedFiles;
        this.totalNumberOfResourcesScanned = builder.totalNumberOfResourcesScanned;
        this.totalNumberOfResourcesImported = builder.totalNumberOfResourcesImported;
        this.totalNumberOfResourcesWithCustomerError = builder.totalNumberOfResourcesWithCustomerError;
        this.totalNumberOfFilesReadWithCustomerError = builder.totalNumberOfFilesReadWithCustomerError;
        this.throughput = builder.throughput;
    }

    public final Long totalNumberOfScannedFiles() {
        return this.totalNumberOfScannedFiles;
    }

    public final Double totalSizeOfScannedFilesInMB() {
        return this.totalSizeOfScannedFilesInMB;
    }

    public final Long totalNumberOfImportedFiles() {
        return this.totalNumberOfImportedFiles;
    }

    public final Long totalNumberOfResourcesScanned() {
        return this.totalNumberOfResourcesScanned;
    }

    public final Long totalNumberOfResourcesImported() {
        return this.totalNumberOfResourcesImported;
    }

    public final Long totalNumberOfResourcesWithCustomerError() {
        return this.totalNumberOfResourcesWithCustomerError;
    }

    public final Long totalNumberOfFilesReadWithCustomerError() {
        return this.totalNumberOfFilesReadWithCustomerError;
    }

    public final Double throughput() {
        return this.throughput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfScannedFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSizeOfScannedFilesInMB());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfImportedFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfResourcesScanned());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfResourcesImported());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfResourcesWithCustomerError());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfFilesReadWithCustomerError());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobProgressReport)) {
            return false;
        }
        JobProgressReport other = (JobProgressReport)obj;
        return Objects.equals(this.totalNumberOfScannedFiles(), other.totalNumberOfScannedFiles()) && Objects.equals(this.totalSizeOfScannedFilesInMB(), other.totalSizeOfScannedFilesInMB()) && Objects.equals(this.totalNumberOfImportedFiles(), other.totalNumberOfImportedFiles()) && Objects.equals(this.totalNumberOfResourcesScanned(), other.totalNumberOfResourcesScanned()) && Objects.equals(this.totalNumberOfResourcesImported(), other.totalNumberOfResourcesImported()) && Objects.equals(this.totalNumberOfResourcesWithCustomerError(), other.totalNumberOfResourcesWithCustomerError()) && Objects.equals(this.totalNumberOfFilesReadWithCustomerError(), other.totalNumberOfFilesReadWithCustomerError()) && Objects.equals(this.throughput(), other.throughput());
    }

    public final String toString() {
        return ToString.builder((String)"JobProgressReport").add("TotalNumberOfScannedFiles", (Object)this.totalNumberOfScannedFiles()).add("TotalSizeOfScannedFilesInMB", (Object)this.totalSizeOfScannedFilesInMB()).add("TotalNumberOfImportedFiles", (Object)this.totalNumberOfImportedFiles()).add("TotalNumberOfResourcesScanned", (Object)this.totalNumberOfResourcesScanned()).add("TotalNumberOfResourcesImported", (Object)this.totalNumberOfResourcesImported()).add("TotalNumberOfResourcesWithCustomerError", (Object)this.totalNumberOfResourcesWithCustomerError()).add("TotalNumberOfFilesReadWithCustomerError", (Object)this.totalNumberOfFilesReadWithCustomerError()).add("Throughput", (Object)this.throughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalNumberOfScannedFiles": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfScannedFiles()));
            }
            case "TotalSizeOfScannedFilesInMB": {
                return Optional.ofNullable(clazz.cast(this.totalSizeOfScannedFilesInMB()));
            }
            case "TotalNumberOfImportedFiles": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfImportedFiles()));
            }
            case "TotalNumberOfResourcesScanned": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfResourcesScanned()));
            }
            case "TotalNumberOfResourcesImported": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfResourcesImported()));
            }
            case "TotalNumberOfResourcesWithCustomerError": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfResourcesWithCustomerError()));
            }
            case "TotalNumberOfFilesReadWithCustomerError": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfFilesReadWithCustomerError()));
            }
            case "Throughput": {
                return Optional.ofNullable(clazz.cast(this.throughput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobProgressReport, T> g) {
        return obj -> g.apply((JobProgressReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long totalNumberOfScannedFiles;
        private Double totalSizeOfScannedFilesInMB;
        private Long totalNumberOfImportedFiles;
        private Long totalNumberOfResourcesScanned;
        private Long totalNumberOfResourcesImported;
        private Long totalNumberOfResourcesWithCustomerError;
        private Long totalNumberOfFilesReadWithCustomerError;
        private Double throughput;

        private BuilderImpl() {
        }

        private BuilderImpl(JobProgressReport model) {
            this.totalNumberOfScannedFiles(model.totalNumberOfScannedFiles);
            this.totalSizeOfScannedFilesInMB(model.totalSizeOfScannedFilesInMB);
            this.totalNumberOfImportedFiles(model.totalNumberOfImportedFiles);
            this.totalNumberOfResourcesScanned(model.totalNumberOfResourcesScanned);
            this.totalNumberOfResourcesImported(model.totalNumberOfResourcesImported);
            this.totalNumberOfResourcesWithCustomerError(model.totalNumberOfResourcesWithCustomerError);
            this.totalNumberOfFilesReadWithCustomerError(model.totalNumberOfFilesReadWithCustomerError);
            this.throughput(model.throughput);
        }

        public final Long getTotalNumberOfScannedFiles() {
            return this.totalNumberOfScannedFiles;
        }

        public final void setTotalNumberOfScannedFiles(Long totalNumberOfScannedFiles) {
            this.totalNumberOfScannedFiles = totalNumberOfScannedFiles;
        }

        @Override
        public final Builder totalNumberOfScannedFiles(Long totalNumberOfScannedFiles) {
            this.totalNumberOfScannedFiles = totalNumberOfScannedFiles;
            return this;
        }

        public final Double getTotalSizeOfScannedFilesInMB() {
            return this.totalSizeOfScannedFilesInMB;
        }

        public final void setTotalSizeOfScannedFilesInMB(Double totalSizeOfScannedFilesInMB) {
            this.totalSizeOfScannedFilesInMB = totalSizeOfScannedFilesInMB;
        }

        @Override
        public final Builder totalSizeOfScannedFilesInMB(Double totalSizeOfScannedFilesInMB) {
            this.totalSizeOfScannedFilesInMB = totalSizeOfScannedFilesInMB;
            return this;
        }

        public final Long getTotalNumberOfImportedFiles() {
            return this.totalNumberOfImportedFiles;
        }

        public final void setTotalNumberOfImportedFiles(Long totalNumberOfImportedFiles) {
            this.totalNumberOfImportedFiles = totalNumberOfImportedFiles;
        }

        @Override
        public final Builder totalNumberOfImportedFiles(Long totalNumberOfImportedFiles) {
            this.totalNumberOfImportedFiles = totalNumberOfImportedFiles;
            return this;
        }

        public final Long getTotalNumberOfResourcesScanned() {
            return this.totalNumberOfResourcesScanned;
        }

        public final void setTotalNumberOfResourcesScanned(Long totalNumberOfResourcesScanned) {
            this.totalNumberOfResourcesScanned = totalNumberOfResourcesScanned;
        }

        @Override
        public final Builder totalNumberOfResourcesScanned(Long totalNumberOfResourcesScanned) {
            this.totalNumberOfResourcesScanned = totalNumberOfResourcesScanned;
            return this;
        }

        public final Long getTotalNumberOfResourcesImported() {
            return this.totalNumberOfResourcesImported;
        }

        public final void setTotalNumberOfResourcesImported(Long totalNumberOfResourcesImported) {
            this.totalNumberOfResourcesImported = totalNumberOfResourcesImported;
        }

        @Override
        public final Builder totalNumberOfResourcesImported(Long totalNumberOfResourcesImported) {
            this.totalNumberOfResourcesImported = totalNumberOfResourcesImported;
            return this;
        }

        public final Long getTotalNumberOfResourcesWithCustomerError() {
            return this.totalNumberOfResourcesWithCustomerError;
        }

        public final void setTotalNumberOfResourcesWithCustomerError(Long totalNumberOfResourcesWithCustomerError) {
            this.totalNumberOfResourcesWithCustomerError = totalNumberOfResourcesWithCustomerError;
        }

        @Override
        public final Builder totalNumberOfResourcesWithCustomerError(Long totalNumberOfResourcesWithCustomerError) {
            this.totalNumberOfResourcesWithCustomerError = totalNumberOfResourcesWithCustomerError;
            return this;
        }

        public final Long getTotalNumberOfFilesReadWithCustomerError() {
            return this.totalNumberOfFilesReadWithCustomerError;
        }

        public final void setTotalNumberOfFilesReadWithCustomerError(Long totalNumberOfFilesReadWithCustomerError) {
            this.totalNumberOfFilesReadWithCustomerError = totalNumberOfFilesReadWithCustomerError;
        }

        @Override
        public final Builder totalNumberOfFilesReadWithCustomerError(Long totalNumberOfFilesReadWithCustomerError) {
            this.totalNumberOfFilesReadWithCustomerError = totalNumberOfFilesReadWithCustomerError;
            return this;
        }

        public final Double getThroughput() {
            return this.throughput;
        }

        public final void setThroughput(Double throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Double throughput) {
            this.throughput = throughput;
            return this;
        }

        public JobProgressReport build() {
            return new JobProgressReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobProgressReport> {
        public Builder totalNumberOfScannedFiles(Long var1);

        public Builder totalSizeOfScannedFilesInMB(Double var1);

        public Builder totalNumberOfImportedFiles(Long var1);

        public Builder totalNumberOfResourcesScanned(Long var1);

        public Builder totalNumberOfResourcesImported(Long var1);

        public Builder totalNumberOfResourcesWithCustomerError(Long var1);

        public Builder totalNumberOfFilesReadWithCustomerError(Long var1);

        public Builder throughput(Double var1);
    }
}

