/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AgentHealthCode {
    IDLE("IDLE"),
    RUNNING("RUNNING"),
    SHUTDOWN("SHUTDOWN"),
    UNHEALTHY("UNHEALTHY"),
    THROTTLED("THROTTLED"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AgentHealthCode> VALUE_MAP;
    private final String value;

    private AgentHealthCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AgentHealthCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AgentHealthCode> knownValues() {
        EnumSet<AgentHealthCode> knownValues = EnumSet.allOf(AgentHealthCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AgentHealthCode.class, AgentHealthCode::toString);
    }
}

