/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorClient;
import software.amazon.awssdk.services.inspector.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse;

public class ListAssessmentTemplatesIterable
implements SdkIterable<ListAssessmentTemplatesResponse> {
    private final InspectorClient client;
    private final ListAssessmentTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssessmentTemplatesIterable(InspectorClient client, ListAssessmentTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssessmentTemplatesResponseFetcher();
    }

    public Iterator<ListAssessmentTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAssessmentTemplatesResponseFetcher
    implements SyncPageFetcher<ListAssessmentTemplatesResponse> {
        private ListAssessmentTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssessmentTemplatesResponse nextPage(ListAssessmentTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentTemplatesIterable.this.client.listAssessmentTemplates(ListAssessmentTemplatesIterable.this.firstRequest);
            }
            return ListAssessmentTemplatesIterable.this.client.listAssessmentTemplates((ListAssessmentTemplatesRequest)((Object)ListAssessmentTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

