/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRulesPackagesRequest extends InspectorRequest implements
        ToCopyableBuilder<DescribeRulesPackagesRequest.Builder, DescribeRulesPackagesRequest> {
    private static final SdkField<List<String>> RULES_PACKAGE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("rulesPackageArns")
            .getter(getter(DescribeRulesPackagesRequest::rulesPackageArns))
            .setter(setter(Builder::rulesPackageArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(DescribeRulesPackagesRequest::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_PACKAGE_ARNS_FIELD,
            LOCALE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> rulesPackageArns;

    private final String locale;

    private DescribeRulesPackagesRequest(BuilderImpl builder) {
        super(builder);
        this.rulesPackageArns = builder.rulesPackageArns;
        this.locale = builder.locale;
    }

    /**
     * For responses, this returns true if the service returned a value for the RulesPackageArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRulesPackageArns() {
        return rulesPackageArns != null && !(rulesPackageArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN that specifies the rules package that you want to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRulesPackageArns} method.
     * </p>
     * 
     * @return The ARN that specifies the rules package that you want to describe.
     */
    public final List<String> rulesPackageArns() {
        return rulesPackageArns;
    }

    /**
     * <p>
     * The locale that you want to translate a rules package description into.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale that you want to translate a rules package description into.
     * @see Locale
     */
    public final Locale locale() {
        return Locale.fromValue(locale);
    }

    /**
     * <p>
     * The locale that you want to translate a rules package description into.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale that you want to translate a rules package description into.
     * @see Locale
     */
    public final String localeAsString() {
        return locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRulesPackageArns() ? rulesPackageArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRulesPackagesRequest)) {
            return false;
        }
        DescribeRulesPackagesRequest other = (DescribeRulesPackagesRequest) obj;
        return hasRulesPackageArns() == other.hasRulesPackageArns()
                && Objects.equals(rulesPackageArns(), other.rulesPackageArns())
                && Objects.equals(localeAsString(), other.localeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRulesPackagesRequest")
                .add("RulesPackageArns", hasRulesPackageArns() ? rulesPackageArns() : null).add("Locale", localeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rulesPackageArns":
            return Optional.ofNullable(clazz.cast(rulesPackageArns()));
        case "locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rulesPackageArns", RULES_PACKAGE_ARNS_FIELD);
        map.put("locale", LOCALE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRulesPackagesRequest, T> g) {
        return obj -> g.apply((DescribeRulesPackagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRulesPackagesRequest> {
        /**
         * <p>
         * The ARN that specifies the rules package that you want to describe.
         * </p>
         * 
         * @param rulesPackageArns
         *        The ARN that specifies the rules package that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackageArns(Collection<String> rulesPackageArns);

        /**
         * <p>
         * The ARN that specifies the rules package that you want to describe.
         * </p>
         * 
         * @param rulesPackageArns
         *        The ARN that specifies the rules package that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackageArns(String... rulesPackageArns);

        /**
         * <p>
         * The locale that you want to translate a rules package description into.
         * </p>
         * 
         * @param locale
         *        The locale that you want to translate a rules package description into.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(String locale);

        /**
         * <p>
         * The locale that you want to translate a rules package description into.
         * </p>
         * 
         * @param locale
         *        The locale that you want to translate a rules package description into.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(Locale locale);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private List<String> rulesPackageArns = DefaultSdkAutoConstructList.getInstance();

        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRulesPackagesRequest model) {
            super(model);
            rulesPackageArns(model.rulesPackageArns);
            locale(model.locale);
        }

        public final Collection<String> getRulesPackageArns() {
            if (rulesPackageArns instanceof SdkAutoConstructList) {
                return null;
            }
            return rulesPackageArns;
        }

        public final void setRulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = BatchDescribeArnListCopier.copy(rulesPackageArns);
        }

        @Override
        public final Builder rulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = BatchDescribeArnListCopier.copy(rulesPackageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackageArns(String... rulesPackageArns) {
            rulesPackageArns(Arrays.asList(rulesPackageArns));
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRulesPackagesRequest build() {
            return new DescribeRulesPackagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
