/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about what was excluded from an assessment run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Exclusion implements SdkPojo, Serializable, ToCopyableBuilder<Exclusion.Builder, Exclusion> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Exclusion::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(Exclusion::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Exclusion::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> RECOMMENDATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendation").getter(getter(Exclusion::recommendation)).setter(setter(Builder::recommendation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()).build();

    private static final SdkField<List<Scope>> SCOPES_FIELD = SdkField
            .<List<Scope>> builder(MarshallingType.LIST)
            .memberName("scopes")
            .getter(getter(Exclusion::scopes))
            .setter(setter(Builder::scopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Scope> builder(MarshallingType.SDK_POJO)
                                            .constructor(Scope::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .memberName("attributes")
            .getter(getter(Exclusion::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TITLE_FIELD,
            DESCRIPTION_FIELD, RECOMMENDATION_FIELD, SCOPES_FIELD, ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String title;

    private final String description;

    private final String recommendation;

    private final List<Scope> scopes;

    private final List<Attribute> attributes;

    private Exclusion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.title = builder.title;
        this.description = builder.description;
        this.recommendation = builder.recommendation;
        this.scopes = builder.scopes;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The ARN that specifies the exclusion.
     * </p>
     * 
     * @return The ARN that specifies the exclusion.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the exclusion.
     * </p>
     * 
     * @return The name of the exclusion.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The description of the exclusion.
     * </p>
     * 
     * @return The description of the exclusion.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The recommendation for the exclusion.
     * </p>
     * 
     * @return The recommendation for the exclusion.
     */
    public final String recommendation() {
        return recommendation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scopes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScopes() {
        return scopes != null && !(scopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS resources for which the exclusion pertains.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScopes} method.
     * </p>
     * 
     * @return The AWS resources for which the exclusion pertains.
     */
    public final List<Scope> scopes() {
        return scopes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The system-defined attributes for the exclusion.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The system-defined attributes for the exclusion.
     */
    public final List<Attribute> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(hasScopes() ? scopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Exclusion)) {
            return false;
        }
        Exclusion other = (Exclusion) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(title(), other.title())
                && Objects.equals(description(), other.description()) && Objects.equals(recommendation(), other.recommendation())
                && hasScopes() == other.hasScopes() && Objects.equals(scopes(), other.scopes())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Exclusion").add("Arn", arn()).add("Title", title()).add("Description", description())
                .add("Recommendation", recommendation()).add("Scopes", hasScopes() ? scopes() : null)
                .add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "recommendation":
            return Optional.ofNullable(clazz.cast(recommendation()));
        case "scopes":
            return Optional.ofNullable(clazz.cast(scopes()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("recommendation", RECOMMENDATION_FIELD);
        map.put("scopes", SCOPES_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Exclusion, T> g) {
        return obj -> g.apply((Exclusion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Exclusion> {
        /**
         * <p>
         * The ARN that specifies the exclusion.
         * </p>
         * 
         * @param arn
         *        The ARN that specifies the exclusion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the exclusion.
         * </p>
         * 
         * @param title
         *        The name of the exclusion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description of the exclusion.
         * </p>
         * 
         * @param description
         *        The description of the exclusion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The recommendation for the exclusion.
         * </p>
         * 
         * @param recommendation
         *        The recommendation for the exclusion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendation(String recommendation);

        /**
         * <p>
         * The AWS resources for which the exclusion pertains.
         * </p>
         * 
         * @param scopes
         *        The AWS resources for which the exclusion pertains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Collection<Scope> scopes);

        /**
         * <p>
         * The AWS resources for which the exclusion pertains.
         * </p>
         * 
         * @param scopes
         *        The AWS resources for which the exclusion pertains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Scope... scopes);

        /**
         * <p>
         * The AWS resources for which the exclusion pertains.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector.model.Scope.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector.model.Scope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector.model.Scope.Builder#build()} is called immediately and its
         * result is passed to {@link #scopes(List<Scope>)}.
         * 
         * @param scopes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector.model.Scope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scopes(java.util.Collection<Scope>)
         */
        Builder scopes(Consumer<Scope.Builder>... scopes);

        /**
         * <p>
         * The system-defined attributes for the exclusion.
         * </p>
         * 
         * @param attributes
         *        The system-defined attributes for the exclusion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<Attribute> attributes);

        /**
         * <p>
         * The system-defined attributes for the exclusion.
         * </p>
         * 
         * @param attributes
         *        The system-defined attributes for the exclusion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Attribute... attributes);

        /**
         * <p>
         * The system-defined attributes for the exclusion.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector.model.Attribute.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector.model.Attribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector.model.Attribute.Builder#build()} is called immediately and
         * its result is passed to {@link #attributes(List<Attribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector.model.Attribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(java.util.Collection<Attribute>)
         */
        Builder attributes(Consumer<Attribute.Builder>... attributes);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String title;

        private String description;

        private String recommendation;

        private List<Scope> scopes = DefaultSdkAutoConstructList.getInstance();

        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Exclusion model) {
            arn(model.arn);
            title(model.title);
            description(model.description);
            recommendation(model.recommendation);
            scopes(model.scopes);
            attributes(model.attributes);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRecommendation() {
            return recommendation;
        }

        public final void setRecommendation(String recommendation) {
            this.recommendation = recommendation;
        }

        @Override
        public final Builder recommendation(String recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final List<Scope.Builder> getScopes() {
            List<Scope.Builder> result = ScopeListCopier.copyToBuilder(this.scopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScopes(Collection<Scope.BuilderImpl> scopes) {
            this.scopes = ScopeListCopier.copyFromBuilder(scopes);
        }

        @Override
        public final Builder scopes(Collection<Scope> scopes) {
            this.scopes = ScopeListCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(Scope... scopes) {
            scopes(Arrays.asList(scopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(Consumer<Scope.Builder>... scopes) {
            scopes(Stream.of(scopes).map(c -> Scope.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Attribute.Builder> getAttributes() {
            List<Attribute.Builder> result = AttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> Attribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Exclusion build() {
            return new Exclusion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
