/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <a>EnableEnhancedMonitoring</a> and <a>DisableEnhancedMonitoring</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableEnhancedMonitoringResponse extends KinesisResponse implements
        ToCopyableBuilder<DisableEnhancedMonitoringResponse.Builder, DisableEnhancedMonitoringResponse> {
    private final String streamName;

    private final List<String> currentShardLevelMetrics;

    private final List<String> desiredShardLevelMetrics;

    private DisableEnhancedMonitoringResponse(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.currentShardLevelMetrics = builder.currentShardLevelMetrics;
        this.desiredShardLevelMetrics = builder.desiredShardLevelMetrics;
    }

    /**
     * <p>
     * The name of the Kinesis data stream.
     * </p>
     * 
     * @return The name of the Kinesis data stream.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * Represents the current state of the metrics that are in the enhanced state before the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the current state of the metrics that are in the enhanced state before the operation.
     */
    public List<MetricsName> currentShardLevelMetrics() {
        return TypeConverter.convert(currentShardLevelMetrics, MetricsName::fromValue);
    }

    /**
     * <p>
     * Represents the current state of the metrics that are in the enhanced state before the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the current state of the metrics that are in the enhanced state before the operation.
     */
    public List<String> currentShardLevelMetricsAsStrings() {
        return currentShardLevelMetrics;
    }

    /**
     * <p>
     * Represents the list of all the metrics that would be in the enhanced state after the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the list of all the metrics that would be in the enhanced state after the operation.
     */
    public List<MetricsName> desiredShardLevelMetrics() {
        return TypeConverter.convert(desiredShardLevelMetrics, MetricsName::fromValue);
    }

    /**
     * <p>
     * Represents the list of all the metrics that would be in the enhanced state after the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the list of all the metrics that would be in the enhanced state after the operation.
     */
    public List<String> desiredShardLevelMetricsAsStrings() {
        return desiredShardLevelMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(currentShardLevelMetricsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(desiredShardLevelMetricsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableEnhancedMonitoringResponse)) {
            return false;
        }
        DisableEnhancedMonitoringResponse other = (DisableEnhancedMonitoringResponse) obj;
        return Objects.equals(streamName(), other.streamName())
                && Objects.equals(currentShardLevelMetricsAsStrings(), other.currentShardLevelMetricsAsStrings())
                && Objects.equals(desiredShardLevelMetricsAsStrings(), other.desiredShardLevelMetricsAsStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("DisableEnhancedMonitoringResponse").add("StreamName", streamName())
                .add("CurrentShardLevelMetrics", currentShardLevelMetricsAsStrings())
                .add("DesiredShardLevelMetrics", desiredShardLevelMetricsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "CurrentShardLevelMetrics":
            return Optional.ofNullable(clazz.cast(currentShardLevelMetricsAsStrings()));
        case "DesiredShardLevelMetrics":
            return Optional.ofNullable(clazz.cast(desiredShardLevelMetricsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisResponse.Builder, CopyableBuilder<Builder, DisableEnhancedMonitoringResponse> {
        /**
         * <p>
         * The name of the Kinesis data stream.
         * </p>
         * 
         * @param streamName
         *        The name of the Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetricsWithStrings(Collection<String> currentShardLevelMetrics);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetricsWithStrings(String... currentShardLevelMetrics);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetrics(Collection<MetricsName> currentShardLevelMetrics);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardLevelMetrics(MetricsName... currentShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetricsWithStrings(Collection<String> desiredShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetricsWithStrings(String... desiredShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetrics(Collection<MetricsName> desiredShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredShardLevelMetrics(MetricsName... desiredShardLevelMetrics);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private String streamName;

        private List<String> currentShardLevelMetrics = DefaultSdkAutoConstructList.getInstance();

        private List<String> desiredShardLevelMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisableEnhancedMonitoringResponse model) {
            super(model);
            streamName(model.streamName);
            currentShardLevelMetricsWithStrings(model.currentShardLevelMetrics);
            desiredShardLevelMetricsWithStrings(model.desiredShardLevelMetrics);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getCurrentShardLevelMetrics() {
            return currentShardLevelMetrics;
        }

        @Override
        public final Builder currentShardLevelMetricsWithStrings(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetricsWithStrings(String... currentShardLevelMetrics) {
            currentShardLevelMetricsWithStrings(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        @Override
        public final Builder currentShardLevelMetrics(Collection<MetricsName> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copyEnumToString(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetrics(MetricsName... currentShardLevelMetrics) {
            currentShardLevelMetrics(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        public final void setCurrentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
        }

        public final Collection<String> getDesiredShardLevelMetrics() {
            return desiredShardLevelMetrics;
        }

        @Override
        public final Builder desiredShardLevelMetricsWithStrings(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetricsWithStrings(String... desiredShardLevelMetrics) {
            desiredShardLevelMetricsWithStrings(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        @Override
        public final Builder desiredShardLevelMetrics(Collection<MetricsName> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copyEnumToString(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetrics(MetricsName... desiredShardLevelMetrics) {
            desiredShardLevelMetrics(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        public final void setDesiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
        }

        @Override
        public DisableEnhancedMonitoringResponse build() {
            return new DisableEnhancedMonitoringResponse(this);
        }
    }
}
