/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterStreamConsumerResponse extends KinesisResponse implements
        ToCopyableBuilder<RegisterStreamConsumerResponse.Builder, RegisterStreamConsumerResponse> {
    private final Consumer consumer;

    private RegisterStreamConsumerResponse(BuilderImpl builder) {
        super(builder);
        this.consumer = builder.consumer;
    }

    /**
     * <p>
     * An object that represents the details of the consumer you registered. When you register a consumer, it gets an
     * ARN that is generated by Kinesis Data Streams.
     * </p>
     * 
     * @return An object that represents the details of the consumer you registered. When you register a consumer, it
     *         gets an ARN that is generated by Kinesis Data Streams.
     */
    public Consumer consumer() {
        return consumer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consumer());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterStreamConsumerResponse)) {
            return false;
        }
        RegisterStreamConsumerResponse other = (RegisterStreamConsumerResponse) obj;
        return Objects.equals(consumer(), other.consumer());
    }

    @Override
    public String toString() {
        return ToString.builder("RegisterStreamConsumerResponse").add("Consumer", consumer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Consumer":
            return Optional.ofNullable(clazz.cast(consumer()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisResponse.Builder, CopyableBuilder<Builder, RegisterStreamConsumerResponse> {
        /**
         * <p>
         * An object that represents the details of the consumer you registered. When you register a consumer, it gets
         * an ARN that is generated by Kinesis Data Streams.
         * </p>
         * 
         * @param consumer
         *        An object that represents the details of the consumer you registered. When you register a consumer, it
         *        gets an ARN that is generated by Kinesis Data Streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumer(Consumer consumer);

        /**
         * <p>
         * An object that represents the details of the consumer you registered. When you register a consumer, it gets
         * an ARN that is generated by Kinesis Data Streams.
         * </p>
         * This is a convenience that creates an instance of the {@link Consumer.Builder} avoiding the need to create
         * one manually via {@link Consumer#builder()}.
         *
         * When the {@link Consumer} completes, {@link Consumer.Builder#build()} is called immediately and its result is
         * passed to {@link #consumer(Consumer)}.
         * 
         * @param consumer
         *        a consumer that will call methods on {@link Consumer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumer(Consumer)
         */
        default Builder consumer(java.util.function.Consumer<Consumer.Builder> consumer) {
            return consumer(Consumer.builder().applyMutation(consumer).build());
        }
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private Consumer consumer;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterStreamConsumerResponse model) {
            super(model);
            consumer(model.consumer);
        }

        public final Consumer.Builder getConsumer() {
            return consumer != null ? consumer.toBuilder() : null;
        }

        @Override
        public final Builder consumer(Consumer consumer) {
            this.consumer = consumer;
            return this;
        }

        public final void setConsumer(Consumer.BuilderImpl consumer) {
            this.consumer = consumer != null ? consumer.build() : null;
        }

        @Override
        public RegisterStreamConsumerResponse build() {
            return new RegisterStreamConsumerResponse(this);
        }
    }
}
