/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.transform;

import java.math.*;
import software.amazon.awssdk.core.SdkBytes;
import javax.annotation.Generated;

import software.amazon.awssdk.services.kinesis.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Record JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RecordUnmarshaller implements Unmarshaller<Record, JsonUnmarshallerContext> {

    public Record unmarshall(JsonUnmarshallerContext context) throws Exception {
        Record.Builder recordBuilder = Record.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("SequenceNumber", targetDepth)) {
                    context.nextToken();
                    recordBuilder.sequenceNumber(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ApproximateArrivalTimestamp", targetDepth)) {
                    context.nextToken();
                    recordBuilder.approximateArrivalTimestamp(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("Data", targetDepth)) {
                    context.nextToken();
                    recordBuilder.data(context.getUnmarshaller(software.amazon.awssdk.core.SdkBytes.class).unmarshall(context));
                }
                if (context.testExpression("PartitionKey", targetDepth)) {
                    context.nextToken();
                    recordBuilder.partitionKey(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("EncryptionType", targetDepth)) {
                    context.nextToken();
                    recordBuilder.encryptionType(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return recordBuilder.build();
    }

    private static final RecordUnmarshaller INSTANCE = new RecordUnmarshaller();

    public static RecordUnmarshaller getInstance() {
        return INSTANCE;
    }
}
