/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QnAKendraConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QnAKendraConfiguration> {
    private static final SdkField<String> KENDRA_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kendraIndex").getter(QnAKendraConfiguration.getter(QnAKendraConfiguration::kendraIndex)).setter(QnAKendraConfiguration.setter(Builder::kendraIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraIndex").build()}).build();
    private static final SdkField<Boolean> QUERY_FILTER_STRING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("queryFilterStringEnabled").getter(QnAKendraConfiguration.getter(QnAKendraConfiguration::queryFilterStringEnabled)).setter(QnAKendraConfiguration.setter(Builder::queryFilterStringEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryFilterStringEnabled").build()}).build();
    private static final SdkField<String> QUERY_FILTER_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryFilterString").getter(QnAKendraConfiguration.getter(QnAKendraConfiguration::queryFilterString)).setter(QnAKendraConfiguration.setter(Builder::queryFilterString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryFilterString").build()}).build();
    private static final SdkField<Boolean> EXACT_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("exactResponse").getter(QnAKendraConfiguration.getter(QnAKendraConfiguration::exactResponse)).setter(QnAKendraConfiguration.setter(Builder::exactResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exactResponse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KENDRA_INDEX_FIELD, QUERY_FILTER_STRING_ENABLED_FIELD, QUERY_FILTER_STRING_FIELD, EXACT_RESPONSE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kendraIndex;
    private final Boolean queryFilterStringEnabled;
    private final String queryFilterString;
    private final Boolean exactResponse;

    private QnAKendraConfiguration(BuilderImpl builder) {
        this.kendraIndex = builder.kendraIndex;
        this.queryFilterStringEnabled = builder.queryFilterStringEnabled;
        this.queryFilterString = builder.queryFilterString;
        this.exactResponse = builder.exactResponse;
    }

    public final String kendraIndex() {
        return this.kendraIndex;
    }

    public final Boolean queryFilterStringEnabled() {
        return this.queryFilterStringEnabled;
    }

    public final String queryFilterString() {
        return this.queryFilterString;
    }

    public final Boolean exactResponse() {
        return this.exactResponse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kendraIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryFilterStringEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryFilterString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exactResponse());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QnAKendraConfiguration)) {
            return false;
        }
        QnAKendraConfiguration other = (QnAKendraConfiguration)obj;
        return Objects.equals(this.kendraIndex(), other.kendraIndex()) && Objects.equals(this.queryFilterStringEnabled(), other.queryFilterStringEnabled()) && Objects.equals(this.queryFilterString(), other.queryFilterString()) && Objects.equals(this.exactResponse(), other.exactResponse());
    }

    public final String toString() {
        return ToString.builder((String)"QnAKendraConfiguration").add("KendraIndex", (Object)this.kendraIndex()).add("QueryFilterStringEnabled", (Object)this.queryFilterStringEnabled()).add("QueryFilterString", (Object)this.queryFilterString()).add("ExactResponse", (Object)this.exactResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kendraIndex": {
                return Optional.ofNullable(clazz.cast(this.kendraIndex()));
            }
            case "queryFilterStringEnabled": {
                return Optional.ofNullable(clazz.cast(this.queryFilterStringEnabled()));
            }
            case "queryFilterString": {
                return Optional.ofNullable(clazz.cast(this.queryFilterString()));
            }
            case "exactResponse": {
                return Optional.ofNullable(clazz.cast(this.exactResponse()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QnAKendraConfiguration, T> g) {
        return obj -> g.apply((QnAKendraConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kendraIndex;
        private Boolean queryFilterStringEnabled;
        private String queryFilterString;
        private Boolean exactResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(QnAKendraConfiguration model) {
            this.kendraIndex(model.kendraIndex);
            this.queryFilterStringEnabled(model.queryFilterStringEnabled);
            this.queryFilterString(model.queryFilterString);
            this.exactResponse(model.exactResponse);
        }

        public final String getKendraIndex() {
            return this.kendraIndex;
        }

        public final void setKendraIndex(String kendraIndex) {
            this.kendraIndex = kendraIndex;
        }

        @Override
        public final Builder kendraIndex(String kendraIndex) {
            this.kendraIndex = kendraIndex;
            return this;
        }

        public final Boolean getQueryFilterStringEnabled() {
            return this.queryFilterStringEnabled;
        }

        public final void setQueryFilterStringEnabled(Boolean queryFilterStringEnabled) {
            this.queryFilterStringEnabled = queryFilterStringEnabled;
        }

        @Override
        public final Builder queryFilterStringEnabled(Boolean queryFilterStringEnabled) {
            this.queryFilterStringEnabled = queryFilterStringEnabled;
            return this;
        }

        public final String getQueryFilterString() {
            return this.queryFilterString;
        }

        public final void setQueryFilterString(String queryFilterString) {
            this.queryFilterString = queryFilterString;
        }

        @Override
        public final Builder queryFilterString(String queryFilterString) {
            this.queryFilterString = queryFilterString;
            return this;
        }

        public final Boolean getExactResponse() {
            return this.exactResponse;
        }

        public final void setExactResponse(Boolean exactResponse) {
            this.exactResponse = exactResponse;
        }

        @Override
        public final Builder exactResponse(Boolean exactResponse) {
            this.exactResponse = exactResponse;
            return this;
        }

        public QnAKendraConfiguration build() {
            return new QnAKendraConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QnAKendraConfiguration> {
        public Builder kendraIndex(String var1);

        public Builder queryFilterStringEnabled(Boolean var1);

        public Builder queryFilterString(String var1);

        public Builder exactResponse(Boolean var1);
    }
}

