/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotAliasReplicationStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.FailureReasonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BotAliasReplicaSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BotAliasReplicaSummary> {
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasId").getter(BotAliasReplicaSummary.getter(BotAliasReplicaSummary::botAliasId)).setter(BotAliasReplicaSummary.setter(Builder::botAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()}).build();
    private static final SdkField<String> BOT_ALIAS_REPLICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasReplicationStatus").getter(BotAliasReplicaSummary.getter(BotAliasReplicaSummary::botAliasReplicationStatusAsString)).setter(BotAliasReplicaSummary.setter(Builder::botAliasReplicationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasReplicationStatus").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(BotAliasReplicaSummary.getter(BotAliasReplicaSummary::botVersion)).setter(BotAliasReplicaSummary.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(BotAliasReplicaSummary.getter(BotAliasReplicaSummary::creationDateTime)).setter(BotAliasReplicaSummary.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(BotAliasReplicaSummary.getter(BotAliasReplicaSummary::lastUpdatedDateTime)).setter(BotAliasReplicaSummary.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(BotAliasReplicaSummary.getter(BotAliasReplicaSummary::failureReasons)).setter(BotAliasReplicaSummary.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_ID_FIELD, BOT_ALIAS_REPLICATION_STATUS_FIELD, BOT_VERSION_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, FAILURE_REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BotAliasReplicaSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String botAliasId;
    private final String botAliasReplicationStatus;
    private final String botVersion;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final List<String> failureReasons;

    private BotAliasReplicaSummary(BuilderImpl builder) {
        this.botAliasId = builder.botAliasId;
        this.botAliasReplicationStatus = builder.botAliasReplicationStatus;
        this.botVersion = builder.botVersion;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReasons = builder.failureReasons;
    }

    public final String botAliasId() {
        return this.botAliasId;
    }

    public final BotAliasReplicationStatus botAliasReplicationStatus() {
        return BotAliasReplicationStatus.fromValue(this.botAliasReplicationStatus);
    }

    public final String botAliasReplicationStatusAsString() {
        return this.botAliasReplicationStatus;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasReplicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotAliasReplicaSummary)) {
            return false;
        }
        BotAliasReplicaSummary other = (BotAliasReplicaSummary)obj;
        return Objects.equals(this.botAliasId(), other.botAliasId()) && Objects.equals(this.botAliasReplicationStatusAsString(), other.botAliasReplicationStatusAsString()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons());
    }

    public final String toString() {
        return ToString.builder((String)"BotAliasReplicaSummary").add("BotAliasId", (Object)this.botAliasId()).add("BotAliasReplicationStatus", (Object)this.botAliasReplicationStatusAsString()).add("BotVersion", (Object)this.botVersion()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botAliasId": {
                return Optional.ofNullable(clazz.cast(this.botAliasId()));
            }
            case "botAliasReplicationStatus": {
                return Optional.ofNullable(clazz.cast(this.botAliasReplicationStatusAsString()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botAliasId", BOT_ALIAS_ID_FIELD);
        map.put("botAliasReplicationStatus", BOT_ALIAS_REPLICATION_STATUS_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BotAliasReplicaSummary, T> g) {
        return obj -> g.apply((BotAliasReplicaSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String botAliasId;
        private String botAliasReplicationStatus;
        private String botVersion;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BotAliasReplicaSummary model) {
            this.botAliasId(model.botAliasId);
            this.botAliasReplicationStatus(model.botAliasReplicationStatus);
            this.botVersion(model.botVersion);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.failureReasons(model.failureReasons);
        }

        public final String getBotAliasId() {
            return this.botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotAliasReplicationStatus() {
            return this.botAliasReplicationStatus;
        }

        public final void setBotAliasReplicationStatus(String botAliasReplicationStatus) {
            this.botAliasReplicationStatus = botAliasReplicationStatus;
        }

        @Override
        public final Builder botAliasReplicationStatus(String botAliasReplicationStatus) {
            this.botAliasReplicationStatus = botAliasReplicationStatus;
            return this;
        }

        @Override
        public final Builder botAliasReplicationStatus(BotAliasReplicationStatus botAliasReplicationStatus) {
            this.botAliasReplicationStatus(botAliasReplicationStatus == null ? null : botAliasReplicationStatus.toString());
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public BotAliasReplicaSummary build() {
            return new BotAliasReplicaSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BotAliasReplicaSummary> {
        public Builder botAliasId(String var1);

        public Builder botAliasReplicationStatus(String var1);

        public Builder botAliasReplicationStatus(BotAliasReplicationStatus var1);

        public Builder botVersion(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);
    }
}

