/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetModality;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetStorageLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTestSetResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, UpdateTestSetResponse> {
    private static final SdkField<String> TEST_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetId").getter(UpdateTestSetResponse.getter(UpdateTestSetResponse::testSetId)).setter(UpdateTestSetResponse.setter(Builder::testSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetId").build()}).build();
    private static final SdkField<String> TEST_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetName").getter(UpdateTestSetResponse.getter(UpdateTestSetResponse::testSetName)).setter(UpdateTestSetResponse.setter(Builder::testSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateTestSetResponse.getter(UpdateTestSetResponse::description)).setter(UpdateTestSetResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> MODALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modality").getter(UpdateTestSetResponse.getter(UpdateTestSetResponse::modalityAsString)).setter(UpdateTestSetResponse.setter(Builder::modality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modality").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateTestSetResponse.getter(UpdateTestSetResponse::statusAsString)).setter(UpdateTestSetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateTestSetResponse.getter(UpdateTestSetResponse::roleArn)).setter(UpdateTestSetResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Integer> NUM_TURNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numTurns").getter(UpdateTestSetResponse.getter(UpdateTestSetResponse::numTurns)).setter(UpdateTestSetResponse.setter(Builder::numTurns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numTurns").build()}).build();
    private static final SdkField<TestSetStorageLocation> STORAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageLocation").getter(UpdateTestSetResponse.getter(UpdateTestSetResponse::storageLocation)).setter(UpdateTestSetResponse.setter(Builder::storageLocation)).constructor(TestSetStorageLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLocation").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(UpdateTestSetResponse.getter(UpdateTestSetResponse::creationDateTime)).setter(UpdateTestSetResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(UpdateTestSetResponse.getter(UpdateTestSetResponse::lastUpdatedDateTime)).setter(UpdateTestSetResponse.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SET_ID_FIELD, TEST_SET_NAME_FIELD, DESCRIPTION_FIELD, MODALITY_FIELD, STATUS_FIELD, ROLE_ARN_FIELD, NUM_TURNS_FIELD, STORAGE_LOCATION_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTestSetResponse.memberNameToFieldInitializer();
    private final String testSetId;
    private final String testSetName;
    private final String description;
    private final String modality;
    private final String status;
    private final String roleArn;
    private final Integer numTurns;
    private final TestSetStorageLocation storageLocation;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private UpdateTestSetResponse(BuilderImpl builder) {
        super(builder);
        this.testSetId = builder.testSetId;
        this.testSetName = builder.testSetName;
        this.description = builder.description;
        this.modality = builder.modality;
        this.status = builder.status;
        this.roleArn = builder.roleArn;
        this.numTurns = builder.numTurns;
        this.storageLocation = builder.storageLocation;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String testSetId() {
        return this.testSetId;
    }

    public final String testSetName() {
        return this.testSetName;
    }

    public final String description() {
        return this.description;
    }

    public final TestSetModality modality() {
        return TestSetModality.fromValue(this.modality);
    }

    public final String modalityAsString() {
        return this.modality;
    }

    public final TestSetStatus status() {
        return TestSetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Integer numTurns() {
        return this.numTurns;
    }

    public final TestSetStorageLocation storageLocation() {
        return this.storageLocation;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.modalityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.numTurns());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTestSetResponse)) {
            return false;
        }
        UpdateTestSetResponse other = (UpdateTestSetResponse)((Object)obj);
        return Objects.equals(this.testSetId(), other.testSetId()) && Objects.equals(this.testSetName(), other.testSetName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.modalityAsString(), other.modalityAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.numTurns(), other.numTurns()) && Objects.equals(this.storageLocation(), other.storageLocation()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTestSetResponse").add("TestSetId", (Object)this.testSetId()).add("TestSetName", (Object)this.testSetName()).add("Description", (Object)this.description()).add("Modality", (Object)this.modalityAsString()).add("Status", (Object)this.statusAsString()).add("RoleArn", (Object)this.roleArn()).add("NumTurns", (Object)this.numTurns()).add("StorageLocation", (Object)this.storageLocation()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testSetId": {
                return Optional.ofNullable(clazz.cast(this.testSetId()));
            }
            case "testSetName": {
                return Optional.ofNullable(clazz.cast(this.testSetName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "modality": {
                return Optional.ofNullable(clazz.cast(this.modalityAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "numTurns": {
                return Optional.ofNullable(clazz.cast(this.numTurns()));
            }
            case "storageLocation": {
                return Optional.ofNullable(clazz.cast(this.storageLocation()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testSetId", TEST_SET_ID_FIELD);
        map.put("testSetName", TEST_SET_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("modality", MODALITY_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("numTurns", NUM_TURNS_FIELD);
        map.put("storageLocation", STORAGE_LOCATION_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTestSetResponse, T> g) {
        return obj -> g.apply((UpdateTestSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String testSetId;
        private String testSetName;
        private String description;
        private String modality;
        private String status;
        private String roleArn;
        private Integer numTurns;
        private TestSetStorageLocation storageLocation;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTestSetResponse model) {
            super(model);
            this.testSetId(model.testSetId);
            this.testSetName(model.testSetName);
            this.description(model.description);
            this.modality(model.modality);
            this.status(model.status);
            this.roleArn(model.roleArn);
            this.numTurns(model.numTurns);
            this.storageLocation(model.storageLocation);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getTestSetId() {
            return this.testSetId;
        }

        public final void setTestSetId(String testSetId) {
            this.testSetId = testSetId;
        }

        @Override
        public final Builder testSetId(String testSetId) {
            this.testSetId = testSetId;
            return this;
        }

        public final String getTestSetName() {
            return this.testSetName;
        }

        public final void setTestSetName(String testSetName) {
            this.testSetName = testSetName;
        }

        @Override
        public final Builder testSetName(String testSetName) {
            this.testSetName = testSetName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getModality() {
            return this.modality;
        }

        public final void setModality(String modality) {
            this.modality = modality;
        }

        @Override
        public final Builder modality(String modality) {
            this.modality = modality;
            return this;
        }

        @Override
        public final Builder modality(TestSetModality modality) {
            this.modality(modality == null ? null : modality.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Integer getNumTurns() {
            return this.numTurns;
        }

        public final void setNumTurns(Integer numTurns) {
            this.numTurns = numTurns;
        }

        @Override
        public final Builder numTurns(Integer numTurns) {
            this.numTurns = numTurns;
            return this;
        }

        public final TestSetStorageLocation.Builder getStorageLocation() {
            return this.storageLocation != null ? this.storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(TestSetStorageLocation.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public final Builder storageLocation(TestSetStorageLocation storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public UpdateTestSetResponse build() {
            return new UpdateTestSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTestSetResponse> {
        public Builder testSetId(String var1);

        public Builder testSetName(String var1);

        public Builder description(String var1);

        public Builder modality(String var1);

        public Builder modality(TestSetModality var1);

        public Builder status(String var1);

        public Builder status(TestSetStatus var1);

        public Builder roleArn(String var1);

        public Builder numTurns(Integer var1);

        public Builder storageLocation(TestSetStorageLocation var1);

        default public Builder storageLocation(Consumer<TestSetStorageLocation.Builder> storageLocation) {
            return this.storageLocation((TestSetStorageLocation)((TestSetStorageLocation.Builder)TestSetStorageLocation.builder().applyMutation(storageLocation)).build());
        }

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

