/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceentitlement;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.marketplaceentitlement.DefaultMarketplaceEntitlementClientBuilder;
import software.amazon.awssdk.services.marketplaceentitlement.MarketplaceEntitlementClientBuilder;
import software.amazon.awssdk.services.marketplaceentitlement.MarketplaceEntitlementServiceClientConfiguration;
import software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsRequest;
import software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsResponse;
import software.amazon.awssdk.services.marketplaceentitlement.model.InternalServiceErrorException;
import software.amazon.awssdk.services.marketplaceentitlement.model.InvalidParameterException;
import software.amazon.awssdk.services.marketplaceentitlement.model.MarketplaceEntitlementException;
import software.amazon.awssdk.services.marketplaceentitlement.model.ThrottlingException;
import software.amazon.awssdk.services.marketplaceentitlement.paginators.GetEntitlementsIterable;

@SdkPublicApi
@ThreadSafe
public interface MarketplaceEntitlementClient
extends AwsClient {
    public static final String SERVICE_NAME = "aws-marketplace";
    public static final String SERVICE_METADATA_ID = "entitlement.marketplace";

    default public GetEntitlementsResponse getEntitlements(GetEntitlementsRequest getEntitlementsRequest) throws InvalidParameterException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, MarketplaceEntitlementException {
        throw new UnsupportedOperationException();
    }

    default public GetEntitlementsResponse getEntitlements(Consumer<GetEntitlementsRequest.Builder> getEntitlementsRequest) throws InvalidParameterException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, MarketplaceEntitlementException {
        return this.getEntitlements((GetEntitlementsRequest)((Object)((GetEntitlementsRequest.Builder)GetEntitlementsRequest.builder().applyMutation(getEntitlementsRequest)).build()));
    }

    default public GetEntitlementsIterable getEntitlementsPaginator(GetEntitlementsRequest getEntitlementsRequest) throws InvalidParameterException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, MarketplaceEntitlementException {
        return new GetEntitlementsIterable(this, getEntitlementsRequest);
    }

    default public GetEntitlementsIterable getEntitlementsPaginator(Consumer<GetEntitlementsRequest.Builder> getEntitlementsRequest) throws InvalidParameterException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException, MarketplaceEntitlementException {
        return this.getEntitlementsPaginator((GetEntitlementsRequest)((Object)((GetEntitlementsRequest.Builder)GetEntitlementsRequest.builder().applyMutation(getEntitlementsRequest)).build()));
    }

    public static MarketplaceEntitlementClient create() {
        return (MarketplaceEntitlementClient)MarketplaceEntitlementClient.builder().build();
    }

    public static MarketplaceEntitlementClientBuilder builder() {
        return new DefaultMarketplaceEntitlementClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }

    default public MarketplaceEntitlementServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

