/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.mediatailor.model.BadRequestException;
import software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelRequest;
import software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelResponse;
import software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest;
import software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse;
import software.amazon.awssdk.services.mediatailor.model.CreateChannelRequest;
import software.amazon.awssdk.services.mediatailor.model.CreateChannelResponse;
import software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceRequest;
import software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceResponse;
import software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleRequest;
import software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleResponse;
import software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest;
import software.amazon.awssdk.services.mediatailor.model.CreateProgramResponse;
import software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest;
import software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationResponse;
import software.amazon.awssdk.services.mediatailor.model.CreateVodSourceRequest;
import software.amazon.awssdk.services.mediatailor.model.CreateVodSourceResponse;
import software.amazon.awssdk.services.mediatailor.model.DeleteChannelPolicyRequest;
import software.amazon.awssdk.services.mediatailor.model.DeleteChannelPolicyResponse;
import software.amazon.awssdk.services.mediatailor.model.DeleteChannelRequest;
import software.amazon.awssdk.services.mediatailor.model.DeleteChannelResponse;
import software.amazon.awssdk.services.mediatailor.model.DeleteLiveSourceRequest;
import software.amazon.awssdk.services.mediatailor.model.DeleteLiveSourceResponse;
import software.amazon.awssdk.services.mediatailor.model.DeletePlaybackConfigurationRequest;
import software.amazon.awssdk.services.mediatailor.model.DeletePlaybackConfigurationResponse;
import software.amazon.awssdk.services.mediatailor.model.DeletePrefetchScheduleRequest;
import software.amazon.awssdk.services.mediatailor.model.DeletePrefetchScheduleResponse;
import software.amazon.awssdk.services.mediatailor.model.DeleteProgramRequest;
import software.amazon.awssdk.services.mediatailor.model.DeleteProgramResponse;
import software.amazon.awssdk.services.mediatailor.model.DeleteSourceLocationRequest;
import software.amazon.awssdk.services.mediatailor.model.DeleteSourceLocationResponse;
import software.amazon.awssdk.services.mediatailor.model.DeleteVodSourceRequest;
import software.amazon.awssdk.services.mediatailor.model.DeleteVodSourceResponse;
import software.amazon.awssdk.services.mediatailor.model.DescribeChannelRequest;
import software.amazon.awssdk.services.mediatailor.model.DescribeChannelResponse;
import software.amazon.awssdk.services.mediatailor.model.DescribeLiveSourceRequest;
import software.amazon.awssdk.services.mediatailor.model.DescribeLiveSourceResponse;
import software.amazon.awssdk.services.mediatailor.model.DescribeProgramRequest;
import software.amazon.awssdk.services.mediatailor.model.DescribeProgramResponse;
import software.amazon.awssdk.services.mediatailor.model.DescribeSourceLocationRequest;
import software.amazon.awssdk.services.mediatailor.model.DescribeSourceLocationResponse;
import software.amazon.awssdk.services.mediatailor.model.DescribeVodSourceRequest;
import software.amazon.awssdk.services.mediatailor.model.DescribeVodSourceResponse;
import software.amazon.awssdk.services.mediatailor.model.GetChannelPolicyRequest;
import software.amazon.awssdk.services.mediatailor.model.GetChannelPolicyResponse;
import software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest;
import software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleResponse;
import software.amazon.awssdk.services.mediatailor.model.GetPlaybackConfigurationRequest;
import software.amazon.awssdk.services.mediatailor.model.GetPlaybackConfigurationResponse;
import software.amazon.awssdk.services.mediatailor.model.GetPrefetchScheduleRequest;
import software.amazon.awssdk.services.mediatailor.model.GetPrefetchScheduleResponse;
import software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListAlertsResponse;
import software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListChannelsResponse;
import software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesRequest;
import software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesResponse;
import software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse;
import software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest;
import software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse;
import software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsResponse;
import software.amazon.awssdk.services.mediatailor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediatailor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest;
import software.amazon.awssdk.services.mediatailor.model.ListVodSourcesResponse;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorException;
import software.amazon.awssdk.services.mediatailor.model.PutChannelPolicyRequest;
import software.amazon.awssdk.services.mediatailor.model.PutChannelPolicyResponse;
import software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest;
import software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationResponse;
import software.amazon.awssdk.services.mediatailor.model.StartChannelRequest;
import software.amazon.awssdk.services.mediatailor.model.StartChannelResponse;
import software.amazon.awssdk.services.mediatailor.model.StopChannelRequest;
import software.amazon.awssdk.services.mediatailor.model.StopChannelResponse;
import software.amazon.awssdk.services.mediatailor.model.TagResourceRequest;
import software.amazon.awssdk.services.mediatailor.model.TagResourceResponse;
import software.amazon.awssdk.services.mediatailor.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediatailor.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest;
import software.amazon.awssdk.services.mediatailor.model.UpdateChannelResponse;
import software.amazon.awssdk.services.mediatailor.model.UpdateLiveSourceRequest;
import software.amazon.awssdk.services.mediatailor.model.UpdateLiveSourceResponse;
import software.amazon.awssdk.services.mediatailor.model.UpdateProgramRequest;
import software.amazon.awssdk.services.mediatailor.model.UpdateProgramResponse;
import software.amazon.awssdk.services.mediatailor.model.UpdateSourceLocationRequest;
import software.amazon.awssdk.services.mediatailor.model.UpdateSourceLocationResponse;
import software.amazon.awssdk.services.mediatailor.model.UpdateVodSourceRequest;
import software.amazon.awssdk.services.mediatailor.model.UpdateVodSourceResponse;
import software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable;
import software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable;
import software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable;
import software.amazon.awssdk.services.mediatailor.paginators.ListLiveSourcesIterable;
import software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable;
import software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable;
import software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable;
import software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable;

/**
 * Service client for accessing MediaTailor. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Use the AWS Elemental MediaTailor SDKs and CLI to configure scalable ad insertion and linear channels. With
 * MediaTailor, you can assemble existing content into a linear stream and serve targeted ads to viewers while
 * maintaining broadcast quality in over-the-top (OTT) video applications. For information about using the service,
 * including detailed information about the settings covered in this guide, see the <a
 * href="https://docs.aws.amazon.com/mediatailor/latest/ug/">AWS Elemental MediaTailor User Guide</a>.
 * </p>
 * <p>
 * Through the SDKs and the CLI you manage AWS Elemental MediaTailor configurations and channels the same as you do
 * through the console. For example, you specify ad insertion behavior and mapping information for the origin server and
 * the ad decision server (ADS).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MediaTailorClient extends AwsClient {
    String SERVICE_NAME = "mediatailor";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.mediatailor";

    /**
     * <p>
     * Configures Amazon CloudWatch log settings for a channel.
     * </p>
     *
     * @param configureLogsForChannelRequest
     * @return Result of the ConfigureLogsForChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ConfigureLogsForChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ConfigureLogsForChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfigureLogsForChannelResponse configureLogsForChannel(ConfigureLogsForChannelRequest configureLogsForChannelRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures Amazon CloudWatch log settings for a channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfigureLogsForChannelRequest.Builder} avoiding
     * the need to create one manually via {@link ConfigureLogsForChannelRequest#builder()}
     * </p>
     *
     * @param configureLogsForChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForChannelRequest.Builder} to create
     *        a request.
     * @return Result of the ConfigureLogsForChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ConfigureLogsForChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ConfigureLogsForChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfigureLogsForChannelResponse configureLogsForChannel(
            Consumer<ConfigureLogsForChannelRequest.Builder> configureLogsForChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return configureLogsForChannel(ConfigureLogsForChannelRequest.builder().applyMutation(configureLogsForChannelRequest)
                .build());
    }

    /**
     * <p>
     * Defines where AWS Elemental MediaTailor sends logs for the playback configuration.
     * </p>
     *
     * @param configureLogsForPlaybackConfigurationRequest
     *        Configures Amazon CloudWatch log settings for a playback configuration.
     * @return Result of the ConfigureLogsForPlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ConfigureLogsForPlaybackConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ConfigureLogsForPlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfigureLogsForPlaybackConfigurationResponse configureLogsForPlaybackConfiguration(
            ConfigureLogsForPlaybackConfigurationRequest configureLogsForPlaybackConfigurationRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines where AWS Elemental MediaTailor sends logs for the playback configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ConfigureLogsForPlaybackConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link ConfigureLogsForPlaybackConfigurationRequest#builder()}
     * </p>
     *
     * @param configureLogsForPlaybackConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest.Builder}
     *        to create a request. Configures Amazon CloudWatch log settings for a playback configuration.
     * @return Result of the ConfigureLogsForPlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ConfigureLogsForPlaybackConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ConfigureLogsForPlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfigureLogsForPlaybackConfigurationResponse configureLogsForPlaybackConfiguration(
            Consumer<ConfigureLogsForPlaybackConfigurationRequest.Builder> configureLogsForPlaybackConfigurationRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return configureLogsForPlaybackConfiguration(ConfigureLogsForPlaybackConfigurationRequest.builder()
                .applyMutation(configureLogsForPlaybackConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a channel. For information about MediaTailor channels, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param createChannelRequest
     * @return Result of the CreateChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a channel. For information about MediaTailor channels, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateChannelRequest#builder()}
     * </p>
     *
     * @param createChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.CreateChannelRequest.Builder} to create a
     *        request.
     * @return Result of the CreateChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateChannelResponse createChannel(Consumer<CreateChannelRequest.Builder> createChannelRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return createChannel(CreateChannelRequest.builder().applyMutation(createChannelRequest).build());
    }

    /**
     * <p>
     * The live source configuration.
     * </p>
     *
     * @param createLiveSourceRequest
     * @return Result of the CreateLiveSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateLiveSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateLiveSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLiveSourceResponse createLiveSource(CreateLiveSourceRequest createLiveSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The live source configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLiveSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLiveSourceRequest#builder()}
     * </p>
     *
     * @param createLiveSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.CreateLiveSourceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLiveSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateLiveSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateLiveSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLiveSourceResponse createLiveSource(Consumer<CreateLiveSourceRequest.Builder> createLiveSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return createLiveSource(CreateLiveSourceRequest.builder().applyMutation(createLiveSourceRequest).build());
    }

    /**
     * <p>
     * Creates a prefetch schedule for a playback configuration. A prefetch schedule allows you to tell MediaTailor to
     * fetch and prepare certain ads before an ad break happens. For more information about ad prefetching, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Using ad prefetching</a> in the
     * <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param createPrefetchScheduleRequest
     * @return Result of the CreatePrefetchSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreatePrefetchSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreatePrefetchSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePrefetchScheduleResponse createPrefetchSchedule(CreatePrefetchScheduleRequest createPrefetchScheduleRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a prefetch schedule for a playback configuration. A prefetch schedule allows you to tell MediaTailor to
     * fetch and prepare certain ads before an ad break happens. For more information about ad prefetching, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Using ad prefetching</a> in the
     * <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePrefetchScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePrefetchScheduleRequest#builder()}
     * </p>
     *
     * @param createPrefetchScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleRequest.Builder} to create
     *        a request.
     * @return Result of the CreatePrefetchSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreatePrefetchSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreatePrefetchSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePrefetchScheduleResponse createPrefetchSchedule(
            Consumer<CreatePrefetchScheduleRequest.Builder> createPrefetchScheduleRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return createPrefetchSchedule(CreatePrefetchScheduleRequest.builder().applyMutation(createPrefetchScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Creates a program within a channel. For information about programs, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html">Working with programs</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param createProgramRequest
     * @return Result of the CreateProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateProgram" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProgramResponse createProgram(CreateProgramRequest createProgramRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a program within a channel. For information about programs, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html">Working with programs</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProgramRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProgramRequest#builder()}
     * </p>
     *
     * @param createProgramRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest.Builder} to create a
     *        request.
     * @return Result of the CreateProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateProgram" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProgramResponse createProgram(Consumer<CreateProgramRequest.Builder> createProgramRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return createProgram(CreateProgramRequest.builder().applyMutation(createProgramRequest).build());
    }

    /**
     * <p>
     * Creates a source location. A source location is a container for sources. For more information about source
     * locations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html">Working with
     * source locations</a> in the <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param createSourceLocationRequest
     * @return Result of the CreateSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSourceLocationResponse createSourceLocation(CreateSourceLocationRequest createSourceLocationRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a source location. A source location is a container for sources. For more information about source
     * locations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html">Working with
     * source locations</a> in the <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSourceLocationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSourceLocationRequest#builder()}
     * </p>
     *
     * @param createSourceLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSourceLocationResponse createSourceLocation(
            Consumer<CreateSourceLocationRequest.Builder> createSourceLocationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return createSourceLocation(CreateSourceLocationRequest.builder().applyMutation(createSourceLocationRequest).build());
    }

    /**
     * <p>
     * The VOD source configuration parameters.
     * </p>
     *
     * @param createVodSourceRequest
     * @return Result of the CreateVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVodSourceResponse createVodSource(CreateVodSourceRequest createVodSourceRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The VOD source configuration parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVodSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVodSourceRequest#builder()}
     * </p>
     *
     * @param createVodSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.CreateVodSourceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVodSourceResponse createVodSource(Consumer<CreateVodSourceRequest.Builder> createVodSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return createVodSource(CreateVodSourceRequest.builder().applyMutation(createVodSourceRequest).build());
    }

    /**
     * <p>
     * Deletes a channel. For information about MediaTailor channels, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param deleteChannelRequest
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a channel. For information about MediaTailor channels, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteChannelRequest#builder()}
     * </p>
     *
     * @param deleteChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.DeleteChannelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteChannelResponse deleteChannel(Consumer<DeleteChannelRequest.Builder> deleteChannelRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return deleteChannel(DeleteChannelRequest.builder().applyMutation(deleteChannelRequest).build());
    }

    /**
     * <p>
     * The channel policy to delete.
     * </p>
     *
     * @param deleteChannelPolicyRequest
     * @return Result of the DeleteChannelPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChannelPolicyResponse deleteChannelPolicy(DeleteChannelPolicyRequest deleteChannelPolicyRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The channel policy to delete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteChannelPolicyRequest#builder()}
     * </p>
     *
     * @param deleteChannelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.DeleteChannelPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteChannelPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChannelPolicyResponse deleteChannelPolicy(
            Consumer<DeleteChannelPolicyRequest.Builder> deleteChannelPolicyRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return deleteChannelPolicy(DeleteChannelPolicyRequest.builder().applyMutation(deleteChannelPolicyRequest).build());
    }

    /**
     * <p>
     * The live source to delete.
     * </p>
     *
     * @param deleteLiveSourceRequest
     * @return Result of the DeleteLiveSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteLiveSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteLiveSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteLiveSourceResponse deleteLiveSource(DeleteLiveSourceRequest deleteLiveSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The live source to delete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLiveSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteLiveSourceRequest#builder()}
     * </p>
     *
     * @param deleteLiveSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.DeleteLiveSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLiveSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteLiveSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteLiveSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteLiveSourceResponse deleteLiveSource(Consumer<DeleteLiveSourceRequest.Builder> deleteLiveSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return deleteLiveSource(DeleteLiveSourceRequest.builder().applyMutation(deleteLiveSourceRequest).build());
    }

    /**
     * <p>
     * Deletes a playback configuration. For information about MediaTailor configurations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with configurations in AWS
     * Elemental MediaTailor</a>.
     * </p>
     *
     * @param deletePlaybackConfigurationRequest
     * @return Result of the DeletePlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeletePlaybackConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeletePlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePlaybackConfigurationResponse deletePlaybackConfiguration(
            DeletePlaybackConfigurationRequest deletePlaybackConfigurationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a playback configuration. For information about MediaTailor configurations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with configurations in AWS
     * Elemental MediaTailor</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePlaybackConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePlaybackConfigurationRequest#builder()}
     * </p>
     *
     * @param deletePlaybackConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.DeletePlaybackConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeletePlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeletePlaybackConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeletePlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePlaybackConfigurationResponse deletePlaybackConfiguration(
            Consumer<DeletePlaybackConfigurationRequest.Builder> deletePlaybackConfigurationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return deletePlaybackConfiguration(DeletePlaybackConfigurationRequest.builder()
                .applyMutation(deletePlaybackConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a prefetch schedule for a specific playback configuration. If you call
     * <code>DeletePrefetchSchedule</code> on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     * For more information about ad prefetching, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Using ad prefetching</a> in the
     * <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param deletePrefetchScheduleRequest
     * @return Result of the DeletePrefetchSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeletePrefetchSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeletePrefetchSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePrefetchScheduleResponse deletePrefetchSchedule(DeletePrefetchScheduleRequest deletePrefetchScheduleRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a prefetch schedule for a specific playback configuration. If you call
     * <code>DeletePrefetchSchedule</code> on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     * For more information about ad prefetching, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Using ad prefetching</a> in the
     * <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePrefetchScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePrefetchScheduleRequest#builder()}
     * </p>
     *
     * @param deletePrefetchScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.DeletePrefetchScheduleRequest.Builder} to create
     *        a request.
     * @return Result of the DeletePrefetchSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeletePrefetchSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeletePrefetchSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePrefetchScheduleResponse deletePrefetchSchedule(
            Consumer<DeletePrefetchScheduleRequest.Builder> deletePrefetchScheduleRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return deletePrefetchSchedule(DeletePrefetchScheduleRequest.builder().applyMutation(deletePrefetchScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a program within a channel. For information about programs, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html">Working with programs</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param deleteProgramRequest
     * @return Result of the DeleteProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteProgram" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProgramResponse deleteProgram(DeleteProgramRequest deleteProgramRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a program within a channel. For information about programs, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html">Working with programs</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProgramRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProgramRequest#builder()}
     * </p>
     *
     * @param deleteProgramRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.DeleteProgramRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteProgram" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProgramResponse deleteProgram(Consumer<DeleteProgramRequest.Builder> deleteProgramRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return deleteProgram(DeleteProgramRequest.builder().applyMutation(deleteProgramRequest).build());
    }

    /**
     * <p>
     * Deletes a source location. A source location is a container for sources. For more information about source
     * locations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html">Working with
     * source locations</a> in the <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param deleteSourceLocationRequest
     * @return Result of the DeleteSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSourceLocationResponse deleteSourceLocation(DeleteSourceLocationRequest deleteSourceLocationRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a source location. A source location is a container for sources. For more information about source
     * locations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html">Working with
     * source locations</a> in the <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSourceLocationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSourceLocationRequest#builder()}
     * </p>
     *
     * @param deleteSourceLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.DeleteSourceLocationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSourceLocationResponse deleteSourceLocation(
            Consumer<DeleteSourceLocationRequest.Builder> deleteSourceLocationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return deleteSourceLocation(DeleteSourceLocationRequest.builder().applyMutation(deleteSourceLocationRequest).build());
    }

    /**
     * <p>
     * The video on demand (VOD) source to delete.
     * </p>
     *
     * @param deleteVodSourceRequest
     * @return Result of the DeleteVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVodSourceResponse deleteVodSource(DeleteVodSourceRequest deleteVodSourceRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The video on demand (VOD) source to delete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVodSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVodSourceRequest#builder()}
     * </p>
     *
     * @param deleteVodSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.DeleteVodSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVodSourceResponse deleteVodSource(Consumer<DeleteVodSourceRequest.Builder> deleteVodSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return deleteVodSource(DeleteVodSourceRequest.builder().applyMutation(deleteVodSourceRequest).build());
    }

    /**
     * <p>
     * Describes a channel. For information about MediaTailor channels, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param describeChannelRequest
     * @return Result of the DescribeChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeChannelResponse describeChannel(DescribeChannelRequest describeChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a channel. For information about MediaTailor channels, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChannelRequest#builder()}
     * </p>
     *
     * @param describeChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.DescribeChannelRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeChannelResponse describeChannel(Consumer<DescribeChannelRequest.Builder> describeChannelRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return describeChannel(DescribeChannelRequest.builder().applyMutation(describeChannelRequest).build());
    }

    /**
     * <p>
     * The live source to describe.
     * </p>
     *
     * @param describeLiveSourceRequest
     * @return Result of the DescribeLiveSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeLiveSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeLiveSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLiveSourceResponse describeLiveSource(DescribeLiveSourceRequest describeLiveSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The live source to describe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLiveSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLiveSourceRequest#builder()}
     * </p>
     *
     * @param describeLiveSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.DescribeLiveSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLiveSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeLiveSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeLiveSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLiveSourceResponse describeLiveSource(Consumer<DescribeLiveSourceRequest.Builder> describeLiveSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return describeLiveSource(DescribeLiveSourceRequest.builder().applyMutation(describeLiveSourceRequest).build());
    }

    /**
     * <p>
     * Describes a program within a channel. For information about programs, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html">Working with programs</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param describeProgramRequest
     * @return Result of the DescribeProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeProgram" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProgramResponse describeProgram(DescribeProgramRequest describeProgramRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a program within a channel. For information about programs, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-programs.html">Working with programs</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProgramRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProgramRequest#builder()}
     * </p>
     *
     * @param describeProgramRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.DescribeProgramRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeProgram" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProgramResponse describeProgram(Consumer<DescribeProgramRequest.Builder> describeProgramRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return describeProgram(DescribeProgramRequest.builder().applyMutation(describeProgramRequest).build());
    }

    /**
     * <p>
     * Describes a source location. A source location is a container for sources. For more information about source
     * locations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html">Working with
     * source locations</a> in the <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param describeSourceLocationRequest
     * @return Result of the DescribeSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSourceLocationResponse describeSourceLocation(DescribeSourceLocationRequest describeSourceLocationRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a source location. A source location is a container for sources. For more information about source
     * locations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html">Working with
     * source locations</a> in the <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSourceLocationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSourceLocationRequest#builder()}
     * </p>
     *
     * @param describeSourceLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.DescribeSourceLocationRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSourceLocationResponse describeSourceLocation(
            Consumer<DescribeSourceLocationRequest.Builder> describeSourceLocationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return describeSourceLocation(DescribeSourceLocationRequest.builder().applyMutation(describeSourceLocationRequest)
                .build());
    }

    /**
     * <p>
     * Provides details about a specific video on demand (VOD) source in a specific source location.
     * </p>
     *
     * @param describeVodSourceRequest
     * @return Result of the DescribeVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVodSourceResponse describeVodSource(DescribeVodSourceRequest describeVodSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about a specific video on demand (VOD) source in a specific source location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVodSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeVodSourceRequest#builder()}
     * </p>
     *
     * @param describeVodSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.DescribeVodSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVodSourceResponse describeVodSource(Consumer<DescribeVodSourceRequest.Builder> describeVodSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return describeVodSource(DescribeVodSourceRequest.builder().applyMutation(describeVodSourceRequest).build());
    }

    /**
     * <p>
     * Returns the channel's IAM policy. IAM policies are used to control access to your channel.
     * </p>
     *
     * @param getChannelPolicyRequest
     * @return Result of the GetChannelPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetChannelPolicyResponse getChannelPolicy(GetChannelPolicyRequest getChannelPolicyRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the channel's IAM policy. IAM policies are used to control access to your channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetChannelPolicyRequest#builder()}
     * </p>
     *
     * @param getChannelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.GetChannelPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetChannelPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetChannelPolicyResponse getChannelPolicy(Consumer<GetChannelPolicyRequest.Builder> getChannelPolicyRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return getChannelPolicy(GetChannelPolicyRequest.builder().applyMutation(getChannelPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about your channel's schedule.
     * </p>
     *
     * @param getChannelScheduleRequest
     * @return Result of the GetChannelSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetChannelSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChannelScheduleResponse getChannelSchedule(GetChannelScheduleRequest getChannelScheduleRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about your channel's schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link GetChannelScheduleRequest#builder()}
     * </p>
     *
     * @param getChannelScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest.Builder} to create a
     *        request.
     * @return Result of the GetChannelSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetChannelSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChannelScheduleResponse getChannelSchedule(Consumer<GetChannelScheduleRequest.Builder> getChannelScheduleRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return getChannelSchedule(GetChannelScheduleRequest.builder().applyMutation(getChannelScheduleRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getChannelSchedule(software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable responses = client.getChannelSchedulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable responses = client
     *             .getChannelSchedulePaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable responses = client.getChannelSchedulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getChannelSchedule(software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest)}
     * operation.</b>
     * </p>
     *
     * @param getChannelScheduleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetChannelSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChannelScheduleIterable getChannelSchedulePaginator(GetChannelScheduleRequest getChannelScheduleRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return new GetChannelScheduleIterable(this, getChannelScheduleRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getChannelSchedule(software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable responses = client.getChannelSchedulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable responses = client
     *             .getChannelSchedulePaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable responses = client.getChannelSchedulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getChannelSchedule(software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link GetChannelScheduleRequest#builder()}
     * </p>
     *
     * @param getChannelScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetChannelSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChannelScheduleIterable getChannelSchedulePaginator(
            Consumer<GetChannelScheduleRequest.Builder> getChannelScheduleRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return getChannelSchedulePaginator(GetChannelScheduleRequest.builder().applyMutation(getChannelScheduleRequest).build());
    }

    /**
     * <p>
     * Retrieves a playback configuration. For information about MediaTailor configurations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with configurations in AWS
     * Elemental MediaTailor</a>.
     * </p>
     *
     * @param getPlaybackConfigurationRequest
     * @return Result of the GetPlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetPlaybackConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetPlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPlaybackConfigurationResponse getPlaybackConfiguration(
            GetPlaybackConfigurationRequest getPlaybackConfigurationRequest) throws AwsServiceException, SdkClientException,
            MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a playback configuration. For information about MediaTailor configurations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with configurations in AWS
     * Elemental MediaTailor</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlaybackConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetPlaybackConfigurationRequest#builder()}
     * </p>
     *
     * @param getPlaybackConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.GetPlaybackConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the GetPlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetPlaybackConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetPlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPlaybackConfigurationResponse getPlaybackConfiguration(
            Consumer<GetPlaybackConfigurationRequest.Builder> getPlaybackConfigurationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return getPlaybackConfiguration(GetPlaybackConfigurationRequest.builder().applyMutation(getPlaybackConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a prefetch schedule for a playback configuration. A prefetch schedule allows you to tell MediaTailor to
     * fetch and prepare certain ads before an ad break happens. For more information about ad prefetching, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Using ad prefetching</a> in the
     * <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param getPrefetchScheduleRequest
     * @return Result of the GetPrefetchSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetPrefetchSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetPrefetchSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPrefetchScheduleResponse getPrefetchSchedule(GetPrefetchScheduleRequest getPrefetchScheduleRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a prefetch schedule for a playback configuration. A prefetch schedule allows you to tell MediaTailor to
     * fetch and prepare certain ads before an ad break happens. For more information about ad prefetching, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Using ad prefetching</a> in the
     * <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPrefetchScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link GetPrefetchScheduleRequest#builder()}
     * </p>
     *
     * @param getPrefetchScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.GetPrefetchScheduleRequest.Builder} to create a
     *        request.
     * @return Result of the GetPrefetchSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetPrefetchSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetPrefetchSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPrefetchScheduleResponse getPrefetchSchedule(
            Consumer<GetPrefetchScheduleRequest.Builder> getPrefetchScheduleRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return getPrefetchSchedule(GetPrefetchScheduleRequest.builder().applyMutation(getPrefetchScheduleRequest).build());
    }

    /**
     * <p>
     * Lists the alerts that are associated with a MediaTailor channel assembly resource.
     * </p>
     *
     * @param listAlertsRequest
     * @return Result of the ListAlerts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsResponse listAlerts(ListAlertsRequest listAlertsRequest) throws AwsServiceException, SdkClientException,
            MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the alerts that are associated with a MediaTailor channel assembly resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlertsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAlertsRequest#builder()}
     * </p>
     *
     * @param listAlertsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest.Builder} to create a request.
     * @return Result of the ListAlerts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsResponse listAlerts(Consumer<ListAlertsRequest.Builder> listAlertsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listAlerts(ListAlertsRequest.builder().applyMutation(listAlertsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAlerts(software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListAlertsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlerts(software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest)} operation.</b>
     * </p>
     *
     * @param listAlertsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsIterable listAlertsPaginator(ListAlertsRequest listAlertsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return new ListAlertsIterable(this, listAlertsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAlerts(software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListAlertsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlerts(software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlertsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAlertsRequest#builder()}
     * </p>
     *
     * @param listAlertsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsIterable listAlertsPaginator(Consumer<ListAlertsRequest.Builder> listAlertsRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return listAlertsPaginator(ListAlertsRequest.builder().applyMutation(listAlertsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the channels that are associated with the current AWS account.
     * </p>
     *
     * @param listChannelsRequest
     * @return Result of the ListChannels operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the channels that are associated with the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest.Builder} to create a request.
     * @return Result of the ListChannels operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsResponse listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(ListChannelsRequest listChannelsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return new ListChannelsIterable(this, listChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Lists the live sources contained in a source location. A source represents a piece of content.
     * </p>
     *
     * @param listLiveSourcesRequest
     * @return Result of the ListLiveSources operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListLiveSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListLiveSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLiveSourcesResponse listLiveSources(ListLiveSourcesRequest listLiveSourcesRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the live sources contained in a source location. A source represents a piece of content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLiveSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListLiveSourcesRequest#builder()}
     * </p>
     *
     * @param listLiveSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesRequest.Builder} to create a
     *        request.
     * @return Result of the ListLiveSources operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListLiveSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListLiveSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLiveSourcesResponse listLiveSources(Consumer<ListLiveSourcesRequest.Builder> listLiveSourcesRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return listLiveSources(ListLiveSourcesRequest.builder().applyMutation(listLiveSourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLiveSources(software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListLiveSourcesIterable responses = client.listLiveSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListLiveSourcesIterable responses = client
     *             .listLiveSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListLiveSourcesIterable responses = client.listLiveSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLiveSources(software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listLiveSourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListLiveSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListLiveSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLiveSourcesIterable listLiveSourcesPaginator(ListLiveSourcesRequest listLiveSourcesRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return new ListLiveSourcesIterable(this, listLiveSourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLiveSources(software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListLiveSourcesIterable responses = client.listLiveSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListLiveSourcesIterable responses = client
     *             .listLiveSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListLiveSourcesIterable responses = client.listLiveSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLiveSources(software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLiveSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListLiveSourcesRequest#builder()}
     * </p>
     *
     * @param listLiveSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListLiveSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListLiveSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLiveSourcesIterable listLiveSourcesPaginator(Consumer<ListLiveSourcesRequest.Builder> listLiveSourcesRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return listLiveSourcesPaginator(ListLiveSourcesRequest.builder().applyMutation(listLiveSourcesRequest).build());
    }

    /**
     * <p>
     * Retrieves existing playback configurations. For information about MediaTailor configurations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with Configurations in AWS
     * Elemental MediaTailor</a>.
     * </p>
     *
     * @param listPlaybackConfigurationsRequest
     * @return Result of the ListPlaybackConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPlaybackConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackConfigurationsResponse listPlaybackConfigurations(
            ListPlaybackConfigurationsRequest listPlaybackConfigurationsRequest) throws AwsServiceException, SdkClientException,
            MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves existing playback configurations. For information about MediaTailor configurations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with Configurations in AWS
     * Elemental MediaTailor</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlaybackConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPlaybackConfigurationsRequest#builder()}
     * </p>
     *
     * @param listPlaybackConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListPlaybackConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPlaybackConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackConfigurationsResponse listPlaybackConfigurations(
            Consumer<ListPlaybackConfigurationsRequest.Builder> listPlaybackConfigurationsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listPlaybackConfigurations(ListPlaybackConfigurationsRequest.builder()
                .applyMutation(listPlaybackConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves existing playback configurations. For information about MediaTailor configurations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with Configurations in AWS
     * Elemental MediaTailor</a>.
     * </p>
     *
     * @return Result of the ListPlaybackConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPlaybackConfigurations
     * @see #listPlaybackConfigurations(ListPlaybackConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackConfigurationsResponse listPlaybackConfigurations() throws AwsServiceException, SdkClientException,
            MediaTailorException {
        return listPlaybackConfigurations(ListPlaybackConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlaybackConfigurations(software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client.listPlaybackConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client
     *             .listPlaybackConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client.listPlaybackConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaybackConfigurations(software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPlaybackConfigurations
     * @see #listPlaybackConfigurationsPaginator(ListPlaybackConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackConfigurationsIterable listPlaybackConfigurationsPaginator() throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listPlaybackConfigurationsPaginator(ListPlaybackConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlaybackConfigurations(software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client.listPlaybackConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client
     *             .listPlaybackConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client.listPlaybackConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaybackConfigurations(software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlaybackConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPlaybackConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackConfigurationsIterable listPlaybackConfigurationsPaginator(
            ListPlaybackConfigurationsRequest listPlaybackConfigurationsRequest) throws AwsServiceException, SdkClientException,
            MediaTailorException {
        return new ListPlaybackConfigurationsIterable(this, listPlaybackConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlaybackConfigurations(software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client.listPlaybackConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client
     *             .listPlaybackConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client.listPlaybackConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaybackConfigurations(software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlaybackConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPlaybackConfigurationsRequest#builder()}
     * </p>
     *
     * @param listPlaybackConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPlaybackConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackConfigurationsIterable listPlaybackConfigurationsPaginator(
            Consumer<ListPlaybackConfigurationsRequest.Builder> listPlaybackConfigurationsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listPlaybackConfigurationsPaginator(ListPlaybackConfigurationsRequest.builder()
                .applyMutation(listPlaybackConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists the prefetch schedules for a playback configuration.
     * </p>
     *
     * @param listPrefetchSchedulesRequest
     * @return Result of the ListPrefetchSchedules operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPrefetchSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPrefetchSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrefetchSchedulesResponse listPrefetchSchedules(ListPrefetchSchedulesRequest listPrefetchSchedulesRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the prefetch schedules for a playback configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrefetchSchedulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListPrefetchSchedulesRequest#builder()}
     * </p>
     *
     * @param listPrefetchSchedulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest.Builder} to create a
     *        request.
     * @return Result of the ListPrefetchSchedules operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPrefetchSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPrefetchSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrefetchSchedulesResponse listPrefetchSchedules(
            Consumer<ListPrefetchSchedulesRequest.Builder> listPrefetchSchedulesRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listPrefetchSchedules(ListPrefetchSchedulesRequest.builder().applyMutation(listPrefetchSchedulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPrefetchSchedules(software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable responses = client.listPrefetchSchedulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable responses = client
     *             .listPrefetchSchedulesPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable responses = client.listPrefetchSchedulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrefetchSchedules(software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPrefetchSchedulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPrefetchSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPrefetchSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrefetchSchedulesIterable listPrefetchSchedulesPaginator(ListPrefetchSchedulesRequest listPrefetchSchedulesRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return new ListPrefetchSchedulesIterable(this, listPrefetchSchedulesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPrefetchSchedules(software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable responses = client.listPrefetchSchedulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable responses = client
     *             .listPrefetchSchedulesPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable responses = client.listPrefetchSchedulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrefetchSchedules(software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrefetchSchedulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListPrefetchSchedulesRequest#builder()}
     * </p>
     *
     * @param listPrefetchSchedulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPrefetchSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPrefetchSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrefetchSchedulesIterable listPrefetchSchedulesPaginator(
            Consumer<ListPrefetchSchedulesRequest.Builder> listPrefetchSchedulesRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listPrefetchSchedulesPaginator(ListPrefetchSchedulesRequest.builder().applyMutation(listPrefetchSchedulesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the source locations for a channel. A source location defines the host server URL, and contains a list of
     * sources.
     * </p>
     *
     * @param listSourceLocationsRequest
     * @return Result of the ListSourceLocations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListSourceLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListSourceLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceLocationsResponse listSourceLocations(ListSourceLocationsRequest listSourceLocationsRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the source locations for a channel. A source location defines the host server URL, and contains a list of
     * sources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceLocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSourceLocationsRequest#builder()}
     * </p>
     *
     * @param listSourceLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSourceLocations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListSourceLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListSourceLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceLocationsResponse listSourceLocations(
            Consumer<ListSourceLocationsRequest.Builder> listSourceLocationsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listSourceLocations(ListSourceLocationsRequest.builder().applyMutation(listSourceLocationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSourceLocations(software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable responses = client.listSourceLocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable responses = client
     *             .listSourceLocationsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable responses = client.listSourceLocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceLocations(software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSourceLocationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListSourceLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListSourceLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceLocationsIterable listSourceLocationsPaginator(ListSourceLocationsRequest listSourceLocationsRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return new ListSourceLocationsIterable(this, listSourceLocationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSourceLocations(software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable responses = client.listSourceLocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable responses = client
     *             .listSourceLocationsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable responses = client.listSourceLocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceLocations(software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceLocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSourceLocationsRequest#builder()}
     * </p>
     *
     * @param listSourceLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListSourceLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListSourceLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceLocationsIterable listSourceLocationsPaginator(
            Consumer<ListSourceLocationsRequest.Builder> listSourceLocationsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listSourceLocationsPaginator(ListSourceLocationsRequest.builder().applyMutation(listSourceLocationsRequest)
                .build());
    }

    /**
     * <p>
     * A list of tags that are associated with this resource. Tags are key-value pairs that you can associate with
     * Amazon resources to help with organization, access control, and cost tracking. For more information, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     * Resources</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of tags that are associated with this resource. Tags are key-value pairs that you can associate with
     * Amazon resources to help with organization, access control, and cost tracking. For more information, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     * Resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, MediaTailorException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the VOD sources contained in a source location. A source represents a piece of content.
     * </p>
     *
     * @param listVodSourcesRequest
     * @return Result of the ListVodSources operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListVodSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListVodSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVodSourcesResponse listVodSources(ListVodSourcesRequest listVodSourcesRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the VOD sources contained in a source location. A source represents a piece of content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVodSourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListVodSourcesRequest#builder()}
     * </p>
     *
     * @param listVodSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest.Builder} to create a
     *        request.
     * @return Result of the ListVodSources operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListVodSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListVodSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVodSourcesResponse listVodSources(Consumer<ListVodSourcesRequest.Builder> listVodSourcesRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return listVodSources(ListVodSourcesRequest.builder().applyMutation(listVodSourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVodSources(software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable responses = client.listVodSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable responses = client
     *             .listVodSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListVodSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable responses = client.listVodSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVodSources(software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listVodSourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListVodSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListVodSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVodSourcesIterable listVodSourcesPaginator(ListVodSourcesRequest listVodSourcesRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return new ListVodSourcesIterable(this, listVodSourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVodSources(software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable responses = client.listVodSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable responses = client
     *             .listVodSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListVodSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable responses = client.listVodSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVodSources(software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVodSourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListVodSourcesRequest#builder()}
     * </p>
     *
     * @param listVodSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListVodSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListVodSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVodSourcesIterable listVodSourcesPaginator(Consumer<ListVodSourcesRequest.Builder> listVodSourcesRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return listVodSourcesPaginator(ListVodSourcesRequest.builder().applyMutation(listVodSourcesRequest).build());
    }

    /**
     * <p>
     * Creates an IAM policy for the channel. IAM policies are used to control access to your channel.
     * </p>
     *
     * @param putChannelPolicyRequest
     * @return Result of the PutChannelPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.PutChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/PutChannelPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutChannelPolicyResponse putChannelPolicy(PutChannelPolicyRequest putChannelPolicyRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IAM policy for the channel. IAM policies are used to control access to your channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutChannelPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutChannelPolicyRequest#builder()}
     * </p>
     *
     * @param putChannelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.PutChannelPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutChannelPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.PutChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/PutChannelPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutChannelPolicyResponse putChannelPolicy(Consumer<PutChannelPolicyRequest.Builder> putChannelPolicyRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return putChannelPolicy(PutChannelPolicyRequest.builder().applyMutation(putChannelPolicyRequest).build());
    }

    /**
     * <p>
     * Creates a playback configuration. For information about MediaTailor configurations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with configurations in AWS
     * Elemental MediaTailor</a>.
     * </p>
     *
     * @param putPlaybackConfigurationRequest
     * @return Result of the PutPlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.PutPlaybackConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/PutPlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutPlaybackConfigurationResponse putPlaybackConfiguration(
            PutPlaybackConfigurationRequest putPlaybackConfigurationRequest) throws AwsServiceException, SdkClientException,
            MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a playback configuration. For information about MediaTailor configurations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/configurations.html">Working with configurations in AWS
     * Elemental MediaTailor</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPlaybackConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutPlaybackConfigurationRequest#builder()}
     * </p>
     *
     * @param putPlaybackConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the PutPlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.PutPlaybackConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/PutPlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutPlaybackConfigurationResponse putPlaybackConfiguration(
            Consumer<PutPlaybackConfigurationRequest.Builder> putPlaybackConfigurationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return putPlaybackConfiguration(PutPlaybackConfigurationRequest.builder().applyMutation(putPlaybackConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Starts a channel. For information about MediaTailor channels, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param startChannelRequest
     * @return Result of the StartChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.StartChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StartChannelResponse startChannel(StartChannelRequest startChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a channel. For information about MediaTailor channels, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartChannelRequest.Builder} avoiding the need to
     * create one manually via {@link StartChannelRequest#builder()}
     * </p>
     *
     * @param startChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.StartChannelRequest.Builder} to create a request.
     * @return Result of the StartChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.StartChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StartChannelResponse startChannel(Consumer<StartChannelRequest.Builder> startChannelRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return startChannel(StartChannelRequest.builder().applyMutation(startChannelRequest).build());
    }

    /**
     * <p>
     * Stops a channel. For information about MediaTailor channels, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param stopChannelRequest
     * @return Result of the StopChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.StopChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StopChannelResponse stopChannel(StopChannelRequest stopChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a channel. For information about MediaTailor channels, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopChannelRequest.Builder} avoiding the need to
     * create one manually via {@link StopChannelRequest#builder()}
     * </p>
     *
     * @param stopChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.StopChannelRequest.Builder} to create a request.
     * @return Result of the StopChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.StopChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StopChannelResponse stopChannel(Consumer<StopChannelRequest.Builder> stopChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return stopChannel(StopChannelRequest.builder().applyMutation(stopChannelRequest).build());
    }

    /**
     * <p>
     * The resource to tag. Tags are key-value pairs that you can associate with Amazon resources to help with
     * organization, access control, and cost tracking. For more information, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     * Resources</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The resource to tag. Tags are key-value pairs that you can associate with Amazon resources to help with
     * organization, access control, and cost tracking. For more information, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     * Resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, MediaTailorException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * The resource to untag.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The resource to untag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         A request contains unexpected data.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, MediaTailorException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a channel. For information about MediaTailor channels, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param updateChannelRequest
     * @return Result of the UpdateChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateChannelResponse updateChannel(UpdateChannelRequest updateChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a channel. For information about MediaTailor channels, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-channels.html">Working with channels</a>
     * in the <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateChannelRequest#builder()}
     * </p>
     *
     * @param updateChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateChannelResponse updateChannel(Consumer<UpdateChannelRequest.Builder> updateChannelRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return updateChannel(UpdateChannelRequest.builder().applyMutation(updateChannelRequest).build());
    }

    /**
     * <p>
     * Updates a live source's configuration.
     * </p>
     *
     * @param updateLiveSourceRequest
     * @return Result of the UpdateLiveSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateLiveSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateLiveSource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLiveSourceResponse updateLiveSource(UpdateLiveSourceRequest updateLiveSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a live source's configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLiveSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLiveSourceRequest#builder()}
     * </p>
     *
     * @param updateLiveSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.UpdateLiveSourceRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLiveSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateLiveSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateLiveSource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLiveSourceResponse updateLiveSource(Consumer<UpdateLiveSourceRequest.Builder> updateLiveSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return updateLiveSource(UpdateLiveSourceRequest.builder().applyMutation(updateLiveSourceRequest).build());
    }

    /**
     * <p>
     * Updates a program within a channel.
     * </p>
     *
     * @param updateProgramRequest
     * @return Result of the UpdateProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateProgram" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProgramResponse updateProgram(UpdateProgramRequest updateProgramRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a program within a channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProgramRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProgramRequest#builder()}
     * </p>
     *
     * @param updateProgramRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.UpdateProgramRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateProgram" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProgramResponse updateProgram(Consumer<UpdateProgramRequest.Builder> updateProgramRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return updateProgram(UpdateProgramRequest.builder().applyMutation(updateProgramRequest).build());
    }

    /**
     * <p>
     * Updates a source location. A source location is a container for sources. For more information about source
     * locations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html">Working with
     * source locations</a> in the <i>MediaTailor User Guide</i>.
     * </p>
     *
     * @param updateSourceLocationRequest
     * @return Result of the UpdateSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSourceLocationResponse updateSourceLocation(UpdateSourceLocationRequest updateSourceLocationRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a source location. A source location is a container for sources. For more information about source
     * locations, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-source-locations.html">Working with
     * source locations</a> in the <i>MediaTailor User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSourceLocationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSourceLocationRequest#builder()}
     * </p>
     *
     * @param updateSourceLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.UpdateSourceLocationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSourceLocationResponse updateSourceLocation(
            Consumer<UpdateSourceLocationRequest.Builder> updateSourceLocationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return updateSourceLocation(UpdateSourceLocationRequest.builder().applyMutation(updateSourceLocationRequest).build());
    }

    /**
     * <p>
     * Updates a VOD source's configuration.
     * </p>
     *
     * @param updateVodSourceRequest
     * @return Result of the UpdateVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateVodSourceResponse updateVodSource(UpdateVodSourceRequest updateVodSourceRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a VOD source's configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVodSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateVodSourceRequest#builder()}
     * </p>
     *
     * @param updateVodSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediatailor.model.UpdateVodSourceRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateVodSourceResponse updateVodSource(Consumer<UpdateVodSourceRequest.Builder> updateVodSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return updateVodSource(UpdateVodSourceRequest.builder().applyMutation(updateVodSourceRequest).build());
    }

    /**
     * Create a {@link MediaTailorClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaTailorClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaTailorClient}.
     */
    static MediaTailorClientBuilder builder() {
        return new DefaultMediaTailorClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MediaTailorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
