/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLiveSourceRequest extends MediaTailorRequest implements
        ToCopyableBuilder<DeleteLiveSourceRequest.Builder, DeleteLiveSourceRequest> {
    private static final SdkField<String> LIVE_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LiveSourceName").getter(getter(DeleteLiveSourceRequest::liveSourceName))
            .setter(setter(Builder::liveSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("LiveSourceName").build()).build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(DeleteLiveSourceRequest::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SourceLocationName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIVE_SOURCE_NAME_FIELD,
            SOURCE_LOCATION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String liveSourceName;

    private final String sourceLocationName;

    private DeleteLiveSourceRequest(BuilderImpl builder) {
        super(builder);
        this.liveSourceName = builder.liveSourceName;
        this.sourceLocationName = builder.sourceLocationName;
    }

    /**
     * <p>
     * The name of the live source.
     * </p>
     * 
     * @return The name of the live source.
     */
    public final String liveSourceName() {
        return liveSourceName;
    }

    /**
     * <p>
     * The name of the source location associated with this Live Source.
     * </p>
     * 
     * @return The name of the source location associated with this Live Source.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(liveSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLiveSourceRequest)) {
            return false;
        }
        DeleteLiveSourceRequest other = (DeleteLiveSourceRequest) obj;
        return Objects.equals(liveSourceName(), other.liveSourceName())
                && Objects.equals(sourceLocationName(), other.sourceLocationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteLiveSourceRequest").add("LiveSourceName", liveSourceName())
                .add("SourceLocationName", sourceLocationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LiveSourceName":
            return Optional.ofNullable(clazz.cast(liveSourceName()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LiveSourceName", LIVE_SOURCE_NAME_FIELD);
        map.put("SourceLocationName", SOURCE_LOCATION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteLiveSourceRequest, T> g) {
        return obj -> g.apply((DeleteLiveSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteLiveSourceRequest> {
        /**
         * <p>
         * The name of the live source.
         * </p>
         * 
         * @param liveSourceName
         *        The name of the live source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder liveSourceName(String liveSourceName);

        /**
         * <p>
         * The name of the source location associated with this Live Source.
         * </p>
         * 
         * @param sourceLocationName
         *        The name of the source location associated with this Live Source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private String liveSourceName;

        private String sourceLocationName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLiveSourceRequest model) {
            super(model);
            liveSourceName(model.liveSourceName);
            sourceLocationName(model.sourceLocationName);
        }

        public final String getLiveSourceName() {
            return liveSourceName;
        }

        public final void setLiveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
        }

        @Override
        public final Builder liveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
            return this;
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLiveSourceRequest build() {
            return new DeleteLiveSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
