/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines where AWS Elemental MediaTailor sends logs for the playback configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LogConfiguration.Builder, LogConfiguration> {
    private static final SdkField<Integer> PERCENT_ENABLED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PercentEnabled").getter(getter(LogConfiguration::percentEnabled))
            .setter(setter(Builder::percentEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentEnabled").build()).build();

    private static final SdkField<List<String>> ENABLED_LOGGING_STRATEGIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledLoggingStrategies")
            .getter(getter(LogConfiguration::enabledLoggingStrategiesAsStrings))
            .setter(setter(Builder::enabledLoggingStrategiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledLoggingStrategies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENT_ENABLED_FIELD,
            ENABLED_LOGGING_STRATEGIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer percentEnabled;

    private final List<String> enabledLoggingStrategies;

    private LogConfiguration(BuilderImpl builder) {
        this.percentEnabled = builder.percentEnabled;
        this.enabledLoggingStrategies = builder.enabledLoggingStrategies;
    }

    /**
     * <p>
     * The percentage of session logs that MediaTailor sends to your configured log destination. For example, if your
     * playback configuration has 1000 sessions and <code>percentEnabled</code> is set to <code>60</code>, MediaTailor
     * sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of the playback
     * configuration sessions to send logs for. If you want to view logs for a specific session, you can use the <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html">debug log mode</a>.
     * </p>
     * <p>
     * Valid values: <code>0</code> - <code>100</code>
     * </p>
     * 
     * @return The percentage of session logs that MediaTailor sends to your configured log destination. For example, if
     *         your playback configuration has 1000 sessions and <code>percentEnabled</code> is set to <code>60</code>,
     *         MediaTailor sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of
     *         the playback configuration sessions to send logs for. If you want to view logs for a specific session,
     *         you can use the <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html">debug log
     *         mode</a>.</p>
     *         <p>
     *         Valid values: <code>0</code> - <code>100</code>
     */
    public final Integer percentEnabled() {
        return percentEnabled;
    }

    /**
     * <p>
     * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates that
     * MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
     * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
     * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledLoggingStrategies} method.
     * </p>
     * 
     * @return The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
     *         indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code>
     *         indicates that MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination
     *         of choice. Supported destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data
     *         Firehose stream.
     */
    public final List<LoggingStrategy> enabledLoggingStrategies() {
        return ___listOfLoggingStrategiesCopier.copyStringToEnum(enabledLoggingStrategies);
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledLoggingStrategies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnabledLoggingStrategies() {
        return enabledLoggingStrategies != null && !(enabledLoggingStrategies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates that
     * MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
     * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
     * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledLoggingStrategies} method.
     * </p>
     * 
     * @return The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
     *         indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code>
     *         indicates that MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination
     *         of choice. Supported destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data
     *         Firehose stream.
     */
    public final List<String> enabledLoggingStrategiesAsStrings() {
        return enabledLoggingStrategies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(percentEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledLoggingStrategies() ? enabledLoggingStrategiesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration other = (LogConfiguration) obj;
        return Objects.equals(percentEnabled(), other.percentEnabled())
                && hasEnabledLoggingStrategies() == other.hasEnabledLoggingStrategies()
                && Objects.equals(enabledLoggingStrategiesAsStrings(), other.enabledLoggingStrategiesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogConfiguration").add("PercentEnabled", percentEnabled())
                .add("EnabledLoggingStrategies", hasEnabledLoggingStrategies() ? enabledLoggingStrategiesAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PercentEnabled":
            return Optional.ofNullable(clazz.cast(percentEnabled()));
        case "EnabledLoggingStrategies":
            return Optional.ofNullable(clazz.cast(enabledLoggingStrategiesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PercentEnabled", PERCENT_ENABLED_FIELD);
        map.put("EnabledLoggingStrategies", ENABLED_LOGGING_STRATEGIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogConfiguration, T> g) {
        return obj -> g.apply((LogConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogConfiguration> {
        /**
         * <p>
         * The percentage of session logs that MediaTailor sends to your configured log destination. For example, if
         * your playback configuration has 1000 sessions and <code>percentEnabled</code> is set to <code>60</code>,
         * MediaTailor sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor decides at random which of the
         * playback configuration sessions to send logs for. If you want to view logs for a specific session, you can
         * use the <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html">debug log mode</a>.
         * </p>
         * <p>
         * Valid values: <code>0</code> - <code>100</code>
         * </p>
         * 
         * @param percentEnabled
         *        The percentage of session logs that MediaTailor sends to your configured log destination. For example,
         *        if your playback configuration has 1000 sessions and <code>percentEnabled</code> is set to
         *        <code>60</code>, MediaTailor sends logs for 600 of the sessions to CloudWatch Logs. MediaTailor
         *        decides at random which of the playback configuration sessions to send logs for. If you want to view
         *        logs for a specific session, you can use the <a
         *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/debug-log-mode.html">debug log mode</a>.</p>
         *        <p>
         *        Valid values: <code>0</code> - <code>100</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentEnabled(Integer percentEnabled);

        /**
         * <p>
         * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates
         * that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
         * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
         * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
         * </p>
         * 
         * @param enabledLoggingStrategies
         *        The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
         *        indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs.
         *        <code>VENDED_LOGS</code> indicates that MediaTailor is sending logs to CloudWatch, which then vends
         *        the logs to your destination of choice. Supported destinations are CloudWatch Logs log group, Amazon
         *        S3 bucket, and Amazon Data Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledLoggingStrategiesWithStrings(Collection<String> enabledLoggingStrategies);

        /**
         * <p>
         * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates
         * that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
         * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
         * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
         * </p>
         * 
         * @param enabledLoggingStrategies
         *        The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
         *        indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs.
         *        <code>VENDED_LOGS</code> indicates that MediaTailor is sending logs to CloudWatch, which then vends
         *        the logs to your destination of choice. Supported destinations are CloudWatch Logs log group, Amazon
         *        S3 bucket, and Amazon Data Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledLoggingStrategiesWithStrings(String... enabledLoggingStrategies);

        /**
         * <p>
         * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates
         * that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
         * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
         * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
         * </p>
         * 
         * @param enabledLoggingStrategies
         *        The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
         *        indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs.
         *        <code>VENDED_LOGS</code> indicates that MediaTailor is sending logs to CloudWatch, which then vends
         *        the logs to your destination of choice. Supported destinations are CloudWatch Logs log group, Amazon
         *        S3 bucket, and Amazon Data Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledLoggingStrategies(Collection<LoggingStrategy> enabledLoggingStrategies);

        /**
         * <p>
         * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates
         * that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
         * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
         * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
         * </p>
         * 
         * @param enabledLoggingStrategies
         *        The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
         *        indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs.
         *        <code>VENDED_LOGS</code> indicates that MediaTailor is sending logs to CloudWatch, which then vends
         *        the logs to your destination of choice. Supported destinations are CloudWatch Logs log group, Amazon
         *        S3 bucket, and Amazon Data Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledLoggingStrategies(LoggingStrategy... enabledLoggingStrategies);
    }

    static final class BuilderImpl implements Builder {
        private Integer percentEnabled;

        private List<String> enabledLoggingStrategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfiguration model) {
            percentEnabled(model.percentEnabled);
            enabledLoggingStrategiesWithStrings(model.enabledLoggingStrategies);
        }

        public final Integer getPercentEnabled() {
            return percentEnabled;
        }

        public final void setPercentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
        }

        @Override
        public final Builder percentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
            return this;
        }

        public final Collection<String> getEnabledLoggingStrategies() {
            if (enabledLoggingStrategies instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledLoggingStrategies;
        }

        public final void setEnabledLoggingStrategies(Collection<String> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copy(enabledLoggingStrategies);
        }

        @Override
        public final Builder enabledLoggingStrategiesWithStrings(Collection<String> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copy(enabledLoggingStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledLoggingStrategiesWithStrings(String... enabledLoggingStrategies) {
            enabledLoggingStrategiesWithStrings(Arrays.asList(enabledLoggingStrategies));
            return this;
        }

        @Override
        public final Builder enabledLoggingStrategies(Collection<LoggingStrategy> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copyEnumToString(enabledLoggingStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledLoggingStrategies(LoggingStrategy... enabledLoggingStrategies) {
            enabledLoggingStrategies(Arrays.asList(enabledLoggingStrategies));
            return this;
        }

        @Override
        public LogConfiguration build() {
            return new LogConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
