/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates a broker using the specified properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBrokerRequest extends MqRequest implements
        ToCopyableBuilder<CreateBrokerRequest.Builder, CreateBrokerRequest> {
    private static final SdkField<String> AUTHENTICATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationStrategy").getter(getter(CreateBrokerRequest::authenticationStrategyAsString))
            .setter(setter(Builder::authenticationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationStrategy").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(CreateBrokerRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> BROKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrokerName").getter(getter(CreateBrokerRequest::brokerName)).setter(setter(Builder::brokerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerName").build()).build();

    private static final SdkField<ConfigurationId> CONFIGURATION_FIELD = SdkField
            .<ConfigurationId> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(CreateBrokerRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(ConfigurationId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId")
            .getter(getter(CreateBrokerRequest::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorRequestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DEPLOYMENT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentMode").getter(getter(CreateBrokerRequest::deploymentModeAsString))
            .setter(setter(Builder::deploymentMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentMode").build()).build();

    private static final SdkField<EncryptionOptions> ENCRYPTION_OPTIONS_FIELD = SdkField
            .<EncryptionOptions> builder(MarshallingType.SDK_POJO).memberName("EncryptionOptions")
            .getter(getter(CreateBrokerRequest::encryptionOptions)).setter(setter(Builder::encryptionOptions))
            .constructor(EncryptionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionOptions").build()).build();

    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineType").getter(getter(CreateBrokerRequest::engineTypeAsString)).setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CreateBrokerRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostInstanceType").getter(getter(CreateBrokerRequest::hostInstanceType))
            .setter(setter(Builder::hostInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()).build();

    private static final SdkField<LdapServerMetadataInput> LDAP_SERVER_METADATA_FIELD = SdkField
            .<LdapServerMetadataInput> builder(MarshallingType.SDK_POJO).memberName("LdapServerMetadata")
            .getter(getter(CreateBrokerRequest::ldapServerMetadata)).setter(setter(Builder::ldapServerMetadata))
            .constructor(LdapServerMetadataInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ldapServerMetadata").build())
            .build();

    private static final SdkField<Logs> LOGS_FIELD = SdkField.<Logs> builder(MarshallingType.SDK_POJO).memberName("Logs")
            .getter(getter(CreateBrokerRequest::logs)).setter(setter(Builder::logs)).constructor(Logs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()).build();

    private static final SdkField<WeeklyStartTime> MAINTENANCE_WINDOW_START_TIME_FIELD = SdkField
            .<WeeklyStartTime> builder(MarshallingType.SDK_POJO)
            .memberName("MaintenanceWindowStartTime")
            .getter(getter(CreateBrokerRequest::maintenanceWindowStartTime))
            .setter(setter(Builder::maintenanceWindowStartTime))
            .constructor(WeeklyStartTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindowStartTime").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(CreateBrokerRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(CreateBrokerRequest::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(CreateBrokerRequest::storageTypeAsString))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(CreateBrokerRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateBrokerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<User>> USERS_FIELD = SdkField
            .<List<User>> builder(MarshallingType.LIST)
            .memberName("Users")
            .getter(getter(CreateBrokerRequest::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<User> builder(MarshallingType.SDK_POJO)
                                            .constructor(User::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATA_REPLICATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataReplicationMode").getter(getter(CreateBrokerRequest::dataReplicationModeAsString))
            .setter(setter(Builder::dataReplicationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationMode").build())
            .build();

    private static final SdkField<String> DATA_REPLICATION_PRIMARY_BROKER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataReplicationPrimaryBrokerArn")
            .getter(getter(CreateBrokerRequest::dataReplicationPrimaryBrokerArn))
            .setter(setter(Builder::dataReplicationPrimaryBrokerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationPrimaryBrokerArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_STRATEGY_FIELD,
            AUTO_MINOR_VERSION_UPGRADE_FIELD, BROKER_NAME_FIELD, CONFIGURATION_FIELD, CREATOR_REQUEST_ID_FIELD,
            DEPLOYMENT_MODE_FIELD, ENCRYPTION_OPTIONS_FIELD, ENGINE_TYPE_FIELD, ENGINE_VERSION_FIELD, HOST_INSTANCE_TYPE_FIELD,
            LDAP_SERVER_METADATA_FIELD, LOGS_FIELD, MAINTENANCE_WINDOW_START_TIME_FIELD, PUBLICLY_ACCESSIBLE_FIELD,
            SECURITY_GROUPS_FIELD, STORAGE_TYPE_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD, USERS_FIELD, DATA_REPLICATION_MODE_FIELD,
            DATA_REPLICATION_PRIMARY_BROKER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authenticationStrategy;

    private final Boolean autoMinorVersionUpgrade;

    private final String brokerName;

    private final ConfigurationId configuration;

    private final String creatorRequestId;

    private final String deploymentMode;

    private final EncryptionOptions encryptionOptions;

    private final String engineType;

    private final String engineVersion;

    private final String hostInstanceType;

    private final LdapServerMetadataInput ldapServerMetadata;

    private final Logs logs;

    private final WeeklyStartTime maintenanceWindowStartTime;

    private final Boolean publiclyAccessible;

    private final List<String> securityGroups;

    private final String storageType;

    private final List<String> subnetIds;

    private final Map<String, String> tags;

    private final List<User> users;

    private final String dataReplicationMode;

    private final String dataReplicationPrimaryBrokerArn;

    private CreateBrokerRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationStrategy = builder.authenticationStrategy;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.brokerName = builder.brokerName;
        this.configuration = builder.configuration;
        this.creatorRequestId = builder.creatorRequestId;
        this.deploymentMode = builder.deploymentMode;
        this.encryptionOptions = builder.encryptionOptions;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.hostInstanceType = builder.hostInstanceType;
        this.ldapServerMetadata = builder.ldapServerMetadata;
        this.logs = builder.logs;
        this.maintenanceWindowStartTime = builder.maintenanceWindowStartTime;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroups = builder.securityGroups;
        this.storageType = builder.storageType;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.users = builder.users;
        this.dataReplicationMode = builder.dataReplicationMode;
        this.dataReplicationPrimaryBrokerArn = builder.dataReplicationPrimaryBrokerArn;
    }

    /**
     * <p>
     * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationStrategy} will return {@link AuthenticationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationStrategyAsString}.
     * </p>
     * 
     * @return Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
     * @see AuthenticationStrategy
     */
    public final AuthenticationStrategy authenticationStrategy() {
        return AuthenticationStrategy.fromValue(authenticationStrategy);
    }

    /**
     * <p>
     * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationStrategy} will return {@link AuthenticationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationStrategyAsString}.
     * </p>
     * 
     * @return Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
     * @see AuthenticationStrategy
     */
    public final String authenticationStrategyAsString() {
        return authenticationStrategy;
    }

    /**
     * <p>
     * Enables automatic upgrades to new patch versions for brokers as new versions are released and supported by Amazon
     * MQ. Automatic upgrades occur during the scheduled maintenance window or after a manual broker reboot. Set to true
     * by default, if no value is specified.
     * </p>
     * <note>
     * <p>
     * Must be set to true for ActiveMQ brokers version 5.18 and above and for RabbitMQ brokers version 3.13 and above.
     * </p>
     * </note>
     * 
     * @return Enables automatic upgrades to new patch versions for brokers as new versions are released and supported
     *         by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window or after a manual broker
     *         reboot. Set to true by default, if no value is specified.</p> <note>
     *         <p>
     *         Must be set to true for ActiveMQ brokers version 5.18 and above and for RabbitMQ brokers version 3.13 and
     *         above.
     *         </p>
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * Required. The broker's name. This value must be unique in your Amazon Web Services account, 1-50 characters long,
     * must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets,
     * wildcard characters, or special characters.
     * </p>
     * <important>
     * <p>
     * Do not add personally identifiable information (PII) or other confidential or sensitive information in broker
     * names. Broker names are accessible to other Amazon Web Services services, including CloudWatch Logs. Broker names
     * are not intended to be used for private or sensitive data.
     * </p>
     * </important>
     * 
     * @return Required. The broker's name. This value must be unique in your Amazon Web Services account, 1-50
     *         characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white
     *         spaces, brackets, wildcard characters, or special characters.</p> <important>
     *         <p>
     *         Do not add personally identifiable information (PII) or other confidential or sensitive information in
     *         broker names. Broker names are accessible to other Amazon Web Services services, including CloudWatch
     *         Logs. Broker names are not intended to be used for private or sensitive data.
     *         </p>
     */
    public final String brokerName() {
        return brokerName;
    }

    /**
     * <p>
     * A list of information about the configuration.
     * </p>
     * 
     * @return A list of information about the configuration.
     */
    public final ConfigurationId configuration() {
        return configuration;
    }

    /**
     * <p>
     * The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action.
     * </p>
     * <note>
     * <p>
     * We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the
     * creatorRequestId if your application doesn't require idempotency.
     * </p>
     * </note>
     * 
     * @return The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API
     *         action.</p> <note>
     *         <p>
     *         We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the
     *         creatorRequestId if your application doesn't require idempotency.
     *         </p>
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * Required. The broker's deployment mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentMode}
     * will return {@link DeploymentMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentModeAsString}.
     * </p>
     * 
     * @return Required. The broker's deployment mode.
     * @see DeploymentMode
     */
    public final DeploymentMode deploymentMode() {
        return DeploymentMode.fromValue(deploymentMode);
    }

    /**
     * <p>
     * Required. The broker's deployment mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentMode}
     * will return {@link DeploymentMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentModeAsString}.
     * </p>
     * 
     * @return Required. The broker's deployment mode.
     * @see DeploymentMode
     */
    public final String deploymentModeAsString() {
        return deploymentMode;
    }

    /**
     * <p>
     * Encryption options for the broker.
     * </p>
     * 
     * @return Encryption options for the broker.
     */
    public final EncryptionOptions encryptionOptions() {
        return encryptionOptions;
    }

    /**
     * <p>
     * Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     * @see EngineType
     */
    public final EngineType engineType() {
        return EngineType.fromValue(engineType);
    }

    /**
     * <p>
     * Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     * @see EngineType
     */
    public final String engineTypeAsString() {
        return engineType;
    }

    /**
     * <p>
     * The broker engine version. Defaults to the latest available version for the specified broker engine type. For
     * more information, see the <a
     * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/activemq-version-management.html">ActiveMQ
     * version management</a> and the <a
     * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/rabbitmq-version-management.html">RabbitMQ
     * version management</a> sections in the Amazon MQ Developer Guide.
     * </p>
     * 
     * @return The broker engine version. Defaults to the latest available version for the specified broker engine type.
     *         For more information, see the <a
     *         href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/activemq-version-management.html"
     *         >ActiveMQ version management</a> and the <a
     *         href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/rabbitmq-version-management.html"
     *         >RabbitMQ version management</a> sections in the Amazon MQ Developer Guide.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Required. The broker's instance type.
     * </p>
     * 
     * @return Required. The broker's instance type.
     */
    public final String hostInstanceType() {
        return hostInstanceType;
    }

    /**
     * <p>
     * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not
     * apply to RabbitMQ brokers.
     * </p>
     * 
     * @return Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker.
     *         Does not apply to RabbitMQ brokers.
     */
    public final LdapServerMetadataInput ldapServerMetadata() {
        return ldapServerMetadata;
    }

    /**
     * <p>
     * Enables Amazon CloudWatch logging for brokers.
     * </p>
     * 
     * @return Enables Amazon CloudWatch logging for brokers.
     */
    public final Logs logs() {
        return logs;
    }

    /**
     * <p>
     * The parameters that determine the WeeklyStartTime.
     * </p>
     * 
     * @return The parameters that determine the WeeklyStartTime.
     */
    public final WeeklyStartTime maintenanceWindowStartTime() {
        return maintenanceWindowStartTime;
    }

    /**
     * <p>
     * Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by
     * default, if no value is provided.
     * </p>
     * 
     * @return Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by
     *         default, if no value is provided.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The broker's storage type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link BrokerStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The broker's storage type.
     * @see BrokerStorageType
     */
    public final BrokerStorageType storageType() {
        return BrokerStorageType.fromValue(storageType);
    }

    /**
     * <p>
     * The broker's storage type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link BrokerStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The broker's storage type.
     * @see BrokerStorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.
     * If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be
     * able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A
     * SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ
     * Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has
     * no subnet requirements when deployed with public accessibility. Deployment without public accessibility requires
     * at least one subnet.
     * </p>
     * <important>
     * <p>
     * If you specify subnets in a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared
     * VPC</a> for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your
     * Amazon Web Services account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by
     * your Amazon Web Services account.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The list of groups that define which subnets and IP ranges the broker can use from different Availability
     *         Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon
     *         MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same
     *         Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An
     *         ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon
     *         MQ for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment
     *         without public accessibility requires at least one subnet.</p> <important>
     *         <p>
     *         If you specify subnets in a <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ
     *         broker, the associated VPC to which the specified subnets belong must be owned by your Amazon Web
     *         Services account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your
     *         Amazon Web Services account.
     *         </p>
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Create tags when creating the broker.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Create tags when creating the broker.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Users property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of broker users (persons or applications) who can access queues and topics. For Amazon MQ for RabbitMQ
     * brokers, one and only one administrative user is accepted and created when a broker is first provisioned. All
     * subsequent broker users are created by making RabbitMQ API calls directly to brokers or via the RabbitMQ web
     * console.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsers} method.
     * </p>
     * 
     * @return The list of broker users (persons or applications) who can access queues and topics. For Amazon MQ for
     *         RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first
     *         provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or
     *         via the RabbitMQ web console.
     */
    public final List<User> users() {
        return users;
    }

    /**
     * <p>
     * Defines whether this broker is a part of a data replication pair.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataReplicationMode} will return {@link DataReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataReplicationModeAsString}.
     * </p>
     * 
     * @return Defines whether this broker is a part of a data replication pair.
     * @see DataReplicationMode
     */
    public final DataReplicationMode dataReplicationMode() {
        return DataReplicationMode.fromValue(dataReplicationMode);
    }

    /**
     * <p>
     * Defines whether this broker is a part of a data replication pair.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataReplicationMode} will return {@link DataReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataReplicationModeAsString}.
     * </p>
     * 
     * @return Defines whether this broker is a part of a data replication pair.
     * @see DataReplicationMode
     */
    public final String dataReplicationModeAsString() {
        return dataReplicationMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the primary broker that is used to replicate data from in a data replication
     * pair, and is applied to the replica broker. Must be set when dataReplicationMode is set to CRDR.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the primary broker that is used to replicate data from in a data
     *         replication pair, and is applied to the replica broker. Must be set when dataReplicationMode is set to
     *         CRDR.
     */
    public final String dataReplicationPrimaryBrokerArn() {
        return dataReplicationPrimaryBrokerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(brokerName());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(ldapServerMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(logs());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUsers() ? users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationPrimaryBrokerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBrokerRequest)) {
            return false;
        }
        CreateBrokerRequest other = (CreateBrokerRequest) obj;
        return Objects.equals(authenticationStrategyAsString(), other.authenticationStrategyAsString())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(brokerName(), other.brokerName()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(deploymentModeAsString(), other.deploymentModeAsString())
                && Objects.equals(encryptionOptions(), other.encryptionOptions())
                && Objects.equals(engineTypeAsString(), other.engineTypeAsString())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(hostInstanceType(), other.hostInstanceType())
                && Objects.equals(ldapServerMetadata(), other.ldapServerMetadata()) && Objects.equals(logs(), other.logs())
                && Objects.equals(maintenanceWindowStartTime(), other.maintenanceWindowStartTime())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(storageTypeAsString(), other.storageTypeAsString()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasUsers() == other.hasUsers()
                && Objects.equals(users(), other.users())
                && Objects.equals(dataReplicationModeAsString(), other.dataReplicationModeAsString())
                && Objects.equals(dataReplicationPrimaryBrokerArn(), other.dataReplicationPrimaryBrokerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBrokerRequest").add("AuthenticationStrategy", authenticationStrategyAsString())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade()).add("BrokerName", brokerName())
                .add("Configuration", configuration()).add("CreatorRequestId", creatorRequestId())
                .add("DeploymentMode", deploymentModeAsString()).add("EncryptionOptions", encryptionOptions())
                .add("EngineType", engineTypeAsString()).add("EngineVersion", engineVersion())
                .add("HostInstanceType", hostInstanceType()).add("LdapServerMetadata", ldapServerMetadata()).add("Logs", logs())
                .add("MaintenanceWindowStartTime", maintenanceWindowStartTime()).add("PubliclyAccessible", publiclyAccessible())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("StorageType", storageTypeAsString())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("Tags", hasTags() ? tags() : null)
                .add("Users", hasUsers() ? users() : null).add("DataReplicationMode", dataReplicationModeAsString())
                .add("DataReplicationPrimaryBrokerArn", dataReplicationPrimaryBrokerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationStrategy":
            return Optional.ofNullable(clazz.cast(authenticationStrategyAsString()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "BrokerName":
            return Optional.ofNullable(clazz.cast(brokerName()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "DeploymentMode":
            return Optional.ofNullable(clazz.cast(deploymentModeAsString()));
        case "EncryptionOptions":
            return Optional.ofNullable(clazz.cast(encryptionOptions()));
        case "EngineType":
            return Optional.ofNullable(clazz.cast(engineTypeAsString()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "HostInstanceType":
            return Optional.ofNullable(clazz.cast(hostInstanceType()));
        case "LdapServerMetadata":
            return Optional.ofNullable(clazz.cast(ldapServerMetadata()));
        case "Logs":
            return Optional.ofNullable(clazz.cast(logs()));
        case "MaintenanceWindowStartTime":
            return Optional.ofNullable(clazz.cast(maintenanceWindowStartTime()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Users":
            return Optional.ofNullable(clazz.cast(users()));
        case "DataReplicationMode":
            return Optional.ofNullable(clazz.cast(dataReplicationModeAsString()));
        case "DataReplicationPrimaryBrokerArn":
            return Optional.ofNullable(clazz.cast(dataReplicationPrimaryBrokerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authenticationStrategy", AUTHENTICATION_STRATEGY_FIELD);
        map.put("autoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("brokerName", BROKER_NAME_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("creatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("deploymentMode", DEPLOYMENT_MODE_FIELD);
        map.put("encryptionOptions", ENCRYPTION_OPTIONS_FIELD);
        map.put("engineType", ENGINE_TYPE_FIELD);
        map.put("engineVersion", ENGINE_VERSION_FIELD);
        map.put("hostInstanceType", HOST_INSTANCE_TYPE_FIELD);
        map.put("ldapServerMetadata", LDAP_SERVER_METADATA_FIELD);
        map.put("logs", LOGS_FIELD);
        map.put("maintenanceWindowStartTime", MAINTENANCE_WINDOW_START_TIME_FIELD);
        map.put("publiclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("securityGroups", SECURITY_GROUPS_FIELD);
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("users", USERS_FIELD);
        map.put("dataReplicationMode", DATA_REPLICATION_MODE_FIELD);
        map.put("dataReplicationPrimaryBrokerArn", DATA_REPLICATION_PRIMARY_BROKER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBrokerRequest, T> g) {
        return obj -> g.apply((CreateBrokerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBrokerRequest> {
        /**
         * <p>
         * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
         * </p>
         * 
         * @param authenticationStrategy
         *        Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
         * @see AuthenticationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationStrategy
         */
        Builder authenticationStrategy(String authenticationStrategy);

        /**
         * <p>
         * Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
         * </p>
         * 
         * @param authenticationStrategy
         *        Optional. The authentication strategy used to secure the broker. The default is SIMPLE.
         * @see AuthenticationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationStrategy
         */
        Builder authenticationStrategy(AuthenticationStrategy authenticationStrategy);

        /**
         * <p>
         * Enables automatic upgrades to new patch versions for brokers as new versions are released and supported by
         * Amazon MQ. Automatic upgrades occur during the scheduled maintenance window or after a manual broker reboot.
         * Set to true by default, if no value is specified.
         * </p>
         * <note>
         * <p>
         * Must be set to true for ActiveMQ brokers version 5.18 and above and for RabbitMQ brokers version 3.13 and
         * above.
         * </p>
         * </note>
         * 
         * @param autoMinorVersionUpgrade
         *        Enables automatic upgrades to new patch versions for brokers as new versions are released and
         *        supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window or after a
         *        manual broker reboot. Set to true by default, if no value is specified.</p> <note>
         *        <p>
         *        Must be set to true for ActiveMQ brokers version 5.18 and above and for RabbitMQ brokers version 3.13
         *        and above.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * Required. The broker's name. This value must be unique in your Amazon Web Services account, 1-50 characters
         * long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces,
         * brackets, wildcard characters, or special characters.
         * </p>
         * <important>
         * <p>
         * Do not add personally identifiable information (PII) or other confidential or sensitive information in broker
         * names. Broker names are accessible to other Amazon Web Services services, including CloudWatch Logs. Broker
         * names are not intended to be used for private or sensitive data.
         * </p>
         * </important>
         * 
         * @param brokerName
         *        Required. The broker's name. This value must be unique in your Amazon Web Services account, 1-50
         *        characters long, must contain only letters, numbers, dashes, and underscores, and must not contain
         *        white spaces, brackets, wildcard characters, or special characters.</p> <important>
         *        <p>
         *        Do not add personally identifiable information (PII) or other confidential or sensitive information in
         *        broker names. Broker names are accessible to other Amazon Web Services services, including CloudWatch
         *        Logs. Broker names are not intended to be used for private or sensitive data.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerName(String brokerName);

        /**
         * <p>
         * A list of information about the configuration.
         * </p>
         * 
         * @param configuration
         *        A list of information about the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ConfigurationId configuration);

        /**
         * <p>
         * A list of information about the configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurationId.Builder} avoiding the
         * need to create one manually via {@link ConfigurationId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationId.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(ConfigurationId)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ConfigurationId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ConfigurationId)
         */
        default Builder configuration(Consumer<ConfigurationId.Builder> configuration) {
            return configuration(ConfigurationId.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API
         * action.
         * </p>
         * <note>
         * <p>
         * We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the
         * creatorRequestId if your application doesn't require idempotency.
         * </p>
         * </note>
         * 
         * @param creatorRequestId
         *        The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the
         *        API action.</p> <note>
         *        <p>
         *        We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the
         *        creatorRequestId if your application doesn't require idempotency.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * Required. The broker's deployment mode.
         * </p>
         * 
         * @param deploymentMode
         *        Required. The broker's deployment mode.
         * @see DeploymentMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentMode
         */
        Builder deploymentMode(String deploymentMode);

        /**
         * <p>
         * Required. The broker's deployment mode.
         * </p>
         * 
         * @param deploymentMode
         *        Required. The broker's deployment mode.
         * @see DeploymentMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentMode
         */
        Builder deploymentMode(DeploymentMode deploymentMode);

        /**
         * <p>
         * Encryption options for the broker.
         * </p>
         * 
         * @param encryptionOptions
         *        Encryption options for the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionOptions(EncryptionOptions encryptionOptions);

        /**
         * <p>
         * Encryption options for the broker.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionOptions.Builder} avoiding the
         * need to create one manually via {@link EncryptionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionOptions(EncryptionOptions)}.
         * 
         * @param encryptionOptions
         *        a consumer that will call methods on {@link EncryptionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionOptions(EncryptionOptions)
         */
        default Builder encryptionOptions(Consumer<EncryptionOptions.Builder> encryptionOptions) {
            return encryptionOptions(EncryptionOptions.builder().applyMutation(encryptionOptions).build());
        }

        /**
         * <p>
         * Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         * </p>
         * 
         * @param engineType
         *        Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(String engineType);

        /**
         * <p>
         * Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         * </p>
         * 
         * @param engineType
         *        Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(EngineType engineType);

        /**
         * <p>
         * The broker engine version. Defaults to the latest available version for the specified broker engine type. For
         * more information, see the <a
         * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/activemq-version-management.html"
         * >ActiveMQ version management</a> and the <a
         * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/rabbitmq-version-management.html"
         * >RabbitMQ version management</a> sections in the Amazon MQ Developer Guide.
         * </p>
         * 
         * @param engineVersion
         *        The broker engine version. Defaults to the latest available version for the specified broker engine
         *        type. For more information, see the <a href=
         *        "https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/activemq-version-management.html"
         *        >ActiveMQ version management</a> and the <a href=
         *        "https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/rabbitmq-version-management.html"
         *        >RabbitMQ version management</a> sections in the Amazon MQ Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Required. The broker's instance type.
         * </p>
         * 
         * @param hostInstanceType
         *        Required. The broker's instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostInstanceType(String hostInstanceType);

        /**
         * <p>
         * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does
         * not apply to RabbitMQ brokers.
         * </p>
         * 
         * @param ldapServerMetadata
         *        Optional. The metadata of the LDAP server used to authenticate and authorize connections to the
         *        broker. Does not apply to RabbitMQ brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ldapServerMetadata(LdapServerMetadataInput ldapServerMetadata);

        /**
         * <p>
         * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does
         * not apply to RabbitMQ brokers.
         * </p>
         * This is a convenience method that creates an instance of the {@link LdapServerMetadataInput.Builder} avoiding
         * the need to create one manually via {@link LdapServerMetadataInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LdapServerMetadataInput.Builder#build()} is called immediately
         * and its result is passed to {@link #ldapServerMetadata(LdapServerMetadataInput)}.
         * 
         * @param ldapServerMetadata
         *        a consumer that will call methods on {@link LdapServerMetadataInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ldapServerMetadata(LdapServerMetadataInput)
         */
        default Builder ldapServerMetadata(Consumer<LdapServerMetadataInput.Builder> ldapServerMetadata) {
            return ldapServerMetadata(LdapServerMetadataInput.builder().applyMutation(ldapServerMetadata).build());
        }

        /**
         * <p>
         * Enables Amazon CloudWatch logging for brokers.
         * </p>
         * 
         * @param logs
         *        Enables Amazon CloudWatch logging for brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logs(Logs logs);

        /**
         * <p>
         * Enables Amazon CloudWatch logging for brokers.
         * </p>
         * This is a convenience method that creates an instance of the {@link Logs.Builder} avoiding the need to create
         * one manually via {@link Logs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Logs.Builder#build()} is called immediately and its result is
         * passed to {@link #logs(Logs)}.
         * 
         * @param logs
         *        a consumer that will call methods on {@link Logs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logs(Logs)
         */
        default Builder logs(Consumer<Logs.Builder> logs) {
            return logs(Logs.builder().applyMutation(logs).build());
        }

        /**
         * <p>
         * The parameters that determine the WeeklyStartTime.
         * </p>
         * 
         * @param maintenanceWindowStartTime
         *        The parameters that determine the WeeklyStartTime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindowStartTime(WeeklyStartTime maintenanceWindowStartTime);

        /**
         * <p>
         * The parameters that determine the WeeklyStartTime.
         * </p>
         * This is a convenience method that creates an instance of the {@link WeeklyStartTime.Builder} avoiding the
         * need to create one manually via {@link WeeklyStartTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WeeklyStartTime.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenanceWindowStartTime(WeeklyStartTime)}.
         * 
         * @param maintenanceWindowStartTime
         *        a consumer that will call methods on {@link WeeklyStartTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceWindowStartTime(WeeklyStartTime)
         */
        default Builder maintenanceWindowStartTime(Consumer<WeeklyStartTime.Builder> maintenanceWindowStartTime) {
            return maintenanceWindowStartTime(WeeklyStartTime.builder().applyMutation(maintenanceWindowStartTime).build());
        }

        /**
         * <p>
         * Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false by
         * default, if no value is provided.
         * </p>
         * 
         * @param publiclyAccessible
         *        Enables connections from applications outside of the VPC that hosts the broker's subnets. Set to false
         *        by default, if no value is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         * </p>
         * 
         * @param securityGroups
         *        The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         * </p>
         * 
         * @param securityGroups
         *        The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The broker's storage type.
         * </p>
         * 
         * @param storageType
         *        The broker's storage type.
         * @see BrokerStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerStorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The broker's storage type.
         * </p>
         * 
         * @param storageType
         *        The broker's storage type.
         * @see BrokerStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerStorageType
         */
        Builder storageType(BrokerStorageType storageType);

        /**
         * <p>
         * The list of groups that define which subnets and IP ranges the broker can use from different Availability
         * Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ
         * will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone.
         * A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An
         * ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ
         * for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment
         * without public accessibility requires at least one subnet.
         * </p>
         * <important>
         * <p>
         * If you specify subnets in a <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ
         * broker, the associated VPC to which the specified subnets belong must be owned by your Amazon Web Services
         * account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your Amazon Web
         * Services account.
         * </p>
         * </important>
         * 
         * @param subnetIds
         *        The list of groups that define which subnets and IP ranges the broker can use from different
         *        Availability Zones. If you specify more than one subnet, the subnets must be in different Availability
         *        Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the
         *        same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default
         *        subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A
         *        CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with
         *        public accessibility. Deployment without public accessibility requires at least one subnet.</p>
         *        <important>
         *        <p>
         *        If you specify subnets in a <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ
         *        broker, the associated VPC to which the specified subnets belong must be owned by your Amazon Web
         *        Services account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by
         *        your Amazon Web Services account.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The list of groups that define which subnets and IP ranges the broker can use from different Availability
         * Zones. If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ
         * will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone.
         * A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An
         * ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A CLUSTER_MULTI_AZ Amazon MQ
         * for RabbitMQ deployment has no subnet requirements when deployed with public accessibility. Deployment
         * without public accessibility requires at least one subnet.
         * </p>
         * <important>
         * <p>
         * If you specify subnets in a <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ
         * broker, the associated VPC to which the specified subnets belong must be owned by your Amazon Web Services
         * account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by your Amazon Web
         * Services account.
         * </p>
         * </important>
         * 
         * @param subnetIds
         *        The list of groups that define which subnets and IP ranges the broker can use from different
         *        Availability Zones. If you specify more than one subnet, the subnets must be in different Availability
         *        Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the
         *        same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default
         *        subnet). An ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two subnets. A
         *        CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no subnet requirements when deployed with
         *        public accessibility. Deployment without public accessibility requires at least one subnet.</p>
         *        <important>
         *        <p>
         *        If you specify subnets in a <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html">shared VPC</a> for a RabbitMQ
         *        broker, the associated VPC to which the specified subnets belong must be owned by your Amazon Web
         *        Services account. Amazon MQ will not be able to create VPC endpoints in VPCs that are not owned by
         *        your Amazon Web Services account.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * Create tags when creating the broker.
         * </p>
         * 
         * @param tags
         *        Create tags when creating the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The list of broker users (persons or applications) who can access queues and topics. For Amazon MQ for
         * RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first
         * provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via
         * the RabbitMQ web console.
         * </p>
         * 
         * @param users
         *        The list of broker users (persons or applications) who can access queues and topics. For Amazon MQ for
         *        RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first
         *        provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers
         *        or via the RabbitMQ web console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<User> users);

        /**
         * <p>
         * The list of broker users (persons or applications) who can access queues and topics. For Amazon MQ for
         * RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first
         * provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via
         * the RabbitMQ web console.
         * </p>
         * 
         * @param users
         *        The list of broker users (persons or applications) who can access queues and topics. For Amazon MQ for
         *        RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first
         *        provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers
         *        or via the RabbitMQ web console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(User... users);

        /**
         * <p>
         * The list of broker users (persons or applications) who can access queues and topics. For Amazon MQ for
         * RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first
         * provisioned. All subsequent broker users are created by making RabbitMQ API calls directly to brokers or via
         * the RabbitMQ web console.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mq.model.User.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.mq.model.User#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.mq.model.User.Builder#build()} is
         * called immediately and its result is passed to {@link #users(List<User>)}.
         * 
         * @param users
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.mq.model.User.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(java.util.Collection<User>)
         */
        Builder users(Consumer<User.Builder>... users);

        /**
         * <p>
         * Defines whether this broker is a part of a data replication pair.
         * </p>
         * 
         * @param dataReplicationMode
         *        Defines whether this broker is a part of a data replication pair.
         * @see DataReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationMode
         */
        Builder dataReplicationMode(String dataReplicationMode);

        /**
         * <p>
         * Defines whether this broker is a part of a data replication pair.
         * </p>
         * 
         * @param dataReplicationMode
         *        Defines whether this broker is a part of a data replication pair.
         * @see DataReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationMode
         */
        Builder dataReplicationMode(DataReplicationMode dataReplicationMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the primary broker that is used to replicate data from in a data
         * replication pair, and is applied to the replica broker. Must be set when dataReplicationMode is set to CRDR.
         * </p>
         * 
         * @param dataReplicationPrimaryBrokerArn
         *        The Amazon Resource Name (ARN) of the primary broker that is used to replicate data from in a data
         *        replication pair, and is applied to the replica broker. Must be set when dataReplicationMode is set to
         *        CRDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationPrimaryBrokerArn(String dataReplicationPrimaryBrokerArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MqRequest.BuilderImpl implements Builder {
        private String authenticationStrategy;

        private Boolean autoMinorVersionUpgrade;

        private String brokerName;

        private ConfigurationId configuration;

        private String creatorRequestId;

        private String deploymentMode;

        private EncryptionOptions encryptionOptions;

        private String engineType;

        private String engineVersion;

        private String hostInstanceType;

        private LdapServerMetadataInput ldapServerMetadata;

        private Logs logs;

        private WeeklyStartTime maintenanceWindowStartTime;

        private Boolean publiclyAccessible;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String storageType;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<User> users = DefaultSdkAutoConstructList.getInstance();

        private String dataReplicationMode;

        private String dataReplicationPrimaryBrokerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBrokerRequest model) {
            super(model);
            authenticationStrategy(model.authenticationStrategy);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            brokerName(model.brokerName);
            configuration(model.configuration);
            creatorRequestId(model.creatorRequestId);
            deploymentMode(model.deploymentMode);
            encryptionOptions(model.encryptionOptions);
            engineType(model.engineType);
            engineVersion(model.engineVersion);
            hostInstanceType(model.hostInstanceType);
            ldapServerMetadata(model.ldapServerMetadata);
            logs(model.logs);
            maintenanceWindowStartTime(model.maintenanceWindowStartTime);
            publiclyAccessible(model.publiclyAccessible);
            securityGroups(model.securityGroups);
            storageType(model.storageType);
            subnetIds(model.subnetIds);
            tags(model.tags);
            users(model.users);
            dataReplicationMode(model.dataReplicationMode);
            dataReplicationPrimaryBrokerArn(model.dataReplicationPrimaryBrokerArn);
        }

        public final String getAuthenticationStrategy() {
            return authenticationStrategy;
        }

        public final void setAuthenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
        }

        @Override
        public final Builder authenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
            return this;
        }

        @Override
        public final Builder authenticationStrategy(AuthenticationStrategy authenticationStrategy) {
            this.authenticationStrategy(authenticationStrategy == null ? null : authenticationStrategy.toString());
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getBrokerName() {
            return brokerName;
        }

        public final void setBrokerName(String brokerName) {
            this.brokerName = brokerName;
        }

        @Override
        public final Builder brokerName(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public final ConfigurationId.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ConfigurationId.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ConfigurationId configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getDeploymentMode() {
            return deploymentMode;
        }

        public final void setDeploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
        }

        @Override
        public final Builder deploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        @Override
        public final Builder deploymentMode(DeploymentMode deploymentMode) {
            this.deploymentMode(deploymentMode == null ? null : deploymentMode.toString());
            return this;
        }

        public final EncryptionOptions.Builder getEncryptionOptions() {
            return encryptionOptions != null ? encryptionOptions.toBuilder() : null;
        }

        public final void setEncryptionOptions(EncryptionOptions.BuilderImpl encryptionOptions) {
            this.encryptionOptions = encryptionOptions != null ? encryptionOptions.build() : null;
        }

        @Override
        public final Builder encryptionOptions(EncryptionOptions encryptionOptions) {
            this.encryptionOptions = encryptionOptions;
            return this;
        }

        public final String getEngineType() {
            return engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getHostInstanceType() {
            return hostInstanceType;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final LdapServerMetadataInput.Builder getLdapServerMetadata() {
            return ldapServerMetadata != null ? ldapServerMetadata.toBuilder() : null;
        }

        public final void setLdapServerMetadata(LdapServerMetadataInput.BuilderImpl ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata != null ? ldapServerMetadata.build() : null;
        }

        @Override
        public final Builder ldapServerMetadata(LdapServerMetadataInput ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata;
            return this;
        }

        public final Logs.Builder getLogs() {
            return logs != null ? logs.toBuilder() : null;
        }

        public final void setLogs(Logs.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        @Override
        public final Builder logs(Logs logs) {
            this.logs = logs;
            return this;
        }

        public final WeeklyStartTime.Builder getMaintenanceWindowStartTime() {
            return maintenanceWindowStartTime != null ? maintenanceWindowStartTime.toBuilder() : null;
        }

        public final void setMaintenanceWindowStartTime(WeeklyStartTime.BuilderImpl maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime != null ? maintenanceWindowStartTime.build() : null;
        }

        @Override
        public final Builder maintenanceWindowStartTime(WeeklyStartTime maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(BrokerStorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final List<User.Builder> getUsers() {
            List<User.Builder> result = ___listOfUserCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<User.BuilderImpl> users) {
            this.users = ___listOfUserCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<User> users) {
            this.users = ___listOfUserCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(User... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<User.Builder>... users) {
            users(Stream.of(users).map(c -> User.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataReplicationMode() {
            return dataReplicationMode;
        }

        public final void setDataReplicationMode(String dataReplicationMode) {
            this.dataReplicationMode = dataReplicationMode;
        }

        @Override
        public final Builder dataReplicationMode(String dataReplicationMode) {
            this.dataReplicationMode = dataReplicationMode;
            return this;
        }

        @Override
        public final Builder dataReplicationMode(DataReplicationMode dataReplicationMode) {
            this.dataReplicationMode(dataReplicationMode == null ? null : dataReplicationMode.toString());
            return this;
        }

        public final String getDataReplicationPrimaryBrokerArn() {
            return dataReplicationPrimaryBrokerArn;
        }

        public final void setDataReplicationPrimaryBrokerArn(String dataReplicationPrimaryBrokerArn) {
            this.dataReplicationPrimaryBrokerArn = dataReplicationPrimaryBrokerArn;
        }

        @Override
        public final Builder dataReplicationPrimaryBrokerArn(String dataReplicationPrimaryBrokerArn) {
            this.dataReplicationPrimaryBrokerArn = dataReplicationPrimaryBrokerArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBrokerRequest build() {
            return new CreateBrokerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
