/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.MTurkResponse;
import software.amazon.awssdk.services.mturk.model.Qualification;
import software.amazon.awssdk.services.mturk.model.QualificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkersWithQualificationTypeResponse
extends MTurkResponse
implements ToCopyableBuilder<Builder, ListWorkersWithQualificationTypeResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWorkersWithQualificationTypeResponse.getter(ListWorkersWithQualificationTypeResponse::nextToken)).setter(ListWorkersWithQualificationTypeResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumResults").getter(ListWorkersWithQualificationTypeResponse.getter(ListWorkersWithQualificationTypeResponse::numResults)).setter(ListWorkersWithQualificationTypeResponse.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()}).build();
    private static final SdkField<List<Qualification>> QUALIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Qualifications").getter(ListWorkersWithQualificationTypeResponse.getter(ListWorkersWithQualificationTypeResponse::qualifications)).setter(ListWorkersWithQualificationTypeResponse.setter(Builder::qualifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Qualifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Qualification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NUM_RESULTS_FIELD, QUALIFICATIONS_FIELD));
    private final String nextToken;
    private final Integer numResults;
    private final List<Qualification> qualifications;

    private ListWorkersWithQualificationTypeResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.numResults = builder.numResults;
        this.qualifications = builder.qualifications;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer numResults() {
        return this.numResults;
    }

    public final boolean hasQualifications() {
        return this.qualifications != null && !(this.qualifications instanceof SdkAutoConstructList);
    }

    public final List<Qualification> qualifications() {
        return this.qualifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQualifications() ? this.qualifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkersWithQualificationTypeResponse)) {
            return false;
        }
        ListWorkersWithQualificationTypeResponse other = (ListWorkersWithQualificationTypeResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.numResults(), other.numResults()) && this.hasQualifications() == other.hasQualifications() && Objects.equals(this.qualifications(), other.qualifications());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkersWithQualificationTypeResponse").add("NextToken", (Object)this.nextToken()).add("NumResults", (Object)this.numResults()).add("Qualifications", this.hasQualifications() ? this.qualifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NumResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "Qualifications": {
                return Optional.ofNullable(clazz.cast(this.qualifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkersWithQualificationTypeResponse, T> g) {
        return obj -> g.apply((ListWorkersWithQualificationTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer numResults;
        private List<Qualification> qualifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkersWithQualificationTypeResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.numResults(model.numResults);
            this.qualifications(model.qualifications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final List<Qualification.Builder> getQualifications() {
            List<Qualification.Builder> result = QualificationListCopier.copyToBuilder(this.qualifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQualifications(Collection<Qualification.BuilderImpl> qualifications) {
            this.qualifications = QualificationListCopier.copyFromBuilder(qualifications);
        }

        @Override
        public final Builder qualifications(Collection<Qualification> qualifications) {
            this.qualifications = QualificationListCopier.copy(qualifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualifications(Qualification ... qualifications) {
            this.qualifications(Arrays.asList(qualifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualifications(Consumer<Qualification.Builder> ... qualifications) {
            this.qualifications(Stream.of(qualifications).map(c -> (Qualification)((Qualification.Builder)Qualification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkersWithQualificationTypeResponse build() {
            return new ListWorkersWithQualificationTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkersWithQualificationTypeResponse> {
        public Builder nextToken(String var1);

        public Builder numResults(Integer var1);

        public Builder qualifications(Collection<Qualification> var1);

        public Builder qualifications(Qualification ... var1);

        public Builder qualifications(Consumer<Qualification.Builder> ... var1);
    }
}

