/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mturk.model.EventType;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.services.mturk.model.NotificationSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendTestEventNotificationRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, SendTestEventNotificationRequest> {
    private static final SdkField<NotificationSpecification> NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Notification").getter(SendTestEventNotificationRequest.getter(SendTestEventNotificationRequest::notification)).setter(SendTestEventNotificationRequest.setter(Builder::notification)).constructor(NotificationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()}).build();
    private static final SdkField<String> TEST_EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TestEventType").getter(SendTestEventNotificationRequest.getter(SendTestEventNotificationRequest::testEventTypeAsString)).setter(SendTestEventNotificationRequest.setter(Builder::testEventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestEventType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_FIELD, TEST_EVENT_TYPE_FIELD));
    private final NotificationSpecification notification;
    private final String testEventType;

    private SendTestEventNotificationRequest(BuilderImpl builder) {
        super(builder);
        this.notification = builder.notification;
        this.testEventType = builder.testEventType;
    }

    public final NotificationSpecification notification() {
        return this.notification;
    }

    public final EventType testEventType() {
        return EventType.fromValue(this.testEventType);
    }

    public final String testEventTypeAsString() {
        return this.testEventType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.testEventTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendTestEventNotificationRequest)) {
            return false;
        }
        SendTestEventNotificationRequest other = (SendTestEventNotificationRequest)((Object)obj);
        return Objects.equals(this.notification(), other.notification()) && Objects.equals(this.testEventTypeAsString(), other.testEventTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SendTestEventNotificationRequest").add("Notification", (Object)this.notification()).add("TestEventType", (Object)this.testEventTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "TestEventType": {
                return Optional.ofNullable(clazz.cast(this.testEventTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendTestEventNotificationRequest, T> g) {
        return obj -> g.apply((SendTestEventNotificationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private NotificationSpecification notification;
        private String testEventType;

        private BuilderImpl() {
        }

        private BuilderImpl(SendTestEventNotificationRequest model) {
            super(model);
            this.notification(model.notification);
            this.testEventType(model.testEventType);
        }

        public final NotificationSpecification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        public final void setNotification(NotificationSpecification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        @Override
        public final Builder notification(NotificationSpecification notification) {
            this.notification = notification;
            return this;
        }

        public final String getTestEventType() {
            return this.testEventType;
        }

        public final void setTestEventType(String testEventType) {
            this.testEventType = testEventType;
        }

        @Override
        public final Builder testEventType(String testEventType) {
            this.testEventType = testEventType;
            return this;
        }

        @Override
        public final Builder testEventType(EventType testEventType) {
            this.testEventType(testEventType == null ? null : testEventType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendTestEventNotificationRequest build() {
            return new SendTestEventNotificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendTestEventNotificationRequest> {
        public Builder notification(NotificationSpecification var1);

        default public Builder notification(Consumer<NotificationSpecification.Builder> notification) {
            return this.notification((NotificationSpecification)((NotificationSpecification.Builder)NotificationSpecification.builder().applyMutation(notification)).build());
        }

        public Builder testEventType(String var1);

        public Builder testEventType(EventType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

