/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.ParameterMapEntry;
import software.amazon.awssdk.services.mturk.model.ParameterMapEntryListCopier;
import software.amazon.awssdk.services.mturk.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyParameter> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(PolicyParameter.getter(PolicyParameter::key)).setter(PolicyParameter.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(PolicyParameter.getter(PolicyParameter::values)).setter(PolicyParameter.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ParameterMapEntry>> MAP_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MapEntries").getter(PolicyParameter.getter(PolicyParameter::mapEntries)).setter(PolicyParameter.setter(Builder::mapEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterMapEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD, MAP_ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PolicyParameter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String key;
    private final List<String> values;
    private final List<ParameterMapEntry> mapEntries;

    private PolicyParameter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.mapEntries = builder.mapEntries;
    }

    public final String key() {
        return this.key;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public final boolean hasMapEntries() {
        return this.mapEntries != null && !(this.mapEntries instanceof SdkAutoConstructList);
    }

    public final List<ParameterMapEntry> mapEntries() {
        return this.mapEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMapEntries() ? this.mapEntries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyParameter)) {
            return false;
        }
        PolicyParameter other = (PolicyParameter)obj;
        return Objects.equals(this.key(), other.key()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && this.hasMapEntries() == other.hasMapEntries() && Objects.equals(this.mapEntries(), other.mapEntries());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyParameter").add("Key", (Object)this.key()).add("Values", this.hasValues() ? this.values() : null).add("MapEntries", this.hasMapEntries() ? this.mapEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "MapEntries": {
                return Optional.ofNullable(clazz.cast(this.mapEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Key", KEY_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("MapEntries", MAP_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyParameter, T> g) {
        return obj -> g.apply((PolicyParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private List<ParameterMapEntry> mapEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyParameter model) {
            this.key(model.key);
            this.values(model.values);
            this.mapEntries(model.mapEntries);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = StringListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = StringListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final List<ParameterMapEntry.Builder> getMapEntries() {
            List<ParameterMapEntry.Builder> result = ParameterMapEntryListCopier.copyToBuilder(this.mapEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapEntries(Collection<ParameterMapEntry.BuilderImpl> mapEntries) {
            this.mapEntries = ParameterMapEntryListCopier.copyFromBuilder(mapEntries);
        }

        @Override
        public final Builder mapEntries(Collection<ParameterMapEntry> mapEntries) {
            this.mapEntries = ParameterMapEntryListCopier.copy(mapEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapEntries(ParameterMapEntry ... mapEntries) {
            this.mapEntries(Arrays.asList(mapEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapEntries(Consumer<ParameterMapEntry.Builder> ... mapEntries) {
            this.mapEntries(Stream.of(mapEntries).map(c -> (ParameterMapEntry)((ParameterMapEntry.Builder)ParameterMapEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PolicyParameter build() {
            return new PolicyParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyParameter> {
        public Builder key(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder mapEntries(Collection<ParameterMapEntry> var1);

        public Builder mapEntries(ParameterMapEntry ... var1);

        public Builder mapEntries(Consumer<ParameterMapEntry.Builder> ... var1);
    }
}

