/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkAsyncClient;
import software.amazon.awssdk.services.mturk.internal.UserAgentUtils;
import software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest;
import software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse;

public class ListAssignmentsForHITPublisher
implements SdkPublisher<ListAssignmentsForHitResponse> {
    private final MTurkAsyncClient client;
    private final ListAssignmentsForHitRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssignmentsForHITPublisher(MTurkAsyncClient client, ListAssignmentsForHitRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssignmentsForHITPublisher(MTurkAsyncClient client, ListAssignmentsForHitRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssignmentsForHitResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssignmentsForHitResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAssignmentsForHitResponseFetcher
    implements AsyncPageFetcher<ListAssignmentsForHitResponse> {
        private ListAssignmentsForHitResponseFetcher() {
        }

        public boolean hasNextPage(ListAssignmentsForHitResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssignmentsForHitResponse> nextPage(ListAssignmentsForHitResponse previousPage) {
            if (previousPage == null) {
                return ListAssignmentsForHITPublisher.this.client.listAssignmentsForHIT(ListAssignmentsForHITPublisher.this.firstRequest);
            }
            return ListAssignmentsForHITPublisher.this.client.listAssignmentsForHIT((ListAssignmentsForHitRequest)((Object)ListAssignmentsForHITPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

