/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkAsyncClient;
import software.amazon.awssdk.services.mturk.internal.UserAgentUtils;
import software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest;
import software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse;

public class ListQualificationRequestsPublisher
implements SdkPublisher<ListQualificationRequestsResponse> {
    private final MTurkAsyncClient client;
    private final ListQualificationRequestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQualificationRequestsPublisher(MTurkAsyncClient client, ListQualificationRequestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQualificationRequestsPublisher(MTurkAsyncClient client, ListQualificationRequestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQualificationRequestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQualificationRequestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListQualificationRequestsResponseFetcher
    implements AsyncPageFetcher<ListQualificationRequestsResponse> {
        private ListQualificationRequestsResponseFetcher() {
        }

        public boolean hasNextPage(ListQualificationRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQualificationRequestsResponse> nextPage(ListQualificationRequestsResponse previousPage) {
            if (previousPage == null) {
                return ListQualificationRequestsPublisher.this.client.listQualificationRequests(ListQualificationRequestsPublisher.this.firstRequest);
            }
            return ListQualificationRequestsPublisher.this.client.listQualificationRequests((ListQualificationRequestsRequest)((Object)ListQualificationRequestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

